/*
 * Decompiled with CFR 0.152.
 */
package eightbitlab.com.blurview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.RecordingCanvas;
import android.graphics.RenderEffect;
import android.graphics.RenderNode;
import android.graphics.Shader;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import eightbitlab.com.blurview.BlurAlgorithm;
import eightbitlab.com.blurview.RenderScriptBlur;

@RequiresApi(value=31)
public class RenderEffectBlur
implements BlurAlgorithm {
    private final RenderNode node = new RenderNode("BlurViewNode");
    private int height;
    private int width;
    private float lastBlurRadius = 1.0f;
    @Nullable
    public BlurAlgorithm fallbackAlgorithm;
    private Context context;

    @Override
    public Bitmap blur(@NonNull Bitmap bitmap, float blurRadius) {
        this.lastBlurRadius = blurRadius;
        if (bitmap.getHeight() != this.height || bitmap.getWidth() != this.width) {
            this.height = bitmap.getHeight();
            this.width = bitmap.getWidth();
            this.node.setPosition(0, 0, this.width, this.height);
        }
        RecordingCanvas canvas = this.node.beginRecording();
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        this.node.endRecording();
        this.node.setRenderEffect(RenderEffect.createBlurEffect((float)blurRadius, (float)blurRadius, (Shader.TileMode)Shader.TileMode.MIRROR));
        return bitmap;
    }

    @Override
    public void destroy() {
        this.node.discardDisplayList();
        if (this.fallbackAlgorithm != null) {
            this.fallbackAlgorithm.destroy();
        }
    }

    @Override
    public boolean canModifyBitmap() {
        return true;
    }

    @Override
    @NonNull
    public Bitmap.Config getSupportedBitmapConfig() {
        return Bitmap.Config.ARGB_8888;
    }

    @Override
    public float scaleFactor() {
        return 6.0f;
    }

    @Override
    public void render(@NonNull Canvas canvas, @NonNull Bitmap bitmap) {
        if (canvas.isHardwareAccelerated()) {
            canvas.drawRenderNode(this.node);
        } else {
            if (this.fallbackAlgorithm == null) {
                this.fallbackAlgorithm = new RenderScriptBlur(this.context);
            }
            this.fallbackAlgorithm.blur(bitmap, this.lastBlurRadius);
            this.fallbackAlgorithm.render(canvas, bitmap);
        }
    }

    void setContext(@NonNull Context context) {
        this.context = context;
    }
}

