/*
 * Decompiled with CFR 0.152.
 */
package xyz.aprildown.ultimateringtonepicker.data;

import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import xyz.aprildown.ultimateringtonepicker.UltimateRingtonePicker;
import xyz.aprildown.ultimateringtonepicker.UtilsKt;
import xyz.aprildown.ultimateringtonepicker.data.Category;
import xyz.aprildown.ultimateringtonepicker.data.Ringtone;
import xyz.aprildown.ultimateringtonepicker.data.folder.RingtoneFolderRetrieverCompat;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u00062\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lxyz/aprildown/ultimateringtonepicker/data/DeviceRingtoneModel;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getAlbums", "", "Lxyz/aprildown/ultimateringtonepicker/data/Category;", "getAllDeviceRingtones", "Lxyz/aprildown/ultimateringtonepicker/data/Ringtone;", "getArtists", "getCategories", "categoryType", "Lxyz/aprildown/ultimateringtonepicker/UltimateRingtonePicker$RingtoneCategoryType;", "getFolderRingtones", "folderId", "", "getFolders", "xyz.aprildown.ultimateringtonepicker.library"})
public final class DeviceRingtoneModel {
    @NotNull
    private final Context context;

    public DeviceRingtoneModel(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Ringtone> getAllDeviceRingtones() {
        List data;
        block10: {
            data = new ArrayList();
            try {
                Object object = new String[]{"_id", "title", "artist_id", "album_id"};
                Cursor cursor = this.context.getContentResolver().query(UtilsKt.isQOrLater() ? MediaStore.Audio.Media.getContentUri((String)"external") : MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, object, "is_podcast == 0 AND\n(\n    is_music != 0 OR\n    is_alarm != 0 OR\n    is_notification != 0 OR\n    is_ringtone != 0\n)", null, "title_key");
                if (cursor == null) break block10;
                object = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    Cursor cursor2 = (Cursor)object;
                    boolean bl = false;
                    cursor2.moveToPosition(-1);
                    while (cursor2.moveToNext()) {
                        try {
                            Uri uri;
                            Intrinsics.checkNotNullExpressionValue((Object)ContentUris.withAppendedId((Uri)MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, (long)cursor2.getLong(cursor2.getColumnIndexOrThrow("_id"))), (String)"withAppendedId(...)");
                            String title = cursor2.getString(cursor2.getColumnIndexOrThrow("title"));
                            long artistId = cursor2.getLong(cursor2.getColumnIndexOrThrow("artist_id"));
                            long albumId = cursor2.getLong(cursor2.getColumnIndexOrThrow("album_id"));
                            Intrinsics.checkNotNull((Object)title);
                            data.add(new Ringtone(uri, title, artistId, albumId, false, 16, null));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Category> getArtists() {
        List data;
        block10: {
            data = new ArrayList();
            try {
                Object object = new String[]{"_id", "artist", "number_of_tracks"};
                Cursor cursor = this.context.getContentResolver().query(UtilsKt.isQOrLater() ? MediaStore.Audio.Artists.getContentUri((String)"external") : MediaStore.Audio.Artists.EXTERNAL_CONTENT_URI, object, null, null, "artist_key");
                if (cursor == null) break block10;
                object = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    Cursor cursor2 = (Cursor)object;
                    boolean bl = false;
                    cursor2.moveToPosition(-1);
                    while (cursor2.moveToNext()) {
                        try {
                            long id2 = cursor2.getLong(cursor2.getColumnIndexOrThrow("_id"));
                            String name = cursor2.getString(cursor2.getColumnIndexOrThrow("artist"));
                            int numOfTracks = cursor2.getInt(cursor2.getColumnIndexOrThrow("number_of_tracks"));
                            Intrinsics.checkNotNull((Object)name);
                            data.add(new Category(UltimateRingtonePicker.RingtoneCategoryType.Artist, id2, name, numOfTracks));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Category> getAlbums() {
        List data;
        block10: {
            data = new ArrayList();
            try {
                Object object = new String[]{"_id", "album", "numsongs"};
                Cursor cursor = this.context.getContentResolver().query(UtilsKt.isQOrLater() ? MediaStore.Audio.Albums.getContentUri((String)"external") : MediaStore.Audio.Albums.EXTERNAL_CONTENT_URI, object, null, null, "album_key");
                if (cursor == null) break block10;
                object = (Closeable)cursor;
                Throwable throwable = null;
                try {
                    Cursor cursor2 = (Cursor)object;
                    boolean bl = false;
                    cursor2.moveToPosition(-1);
                    while (cursor2.moveToNext()) {
                        try {
                            long id2 = cursor2.getLong(cursor2.getColumnIndexOrThrow("_id"));
                            String name = cursor2.getString(cursor2.getColumnIndexOrThrow("album"));
                            int numOfSongs = cursor2.getInt(cursor2.getColumnIndexOrThrow("numsongs"));
                            Intrinsics.checkNotNull((Object)name);
                            data.add(new Category(UltimateRingtonePicker.RingtoneCategoryType.Album, id2, name, numOfSongs));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return data;
    }

    private final List<Category> getFolders() {
        return new RingtoneFolderRetrieverCompat(this.context).getRingtoneFolders();
    }

    @NotNull
    public final List<Ringtone> getFolderRingtones(long folderId) {
        return new RingtoneFolderRetrieverCompat(this.context).getRingtonesFromFolder(folderId);
    }

    @NotNull
    public final List<Category> getCategories(@NotNull UltimateRingtonePicker.RingtoneCategoryType categoryType) {
        Intrinsics.checkNotNullParameter((Object)((Object)categoryType), (String)"categoryType");
        return switch (WhenMappings.$EnumSwitchMapping$0[categoryType.ordinal()]) {
            case 1 -> this.getArtists();
            case 2 -> this.getAlbums();
            case 3 -> this.getFolders();
            default -> throw new IllegalArgumentException("Wrong category categoryType: " + categoryType);
        };
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UltimateRingtonePicker.RingtoneCategoryType.values().length];
            try {
                nArray[UltimateRingtonePicker.RingtoneCategoryType.Artist.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UltimateRingtonePicker.RingtoneCategoryType.Album.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UltimateRingtonePicker.RingtoneCategoryType.Folder.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

