/*
 * Decompiled with CFR 0.152.
 */
package xyz.aprildown.ultimateringtonepicker.music;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioAttributes;
import android.media.AudioFocusRequest;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import androidx.annotation.RequiresApi;
import androidx.core.os.BundleCompat;
import java.io.Closeable;
import java.io.IOException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.aprildown.ultimateringtonepicker.UtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0003\u001c\u001d\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J*\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00182\b\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0006\u0010\u001b\u001a\u00020\u0012R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lxyz/aprildown/ultimateringtonepicker/music/AsyncRingtonePlayer;", "", "mContext", "Landroid/content/Context;", "(Landroid/content/Context;)V", "currentPlayingUri", "Landroid/net/Uri;", "getCurrentPlayingUri", "()Landroid/net/Uri;", "mHandler", "Landroid/os/Handler;", "mPlaybackDelegate", "Lxyz/aprildown/ultimateringtonepicker/music/AsyncRingtonePlayer$PlaybackDelegate;", "getMPlaybackDelegate", "()Lxyz/aprildown/ultimateringtonepicker/music/AsyncRingtonePlayer$PlaybackDelegate;", "mPlaybackDelegate$delegate", "Lkotlin/Lazy;", "checkAsyncRingtonePlayerThread", "", "play", "ringtoneUri", "loop", "", "streamType", "", "postMessage", "messageCode", "stop", "Companion", "MediaPlayerPlaybackDelegate", "PlaybackDelegate", "xyz.aprildown.ultimateringtonepicker.library"})
@SourceDebugExtension(value={"SMAP\nAsyncRingtonePlayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsyncRingtonePlayer.kt\nxyz/aprildown/ultimateringtonepicker/music/AsyncRingtonePlayer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,293:1\n1#2:294\n*E\n"})
public final class AsyncRingtonePlayer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context mContext;
    @NotNull
    private final Handler mHandler;
    @NotNull
    private final Lazy mPlaybackDelegate$delegate;
    private static final int EVENT_PLAY = 1;
    private static final int EVENT_STOP = 2;
    @NotNull
    private static final String RINGTONE_URI_KEY = "RINGTONE_URI_KEY";
    @NotNull
    private static final String LOOP = "LOOP";
    @NotNull
    private static final String STREAM_TYPE = "STREAM_TYPE";

    /*
     * WARNING - void declaration
     */
    public AsyncRingtonePlayer(@NotNull Context mContext) {
        void $this$mHandler_u24lambda_u240;
        HandlerThread handlerThread;
        Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
        this.mContext = mContext;
        HandlerThread handlerThread2 = handlerThread = new HandlerThread("ringtone-player");
        AsyncRingtonePlayer asyncRingtonePlayer = this;
        boolean bl = false;
        $this$mHandler_u24lambda_u240.start();
        Looper looper = handlerThread.getLooper();
        asyncRingtonePlayer.mHandler = new Handler(this, looper){
            final /* synthetic */ AsyncRingtonePlayer this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void handleMessage(@NotNull Message msg) {
                Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                switch (msg.what) {
                    case 1: {
                        Bundle data = msg.getData();
                        Uri uri = (Uri)BundleCompat.getParcelable((Bundle)data, (String)"RINGTONE_URI_KEY", Uri.class);
                        if (Intrinsics.areEqual((Object)uri, (Object)AsyncRingtonePlayer.access$getMPlaybackDelegate(this.this$0).getCurrentPlayingUri())) break;
                        AsyncRingtonePlayer.access$getMPlaybackDelegate(this.this$0).stop(AsyncRingtonePlayer.access$getMContext$p(this.this$0));
                        AsyncRingtonePlayer.access$getMPlaybackDelegate(this.this$0).play(AsyncRingtonePlayer.access$getMContext$p(this.this$0), uri, data.getBoolean("LOOP"), data.getInt("STREAM_TYPE"));
                        break;
                    }
                    case 2: {
                        AsyncRingtonePlayer.access$getMPlaybackDelegate(this.this$0).stop(AsyncRingtonePlayer.access$getMContext$p(this.this$0));
                    }
                }
            }
        };
        this.mPlaybackDelegate$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MediaPlayerPlaybackDelegate>(this){
            final /* synthetic */ AsyncRingtonePlayer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final MediaPlayerPlaybackDelegate invoke() {
                return this.this$0.new MediaPlayerPlaybackDelegate();
            }
        }));
    }

    private final PlaybackDelegate getMPlaybackDelegate() {
        Lazy lazy = this.mPlaybackDelegate$delegate;
        return (PlaybackDelegate)lazy.getValue();
    }

    public final void play(@NotNull Uri ringtoneUri, boolean loop, int streamType) {
        Intrinsics.checkNotNullParameter((Object)ringtoneUri, (String)"ringtoneUri");
        this.postMessage(1, ringtoneUri, loop, streamType);
    }

    public final void stop() {
        this.postMessage(2, null, false, 0);
    }

    @Nullable
    public final Uri getCurrentPlayingUri() {
        return this.getMPlaybackDelegate().getCurrentPlayingUri();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void postMessage(int messageCode, Uri ringtoneUri, boolean loop, int streamType) {
        AsyncRingtonePlayer asyncRingtonePlayer = this;
        synchronized (asyncRingtonePlayer) {
            boolean bl = false;
            Message message = this.mHandler.obtainMessage(messageCode);
            Intrinsics.checkNotNullExpressionValue((Object)message, (String)"obtainMessage(...)");
            Message message2 = message;
            if (ringtoneUri != null) {
                Bundle bundle = new Bundle();
                bundle.putParcelable(RINGTONE_URI_KEY, (Parcelable)ringtoneUri);
                bundle.putBoolean(LOOP, loop);
                bundle.putInt(STREAM_TYPE, streamType);
                message2.setData(bundle);
            }
            boolean bl2 = this.mHandler.sendMessage(message2);
        }
    }

    private final void checkAsyncRingtonePlayerThread() {
        if (!Intrinsics.areEqual((Object)Looper.myLooper(), (Object)this.mHandler.getLooper())) {
            boolean bl = false;
            String string2 = "Must be on the AsyncRingtonePlayer thread!";
            throw new IllegalStateException(string2.toString());
        }
    }

    public static final /* synthetic */ PlaybackDelegate access$getMPlaybackDelegate(AsyncRingtonePlayer $this) {
        return $this.getMPlaybackDelegate();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lxyz/aprildown/ultimateringtonepicker/music/AsyncRingtonePlayer$Companion;", "", "()V", "EVENT_PLAY", "", "EVENT_STOP", "LOOP", "", "RINGTONE_URI_KEY", "STREAM_TYPE", "xyz.aprildown.ultimateringtonepicker.library"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0003J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0013H\u0016J*\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u0013H\u0016J\b\u0010 \u001a\u00020\u0018H\u0002J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lxyz/aprildown/ultimateringtonepicker/music/AsyncRingtonePlayer$MediaPlayerPlaybackDelegate;", "Lxyz/aprildown/ultimateringtonepicker/music/AsyncRingtonePlayer$PlaybackDelegate;", "Landroid/media/AudioManager$OnAudioFocusChangeListener;", "(Lxyz/aprildown/ultimateringtonepicker/music/AsyncRingtonePlayer;)V", "audioAttributes", "Landroid/media/AudioAttributes;", "currentPlayingUri", "Landroid/net/Uri;", "getCurrentPlayingUri", "()Landroid/net/Uri;", "setCurrentPlayingUri", "(Landroid/net/Uri;)V", "mAudioManager", "Landroid/media/AudioManager;", "mLoop", "", "mMediaPlayer", "Landroid/media/MediaPlayer;", "mStreamType", "", "createAudioFocusRequest", "Landroid/media/AudioFocusRequest;", "aa", "onAudioFocusChange", "", "focusChange", "play", "context", "Landroid/content/Context;", "ringtoneUri", "loop", "streamType", "startPlayback", "stop", "xyz.aprildown.ultimateringtonepicker.library"})
    private final class MediaPlayerPlaybackDelegate
    implements PlaybackDelegate,
    AudioManager.OnAudioFocusChangeListener {
        @Nullable
        private AudioManager mAudioManager;
        @Nullable
        private MediaPlayer mMediaPlayer;
        private boolean mLoop;
        private int mStreamType;
        @Nullable
        private AudioAttributes audioAttributes;
        @Nullable
        private Uri currentPlayingUri;

        @Override
        @Nullable
        public Uri getCurrentPlayingUri() {
            return this.currentPlayingUri;
        }

        @Override
        public void setCurrentPlayingUri(@Nullable Uri uri) {
            this.currentPlayingUri = uri;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void play(@NotNull Context context, @Nullable Uri ringtoneUri, boolean loop, int streamType) {
            Uri alarmNoise;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            AsyncRingtonePlayer.this.checkAsyncRingtonePlayerThread();
            this.mLoop = loop;
            this.mStreamType = streamType;
            this.audioAttributes = new AudioAttributes.Builder().setLegacyStreamType(this.mStreamType).build();
            if (this.mAudioManager == null) {
                Object object = context.getSystemService("audio");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.media.AudioManager");
                this.mAudioManager = (AudioManager)object;
            }
            if ((alarmNoise = ringtoneUri) == null) {
                alarmNoise = RingtoneManager.getDefaultUri((int)4);
            }
            MediaPlayer mediaPlayer2 = this.mMediaPlayer = new MediaPlayer();
            if (mediaPlayer2 != null) {
                mediaPlayer2.setOnErrorListener((arg_0, arg_1, arg_2) -> MediaPlayerPlaybackDelegate.play$lambda$0(this, context, arg_0, arg_1, arg_2));
            }
            try {
                this.setCurrentPlayingUri(alarmNoise);
                Object object = alarmNoise;
                boolean bl = object != null && (object = object.toString()) != null ? StringsKt.startsWith$default((String)object, (String)"file:///android_asset/", (boolean)false, (int)2, null) : false;
                if (bl) {
                    String string2 = alarmNoise.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                    String fileName = StringsKt.removePrefix((String)string2, (CharSequence)"file:///android_asset/");
                    Closeable closeable = (Closeable)AsyncRingtonePlayer.this.mContext.getAssets().openFd(fileName);
                    Throwable throwable = null;
                    try {
                        Unit unit;
                        AssetFileDescriptor afd = (AssetFileDescriptor)closeable;
                        boolean bl2 = false;
                        MediaPlayer mediaPlayer3 = this.mMediaPlayer;
                        if (mediaPlayer3 != null) {
                            mediaPlayer3.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength());
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        Unit unit2 = unit;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                } else {
                    MediaPlayer mediaPlayer4 = this.mMediaPlayer;
                    if (mediaPlayer4 != null) {
                        Uri uri = alarmNoise;
                        Intrinsics.checkNotNull((Object)uri);
                        mediaPlayer4.setDataSource(context, uri);
                    }
                }
                this.startPlayback();
            }
            catch (Throwable t) {
                this.setCurrentPlayingUri(null);
                try {
                    MediaPlayer mediaPlayer5;
                    MediaPlayer mediaPlayer6 = mediaPlayer5 = this.mMediaPlayer;
                    if (mediaPlayer6 != null) {
                        mediaPlayer6.reset();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        private final void startPlayback() throws IOException {
            block7: {
                AudioManager audioManager = this.mAudioManager;
                boolean bl = audioManager != null ? audioManager.getStreamVolume(this.mStreamType) == 0 : false;
                if (bl) {
                    return;
                }
                MediaPlayer mediaPlayer2 = this.mMediaPlayer;
                if (mediaPlayer2 != null) {
                    mediaPlayer2.setAudioAttributes(this.audioAttributes);
                }
                MediaPlayer mediaPlayer3 = this.mMediaPlayer;
                if (mediaPlayer3 == null) break block7;
                MediaPlayer mediaPlayer4 = mediaPlayer3;
                AsyncRingtonePlayer asyncRingtonePlayer = AsyncRingtonePlayer.this;
                MediaPlayer $this$startPlayback_u24lambda_u243 = mediaPlayer4;
                boolean bl2 = false;
                $this$startPlayback_u24lambda_u243.setLooping(this.mLoop);
                if (!this.mLoop) {
                    $this$startPlayback_u24lambda_u243.setOnCompletionListener(arg_0 -> MediaPlayerPlaybackDelegate.startPlayback$lambda$3$lambda$2(this, asyncRingtonePlayer, arg_0));
                }
                $this$startPlayback_u24lambda_u243.prepare();
                if (UtilsKt.isOOrLater()) {
                    AudioManager audioManager2 = this.mAudioManager;
                    if (audioManager2 != null) {
                        AudioAttributes audioAttributes = this.audioAttributes;
                        Intrinsics.checkNotNull((Object)audioAttributes);
                        audioManager2.requestAudioFocus(this.createAudioFocusRequest(audioAttributes));
                    }
                } else {
                    AudioManager audioManager3 = this.mAudioManager;
                    if (audioManager3 != null) {
                        audioManager3.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this, this.mStreamType, 2);
                    }
                }
                $this$startPlayback_u24lambda_u243.start();
            }
        }

        public void onAudioFocusChange(int focusChange) {
            switch (focusChange) {
                case -3: 
                case -1: {
                    AsyncRingtonePlayer.this.stop();
                }
            }
        }

        @Override
        public void stop(@NotNull Context context) {
            block5: {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    AsyncRingtonePlayer.this.checkAsyncRingtonePlayerThread();
                    this.setCurrentPlayingUri(null);
                    if (this.mMediaPlayer != null) {
                        MediaPlayer mediaPlayer2 = this.mMediaPlayer;
                        if (mediaPlayer2 != null) {
                            mediaPlayer2.stop();
                        }
                        MediaPlayer mediaPlayer3 = this.mMediaPlayer;
                        if (mediaPlayer3 != null) {
                            mediaPlayer3.release();
                        }
                        this.mMediaPlayer = null;
                    }
                    if (!UtilsKt.isOOrLater()) break block4;
                    if (this.audioAttributes == null) break block5;
                    AudioManager audioManager = this.mAudioManager;
                    if (audioManager != null) {
                        AudioAttributes audioAttributes = this.audioAttributes;
                        Intrinsics.checkNotNull((Object)audioAttributes);
                        audioManager.abandonAudioFocusRequest(this.createAudioFocusRequest(audioAttributes));
                    }
                    break block5;
                }
                AudioManager audioManager = this.mAudioManager;
                if (audioManager == null) break block5;
                audioManager.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)this);
            }
        }

        @TargetApi(value=26)
        @RequiresApi(value=26)
        private final AudioFocusRequest createAudioFocusRequest(AudioAttributes aa) {
            AudioFocusRequest audioFocusRequest = new AudioFocusRequest.Builder(2).setOnAudioFocusChangeListener((AudioManager.OnAudioFocusChangeListener)this).setAcceptsDelayedFocusGain(false).setWillPauseWhenDucked(false).setAudioAttributes(aa).build();
            Intrinsics.checkNotNullExpressionValue((Object)audioFocusRequest, (String)"build(...)");
            return audioFocusRequest;
        }

        private static final boolean play$lambda$0(MediaPlayerPlaybackDelegate this$0, Context $context, MediaPlayer mediaPlayer2, int n, int n2) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
            this$0.stop($context);
            return true;
        }

        private static final void startPlayback$lambda$3$lambda$2(MediaPlayerPlaybackDelegate this$0, AsyncRingtonePlayer this$1, MediaPlayer it) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
            this$0.stop(this$1.mContext);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\bb\u0018\u00002\u00020\u0001J*\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H&J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&R\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lxyz/aprildown/ultimateringtonepicker/music/AsyncRingtonePlayer$PlaybackDelegate;", "", "currentPlayingUri", "Landroid/net/Uri;", "getCurrentPlayingUri", "()Landroid/net/Uri;", "setCurrentPlayingUri", "(Landroid/net/Uri;)V", "play", "", "context", "Landroid/content/Context;", "ringtoneUri", "loop", "", "streamType", "", "stop", "xyz.aprildown.ultimateringtonepicker.library"})
    private static interface PlaybackDelegate {
        @Nullable
        public Uri getCurrentPlayingUri();

        public void setCurrentPlayingUri(@Nullable Uri var1);

        public void play(@NotNull Context var1, @Nullable Uri var2, boolean var3, int var4);

        public void stop(@NotNull Context var1);
    }
}

