/*
 * Decompiled with CFR 0.152.
 */
package xyz.aprildown.ultimatemusicpicker.ui;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.view.ContextMenu;
import android.view.MenuItem;
import android.view.View;
import androidx.lifecycle.LifecycleOwner;
import androidx.loader.app.LoaderManager;
import androidx.loader.content.AsyncTaskLoader;
import androidx.loader.content.Loader;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.aprildown.ultimatemusicpicker.MusicPickerSetting;
import xyz.aprildown.ultimatemusicpicker.R;
import xyz.aprildown.ultimatemusicpicker.UtilsKt;
import xyz.aprildown.ultimatemusicpicker.data.CustomMusic;
import xyz.aprildown.ultimatemusicpicker.data.MusicModel;
import xyz.aprildown.ultimatemusicpicker.ui.AddCustomItem;
import xyz.aprildown.ultimatemusicpicker.ui.HeaderItem;
import xyz.aprildown.ultimatemusicpicker.ui.MusicListItem;
import xyz.aprildown.ultimatemusicpicker.ui.PickerBaseFragment;
import xyz.aprildown.ultimatemusicpicker.ui.SoundItem;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J&\u0010\f\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J&\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u00142\u0006\u0010\u0017\u001a\u00020\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0016\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J,\u0010\"\u001a\u00020\u00072\u0012\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u00142\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015H\u0016J\u0010\u0010%\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010&\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lxyz/aprildown/ultimatemusicpicker/ui/PickerNormalFragment;", "Lxyz/aprildown/ultimatemusicpicker/ui/PickerBaseFragment;", "Landroid/view/View$OnCreateContextMenuListener;", "()V", "indexOfMusicToRemove", "", "init", "", "onContextItemSelected", "", "item", "Landroid/view/MenuItem;", "onCreateContextMenu", "menu", "Landroid/view/ContextMenu;", "v", "Landroid/view/View;", "menuInfo", "Landroid/view/ContextMenu$ContextMenuInfo;", "onCreateLoader", "Landroidx/loader/content/Loader;", "", "Lxyz/aprildown/ultimatemusicpicker/ui/MusicListItem;", "id", "args", "Landroid/os/Bundle;", "onCustomPicked", "uri", "Landroid/net/Uri;", "title", "", "onItemClicked", "viewHolder", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "onLoadFinished", "loader", "data", "removeCustomMusic", "shouldShowContextMenu", "MusicLoader", "library_release"})
public final class PickerNormalFragment
extends PickerBaseFragment
implements View.OnCreateContextMenuListener {
    private int indexOfMusicToRemove = -1;

    @Override
    public void init() {
        this.registerForContextMenu((View)this.getRecyclerView());
        this.getRecyclerView().setOnCreateContextMenuListener((View.OnCreateContextMenuListener)this);
    }

    @Override
    public boolean shouldShowContextMenu() {
        return true;
    }

    @NotNull
    public Loader<List<MusicListItem>> onCreateLoader(int id2, @Nullable Bundle args) {
        MusicPickerSetting musicPickerSetting = this.getViewModel().getSetting();
        boolean bl = false;
        boolean bl2 = false;
        MusicPickerSetting $this$run = musicPickerSetting;
        boolean bl3 = false;
        Context context = this.requireContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"requireContext()");
        return (Loader)new MusicLoader(context, this.getViewModel().getMusicModel(), $this$run.getMusicTypes(), $this$run.getHasDefault(), $this$run.getDefaultTitle(), $this$run.getDefaultUri(), $this$run.getHasSilent(), $this$run.getAdditional());
    }

    public void onLoadFinished(@NotNull Loader<List<MusicListItem>> loader, @Nullable List<? extends MusicListItem> data) {
        Intrinsics.checkParameterIsNotNull(loader, (String)"loader");
        if (data != null) {
            this.getMusicAdapter().populateData(data);
            SoundItem toSelect = this.getSoundItem(this.getViewModel().getSelectedUri());
            this.getParent().getMusicPlayer$library_release().stop();
            if (toSelect != null) {
                toSelect.setSelected(true);
                this.getViewModel().setSelectedUri(toSelect.getUri());
                this.notifyItemChanged(toSelect, true);
            } else {
                this.getViewModel().setSelectedUri(null);
                this.getViewModel().setPreviewPlaying(false);
            }
        }
    }

    public final void onCustomPicked(@NotNull Uri uri, @NotNull String title) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        this.getViewModel().getMusicModel().addCustomMusic(uri, title);
        this.getViewModel().setSelectedUri(uri);
        this.getViewModel().setPreviewPlaying(false);
        LoaderManager.getInstance((LifecycleOwner)((LifecycleOwner)this)).restartLoader(0, null, (LoaderManager.LoaderCallbacks)this);
    }

    public boolean onContextItemSelected(@Nullable MenuItem item) {
        MusicListItem toRemove = (MusicListItem)CollectionsKt.getOrNull(this.getMusicAdapter().getData(), (int)this.indexOfMusicToRemove);
        if (toRemove instanceof SoundItem) {
            this.indexOfMusicToRemove = -1;
            this.removeCustomMusic(((SoundItem)toRemove).getUri());
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void onCreateContextMenu(@Nullable ContextMenu menu, @Nullable View v, @Nullable ContextMenu.ContextMenuInfo menuInfo) {
        int n;
        MenuItem.OnMenuItemClickListener listener2 = new MenuItem.OnMenuItemClickListener(this){
            final /* synthetic */ PickerNormalFragment this$0;

            public final boolean onMenuItemClick(MenuItem item) {
                this.this$0.onContextItemSelected(item);
                return true;
            }
            {
                this.this$0 = pickerNormalFragment;
            }
        };
        int n2 = 0;
        ContextMenu contextMenu = menu;
        int n3 = n = contextMenu != null ? contextMenu.size() : 0;
        while (n2 < n) {
            void i;
            ContextMenu contextMenu2 = menu;
            if (contextMenu2 != null && (contextMenu2 = contextMenu2.getItem((int)i)) != null) {
                contextMenu2.setOnMenuItemClickListener(listener2);
            }
            ++i;
        }
    }

    @Override
    public void onItemClicked(@NotNull RecyclerView.ViewHolder viewHolder, int id2) {
        Intrinsics.checkParameterIsNotNull((Object)viewHolder, (String)"viewHolder");
        switch (id2) {
            case 0: {
                this.onMusicItemClicked(viewHolder);
                break;
            }
            case 0x7FFFFFFF: {
                this.getParent().toCustom$library_release();
                break;
            }
            case -1: {
                this.indexOfMusicToRemove = viewHolder.getAdapterPosition();
            }
        }
    }

    private final void removeCustomMusic(Uri uri) {
        block2: {
            this.getViewModel().getMusicModel().removeCustomMusic(uri);
            SoundItem soundItem = this.getSoundItem(uri);
            if (soundItem == null) break block2;
            SoundItem soundItem2 = soundItem;
            boolean bl = false;
            boolean bl2 = false;
            SoundItem toRemove = soundItem2;
            boolean bl3 = false;
            if (toRemove.isSelected()) {
                this.getParent().stopPlayingMusic$library_release(toRemove, false);
                PickerBaseFragment.notifyItemChanged$default(this, toRemove, false, 1, null);
                SoundItem soundItem3 = this.getSoundItem(this.getViewModel().getSetting().getDefaultUri());
                if (soundItem3 != null) {
                    SoundItem soundItem4 = soundItem3;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    SoundItem soundItem5 = soundItem4;
                    boolean bl6 = false;
                    soundItem5.setSelected(true);
                    this.getViewModel().setSelectedUri(soundItem5.getUri());
                    PickerBaseFragment.notifyItemChanged$default(this, soundItem5, false, 1, null);
                }
            }
            this.getMusicAdapter().removeViewHolder(toRemove);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001BW\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000b\u0012\u0018\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000f0\u00120\u0002\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0014R \u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000f0\u00120\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0002X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lxyz/aprildown/ultimatemusicpicker/ui/PickerNormalFragment$MusicLoader;", "Landroidx/loader/content/AsyncTaskLoader;", "", "Lxyz/aprildown/ultimatemusicpicker/ui/MusicListItem;", "context", "Landroid/content/Context;", "musicModel", "Lxyz/aprildown/ultimatemusicpicker/data/MusicModel;", "musicTypes", "", "hasDefault", "", "defaultTitle", "", "defaultUri", "Landroid/net/Uri;", "hasSilent", "additional", "Lkotlin/Pair;", "(Landroid/content/Context;Lxyz/aprildown/ultimatemusicpicker/data/MusicModel;[IZLjava/lang/String;Landroid/net/Uri;ZLjava/util/List;)V", "customMusics", "Lxyz/aprildown/ultimatemusicpicker/data/CustomMusic;", "loadInBackground", "onStartLoading", "", "library_release"})
    private static final class MusicLoader
    extends AsyncTaskLoader<List<? extends MusicListItem>> {
        private List<CustomMusic> customMusics;
        private final MusicModel musicModel;
        private final int[] musicTypes;
        private final boolean hasDefault;
        private final String defaultTitle;
        private final Uri defaultUri;
        private final boolean hasSilent;
        private final List<Pair<String, Uri>> additional;

        protected void onStartLoading() {
            super.onStartLoading();
            this.customMusics = this.musicModel.getCustomMusics();
            this.forceLoad();
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public List<MusicListItem> loadInBackground() {
            boolean $i$f$forEach;
            this.musicModel.loadMusicTitles(Arrays.copyOf(this.musicTypes, this.musicTypes.length));
            Context context = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            Context context2 = context;
            boolean bl = false;
            List items = new ArrayList();
            if (ArraysKt.contains((int[])this.musicTypes, (int)8)) {
                String string2 = context2.getString(R.string.your_sounds);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.getString(R.string.your_sounds)");
                items.add(new HeaderItem(string2));
                List<CustomMusic> list = this.customMusics;
                if (list == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"customMusics");
                }
                Iterable $this$forEach$iv = list;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    CustomMusic it = (CustomMusic)element$iv;
                    boolean bl2 = false;
                    items.add(new SoundItem(0, it.getUri(), it.getTitle(), false, false));
                }
                items.add(AddCustomItem.INSTANCE);
            }
            String string3 = context2.getString(R.string.device_sounds);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"context.getString(R.string.device_sounds)");
            items.add(new HeaderItem(string3));
            if (this.hasSilent) {
                Uri uri = UtilsKt.getMUSIC_SILENT();
                String string4 = context2.getString(R.string.silent_ringtone_title);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"context.getString(R.string.silent_ringtone_title)");
                items.add(new SoundItem(1, uri, string4, false, false));
            }
            if (this.hasDefault && Intrinsics.areEqual((Object)this.defaultUri, (Object)UtilsKt.getMUSIC_SILENT()) ^ true) {
                CharSequence $this$forEach$iv = this.defaultTitle;
                Uri uri = this.defaultUri;
                int n = 2;
                List list = items;
                $i$f$forEach = false;
                boolean bl3 = $this$forEach$iv.length() == 0;
                String string5 = bl3 ? context2.getString(R.string.default_ringtone_title) : this.defaultTitle;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"if (defaultTitle.isEmpty\u2026_title) else defaultTitle");
                boolean bl4 = false;
                boolean bl5 = false;
                String string6 = string5;
                Uri uri2 = uri;
                int n2 = n;
                list.add(new SoundItem(n2, uri2, string6, bl5, bl4));
            }
            Iterable $this$forEach$iv22 = this.additional;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv22) {
                Pair $dstr$title$uri = (Pair)element$iv;
                boolean bl6 = false;
                String title = (String)$dstr$title$uri.component1();
                Uri uri = (Uri)$dstr$title$uri.component2();
                items.add(new SoundItem(2, uri, title, false, false));
            }
            int $this$forEach$iv22 = 0;
            int n = this.musicTypes.length;
            while ($this$forEach$iv22 < n) {
                Integer n3;
                void index;
                int type = this.musicTypes[index];
                switch (type) {
                    case 4: {
                        n3 = R.string.music_type_alarm;
                        break;
                    }
                    case 2: {
                        n3 = R.string.music_type_notification;
                        break;
                    }
                    case 1: {
                        n3 = R.string.music_type_ringtone;
                        break;
                    }
                    default: {
                        n3 = null;
                    }
                }
                if (n3 == null) {
                } else {
                    int title = n3;
                    String string7 = context2.getString(title);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"context.getString(title)");
                    items.add(new HeaderItem(string7));
                    Iterable $this$forEach$iv = this.musicModel.getRingtones(type);
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Uri it = (Uri)element$iv;
                        boolean bl7 = false;
                        items.add(new SoundItem(2, it, this.musicModel.getMusicTitle(it), false, false));
                    }
                }
                ++index;
            }
            return items;
        }

        public MusicLoader(@NotNull Context context, @NotNull MusicModel musicModel, @NotNull int[] musicTypes, boolean hasDefault, @NotNull String defaultTitle, @NotNull Uri defaultUri, boolean hasSilent, @NotNull List<? extends Pair<String, ? extends Uri>> additional) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)musicModel, (String)"musicModel");
            Intrinsics.checkParameterIsNotNull((Object)musicTypes, (String)"musicTypes");
            Intrinsics.checkParameterIsNotNull((Object)defaultTitle, (String)"defaultTitle");
            Intrinsics.checkParameterIsNotNull((Object)defaultUri, (String)"defaultUri");
            Intrinsics.checkParameterIsNotNull(additional, (String)"additional");
            super(context);
            this.musicModel = musicModel;
            this.musicTypes = musicTypes;
            this.hasDefault = hasDefault;
            this.defaultTitle = defaultTitle;
            this.defaultUri = defaultUri;
            this.hasSilent = hasSilent;
            this.additional = additional;
        }
    }
}

