/*
 * Decompiled with CFR 0.152.
 */
package xyz.aprildown.ultimatemusicpicker.ui;

import android.content.Context;
import android.graphics.Color;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.aprildown.ultimatemusicpicker.R;
import xyz.aprildown.ultimatemusicpicker.UtilsKt;
import xyz.aprildown.ultimatemusicpicker.ui.AddCustomItem;
import xyz.aprildown.ultimatemusicpicker.ui.HeaderItem;
import xyz.aprildown.ultimatemusicpicker.ui.MusicListItem;
import xyz.aprildown.ultimatemusicpicker.ui.SoundItem;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0006\u001c\u001d\u001e\u001f !B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u0018\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000eH\u0016J\u0014\u0010\u0018\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\fJ\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lxyz/aprildown/ultimatemusicpicker/ui/MusicAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lxyz/aprildown/ultimatemusicpicker/ui/MusicAdapter$BaseViewHolder;", "listener", "Lxyz/aprildown/ultimatemusicpicker/ui/MusicAdapter$OnItemCLickedListener;", "showContextMenu", "", "(Lxyz/aprildown/ultimatemusicpicker/ui/MusicAdapter$OnItemCLickedListener;Z)V", "values", "", "Lxyz/aprildown/ultimatemusicpicker/ui/MusicListItem;", "getData", "", "getItemCount", "", "getItemViewType", "position", "onBindViewHolder", "", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "populateData", "data", "removeViewHolder", "Lxyz/aprildown/ultimatemusicpicker/ui/SoundItem;", "AddCustomViewHolder", "BaseViewHolder", "Companion", "HeaderViewHolder", "OnItemCLickedListener", "SoundViewHolder", "library_release"})
public final class MusicAdapter
extends RecyclerView.Adapter<BaseViewHolder> {
    private final List<MusicListItem> values;
    private final OnItemCLickedListener listener;
    private final boolean showContextMenu;
    public static final int CLICK_NORMAL = 0;
    public static final int CLICK_LONG_PRESS = -1;
    public static final int CLICK_ADD_NEW = Integer.MAX_VALUE;
    private static final int ITEM_VIEW_TYPE_HEADER = 0;
    private static final int ITEM_VIEW_TYPE_ADD_CUSTOM = 1;
    private static final int ITEM_VIEW_TYPE_SOUND = 2;
    public static final Companion Companion = new Companion(null);

    public int getItemCount() {
        return this.values.size();
    }

    public int getItemViewType(int position) {
        int n;
        MusicListItem musicListItem = this.values.get(position);
        if (musicListItem instanceof HeaderItem) {
            n = 0;
        } else if (musicListItem instanceof AddCustomItem) {
            n = 1;
        } else if (musicListItem instanceof SoundItem) {
            n = 2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    @NotNull
    public BaseViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        BaseViewHolder baseViewHolder;
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        Function1<Integer, View> $fun$inflateView$1 = new Function1<Integer, View>(parent){
            final /* synthetic */ ViewGroup $parent;

            @NotNull
            public final View invoke(int layoutRes) {
                View view = LayoutInflater.from((Context)this.$parent.getContext()).inflate(layoutRes, this.$parent, false);
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"LayoutInflater.from(pare\u2026layoutRes, parent, false)");
                return view;
            }
            {
                this.$parent = viewGroup;
                super(1);
            }
        };
        switch (viewType) {
            case 0: {
                baseViewHolder = new HeaderViewHolder($fun$inflateView$1.invoke(R.layout.music_section_header), this.listener);
                break;
            }
            case 1: {
                baseViewHolder = new AddCustomViewHolder($fun$inflateView$1.invoke(R.layout.music_item_sound), this.listener);
                break;
            }
            case 2: {
                baseViewHolder = new SoundViewHolder($fun$inflateView$1.invoke(R.layout.music_item_sound), this.listener, this.showContextMenu);
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Wrong viewType: " + viewType);
            }
        }
        return baseViewHolder;
    }

    public void onBindViewHolder(@NotNull BaseViewHolder holder, int position) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)holder), (String)"holder");
        holder.bind(this.values.get(position));
    }

    @NotNull
    public final List<MusicListItem> getData() {
        return this.values;
    }

    public final void populateData(@NotNull List<? extends MusicListItem> data) {
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        this.values.clear();
        this.values.addAll((Collection<MusicListItem>)data);
        this.notifyDataSetChanged();
    }

    public final void removeViewHolder(@NotNull SoundItem holder) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        int index = this.values.indexOf(holder);
        int n = index;
        if (0 <= n && this.values.size() > n) {
            this.values.remove(index);
            this.notifyItemRemoved(index);
        }
    }

    public MusicAdapter(@NotNull OnItemCLickedListener listener2, boolean showContextMenu) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.listener = listener2;
        this.showContextMenu = showContextMenu;
        MusicAdapter musicAdapter = this;
        boolean bl = false;
        musicAdapter.values = list = (List)new ArrayList();
    }

    public /* synthetic */ MusicAdapter(OnItemCLickedListener onItemCLickedListener, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(onItemCLickedListener, bl);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lxyz/aprildown/ultimatemusicpicker/ui/MusicAdapter$OnItemCLickedListener;", "", "onItemClicked", "", "viewHolder", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "id", "", "library_release"})
    public static interface OnItemCLickedListener {
        public void onItemClicked(@NotNull RecyclerView.ViewHolder var1, int var2);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH&R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lxyz/aprildown/ultimatemusicpicker/ui/MusicAdapter$BaseViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "view", "Landroid/view/View;", "listener", "Lxyz/aprildown/ultimatemusicpicker/ui/MusicAdapter$OnItemCLickedListener;", "(Landroid/view/View;Lxyz/aprildown/ultimatemusicpicker/ui/MusicAdapter$OnItemCLickedListener;)V", "getListener", "()Lxyz/aprildown/ultimatemusicpicker/ui/MusicAdapter$OnItemCLickedListener;", "bind", "", "item", "Lxyz/aprildown/ultimatemusicpicker/ui/MusicListItem;", "library_release"})
    public static abstract class BaseViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final OnItemCLickedListener listener;

        public abstract void bind(@NotNull MusicListItem var1);

        @NotNull
        protected final OnItemCLickedListener getListener() {
            return this.listener;
        }

        public BaseViewHolder(@NotNull View view, @NotNull OnItemCLickedListener listener2) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
            super(view);
            this.listener = listener2;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lxyz/aprildown/ultimatemusicpicker/ui/MusicAdapter$HeaderViewHolder;", "Lxyz/aprildown/ultimatemusicpicker/ui/MusicAdapter$BaseViewHolder;", "view", "Landroid/view/View;", "listener", "Lxyz/aprildown/ultimatemusicpicker/ui/MusicAdapter$OnItemCLickedListener;", "(Landroid/view/View;Lxyz/aprildown/ultimatemusicpicker/ui/MusicAdapter$OnItemCLickedListener;)V", "titleView", "Landroid/widget/TextView;", "kotlin.jvm.PlatformType", "bind", "", "item", "Lxyz/aprildown/ultimatemusicpicker/ui/MusicListItem;", "library_release"})
    public static final class HeaderViewHolder
    extends BaseViewHolder {
        private final TextView titleView;

        @Override
        public void bind(@NotNull MusicListItem item) {
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            if (item instanceof HeaderItem) {
                TextView textView = this.titleView;
                Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"titleView");
                textView.setText((CharSequence)((HeaderItem)item).getTitle());
            }
        }

        public HeaderViewHolder(@NotNull View view, @NotNull OnItemCLickedListener listener2) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
            super(view, listener2);
            this.titleView = (TextView)view.findViewById(R.id.textItemHeader);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0016\u00a8\u0006\u000e"}, d2={"Lxyz/aprildown/ultimatemusicpicker/ui/MusicAdapter$AddCustomViewHolder;", "Lxyz/aprildown/ultimatemusicpicker/ui/MusicAdapter$BaseViewHolder;", "Landroid/view/View$OnClickListener;", "view", "Landroid/view/View;", "listener", "Lxyz/aprildown/ultimatemusicpicker/ui/MusicAdapter$OnItemCLickedListener;", "(Landroid/view/View;Lxyz/aprildown/ultimatemusicpicker/ui/MusicAdapter$OnItemCLickedListener;)V", "bind", "", "item", "Lxyz/aprildown/ultimatemusicpicker/ui/MusicListItem;", "onClick", "v", "library_release"})
    public static final class AddCustomViewHolder
    extends BaseViewHolder
    implements View.OnClickListener {
        @Override
        public void bind(@NotNull MusicListItem item) {
            TextView nameView;
            ImageView selectedView;
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            this.itemView.setOnClickListener((View.OnClickListener)this);
            ImageView imageView = selectedView = (ImageView)this.itemView.findViewById(R.id.imageSelected);
            Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"selectedView");
            imageView.setVisibility(8);
            TextView textView = nameView = (TextView)this.itemView.findViewById(R.id.textSoundName);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"nameView");
            View view = this.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
            textView.setText((CharSequence)view.getContext().getString(R.string.add_new_sound));
            ImageView imageView2 = (ImageView)this.itemView.findViewById(R.id.imageSound);
            imageView2.setImageResource(R.drawable.ic_add_custom);
        }

        public void onClick(@Nullable View v) {
            this.getListener().onItemClicked(this, Integer.MAX_VALUE);
        }

        public AddCustomViewHolder(@NotNull View view, @NotNull OnItemCLickedListener listener2) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
            super(view, listener2);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u0016J&\u0010\u0017\u001a\u00020\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u0016\u001a\u0004\u0018\u00010\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \r*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lxyz/aprildown/ultimatemusicpicker/ui/MusicAdapter$SoundViewHolder;", "Lxyz/aprildown/ultimatemusicpicker/ui/MusicAdapter$BaseViewHolder;", "Landroid/view/View$OnClickListener;", "Landroid/view/View$OnCreateContextMenuListener;", "view", "Landroid/view/View;", "listener", "Lxyz/aprildown/ultimatemusicpicker/ui/MusicAdapter$OnItemCLickedListener;", "showContextMenu", "", "(Landroid/view/View;Lxyz/aprildown/ultimatemusicpicker/ui/MusicAdapter$OnItemCLickedListener;Z)V", "imageSelected", "Landroid/widget/ImageView;", "kotlin.jvm.PlatformType", "imageSound", "textSoundName", "Landroid/widget/TextView;", "bind", "", "item", "Lxyz/aprildown/ultimatemusicpicker/ui/MusicListItem;", "onClick", "v", "onCreateContextMenu", "menu", "Landroid/view/ContextMenu;", "menuInfo", "Landroid/view/ContextMenu$ContextMenuInfo;", "library_release"})
    public static final class SoundViewHolder
    extends BaseViewHolder
    implements View.OnClickListener,
    View.OnCreateContextMenuListener {
        private final ImageView imageSound;
        private final TextView textSoundName;
        private final ImageView imageSelected;
        private final boolean showContextMenu;

        @Override
        public void bind(@NotNull MusicListItem item) {
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            if (item instanceof SoundItem) {
                TextView textView = this.textSoundName;
                Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"textSoundName");
                textView.setText((CharSequence)((SoundItem)item).getTitle());
                this.imageSound.clearColorFilter();
                int itemType = ((SoundItem)item).getType();
                this.imageSound.setImageResource(itemType == 0 ? R.drawable.ic_custom_music : (itemType == 1 ? R.drawable.ic_ringtone_silent : (((SoundItem)item).isPlaying() ? R.drawable.ic_ringtone_active : R.drawable.ic_ringtone_normal)));
                ImageView imageView = this.imageSound;
                Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"imageSound");
                UtilsKt.startDrawableAnimation(imageView);
                ImageView imageView2 = this.imageSelected;
                Intrinsics.checkExpressionValueIsNotNull((Object)imageView2, (String)"imageSelected");
                imageView2.setVisibility(((SoundItem)item).isSelected() ? 0 : 8);
                this.itemView.setBackgroundColor(((SoundItem)item).isSelected() ? Color.parseColor((String)"#14000000") : 0);
                if (this.showContextMenu && itemType == 0) {
                    this.itemView.setOnCreateContextMenuListener((View.OnCreateContextMenuListener)this);
                }
            }
        }

        public void onClick(@Nullable View v) {
            this.getListener().onItemClicked(this, 0);
        }

        public void onCreateContextMenu(@Nullable ContextMenu menu, @Nullable View v, @Nullable ContextMenu.ContextMenuInfo menuInfo) {
            block0: {
                this.getListener().onItemClicked(this, -1);
                ContextMenu contextMenu = menu;
                if (contextMenu == null) break block0;
                contextMenu.add(0, 0, 0, R.string.remove_sound);
            }
        }

        public SoundViewHolder(@NotNull View view, @NotNull OnItemCLickedListener listener2, boolean showContextMenu) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
            super(view, listener2);
            this.showContextMenu = showContextMenu;
            this.imageSound = (ImageView)view.findViewById(R.id.imageSound);
            this.textSoundName = (TextView)view.findViewById(R.id.textSoundName);
            this.imageSelected = (ImageView)view.findViewById(R.id.imageSelected);
            this.itemView.setOnClickListener((View.OnClickListener)this);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lxyz/aprildown/ultimatemusicpicker/ui/MusicAdapter$Companion;", "", "()V", "CLICK_ADD_NEW", "", "CLICK_LONG_PRESS", "CLICK_NORMAL", "ITEM_VIEW_TYPE_ADD_CUSTOM", "ITEM_VIEW_TYPE_HEADER", "ITEM_VIEW_TYPE_SOUND", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

