/*
 * Decompiled with CFR 0.152.
 */
package xyz.aprildown.ultimatemusicpicker.data;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.media.RingtoneManager;
import android.net.Uri;
import android.provider.MediaStore;
import androidx.annotation.RequiresPermission;
import androidx.collection.ArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import xyz.aprildown.ultimatemusicpicker.R;
import xyz.aprildown.ultimatemusicpicker.UtilsKt;
import xyz.aprildown.ultimatemusicpicker.data.CustomMusic;
import xyz.aprildown.ultimatemusicpicker.data.CustomMusicDAO;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0011J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0016H\u0007J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u0016J\u000e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0010J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\b2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0012\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001f\u001a\u00020 \"\u00020\u001cJ\u000e\u0010!\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lxyz/aprildown/ultimatemusicpicker/data/MusicModel;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "customMusicDAO", "Lxyz/aprildown/ultimatemusicpicker/data/CustomMusicDAO;", "localCustomMusics", "", "Lxyz/aprildown/ultimatemusicpicker/data/CustomMusic;", "getLocalCustomMusics", "()Ljava/util/List;", "localCustomMusics$delegate", "Lkotlin/Lazy;", "musicTitles", "Landroidx/collection/ArrayMap;", "Landroid/net/Uri;", "", "addCustomMusic", "uri", "title", "getAvailableCustomMusics", "", "getCustomMusic", "getCustomMusics", "getMusicTitle", "getRingtones", "type", "", "loadMusicTitles", "", "types", "", "removeCustomMusic", "Companion", "library_release"})
public final class MusicModel {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final CustomMusicDAO customMusicDAO;
    private final ArrayMap<Uri, String> musicTitles;
    private final Lazy localCustomMusics$delegate;
    private final Context context;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(MusicModel.class), "localCustomMusics", "getLocalCustomMusics()Ljava/util/List;"))};
        Companion = new Companion(null);
    }

    private final List<CustomMusic> getLocalCustomMusics() {
        Lazy lazy = this.localCustomMusics$delegate;
        MusicModel musicModel = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (List)lazy.getValue();
    }

    @NotNull
    public final CustomMusic addCustomMusic(@NotNull Uri uri, @NotNull String title) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        CustomMusic existing = this.getCustomMusic(uri);
        if (existing != null) {
            return existing;
        }
        CustomMusic ringtone = this.customMusicDAO.addCustomMusic(uri, title);
        this.getLocalCustomMusics().add(ringtone);
        UtilsKt.sortWithCollator(this.getLocalCustomMusics());
        return ringtone;
    }

    public final void removeCustomMusic(@NotNull Uri uri) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
            CustomMusic customMusic = this.getCustomMusic(uri);
            if (customMusic == null) break block0;
            CustomMusic customMusic2 = customMusic;
            boolean bl = false;
            boolean bl2 = false;
            CustomMusic it = customMusic2;
            boolean bl3 = false;
            this.customMusicDAO.removeCustomMusic(it.getId());
            this.getLocalCustomMusics().remove(it);
        }
    }

    @NotNull
    public final List<CustomMusic> getCustomMusics() {
        return CollectionsKt.toList((Iterable)this.getLocalCustomMusics());
    }

    @SuppressLint(value={"InlinedApi"})
    @RequiresPermission(value="android.permission.READ_EXTERNAL_STORAGE")
    @NotNull
    public final List<CustomMusic> getAvailableCustomMusics() {
        boolean bl = false;
        List musics = new ArrayList();
        ContentResolver contentResolver = this.context.getContentResolver();
        if (contentResolver == null) {
            return musics;
        }
        ContentResolver contentResolver2 = contentResolver;
        Uri uri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
        Cursor cursor = contentResolver2.query(uri, new String[]{"_id", "title"}, "is_podcast == 0 AND (is_music != 0 OR is_alarm != 0 OR is_notification != 0 OR is_ringtone != 0)", null, "title");
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                int idColumn = cursor.getColumnIndex("_id");
                int titleColumn = cursor.getColumnIndex("title");
                do {
                    long thisId = cursor.getLong(idColumn);
                    String thisTitle = cursor.getString(titleColumn);
                    Uri uri2 = ContentUris.withAppendedId((Uri)MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, (long)thisId);
                    Intrinsics.checkExpressionValueIsNotNull((Object)uri2, (String)"ContentUris.withAppended\u2026                        )");
                    String string = thisTitle;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"thisTitle");
                    CustomMusic customMusic = new CustomMusic(thisId, uri2, string);
                    musics.add(customMusic);
                } while (cursor.moveToNext());
            }
            cursor.close();
        }
        UtilsKt.sortWithCollator(musics);
        return musics;
    }

    public final void loadMusicTitles(int ... types) {
        Intrinsics.checkParameterIsNotNull((Object)types, (String)"types");
        if (!this.musicTitles.isEmpty()) {
            return;
        }
        block2: for (int type : types) {
            if (type == 8) continue;
            RingtoneManager ringtoneManager = new RingtoneManager(this.context);
            ringtoneManager.setType(type);
            try {
                Cursor cursor = ringtoneManager.getCursor();
                cursor.moveToFirst();
                while (true) {
                    Cursor cursor2 = cursor;
                    Intrinsics.checkExpressionValueIsNotNull((Object)cursor2, (String)"cursor");
                    if (cursor2.isAfterLast()) continue block2;
                    String ringtoneTitle = cursor.getString(1);
                    Uri ringtoneUri = ringtoneManager.getRingtoneUri(cursor.getPosition());
                    ((Map)this.musicTitles).put(ringtoneUri, ringtoneTitle);
                    cursor.moveToNext();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @NotNull
    public final String getMusicTitle(@NotNull Uri uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        if (Intrinsics.areEqual((Object)UtilsKt.getNO_MUSIC_URI(), (Object)uri)) {
            String string2 = this.context.getString(R.string.silent_ringtone_title);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.getString(R.string.silent_ringtone_title)");
            return string2;
        }
        CustomMusic customMusic = this.getCustomMusic(uri);
        if (customMusic != null) {
            return customMusic.getTitle();
        }
        String title = (String)this.musicTitles.get((Object)uri);
        if (title == null) {
            Object object = RingtoneManager.getRingtone((Context)this.context, (Uri)uri);
            if (object == null || (object = object.getTitle(this.context)) == null) {
                object = this.context.getString(R.string.unknown_ringtone_title);
            }
            title = object;
            ((Map)this.musicTitles).put(uri, title);
        }
        String string3 = title;
        if (string3 == null) {
            Intrinsics.throwNpe();
        }
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Uri> getRingtones(int type) {
        Cursor cursor;
        boolean bl = false;
        List result = new ArrayList();
        if (type == 8) {
            return result;
        }
        RingtoneManager ringtoneManager = new RingtoneManager(this.context);
        ringtoneManager.setType(type);
        try {
            Cursor cursor2 = ringtoneManager.getCursor();
            Intrinsics.checkExpressionValueIsNotNull((Object)cursor2, (String)"ringtoneManager.cursor");
            cursor = cursor2;
        }
        catch (Exception e) {
            cursor = (Cursor)new MatrixCursor(new String[0]);
        }
        Cursor systemRingtoneCursor = cursor;
        int n = 0;
        int n2 = systemRingtoneCursor.getCount();
        while (n < n2) {
            void i;
            Uri uri = ringtoneManager.getRingtoneUri((int)i);
            Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"ringtoneManager.getRingtoneUri(i)");
            result.add(uri);
            ++i;
        }
        return result;
    }

    private final CustomMusic getCustomMusic(Uri uri) {
        Object v0;
        block1: {
            Iterable iterable = this.getLocalCustomMusics();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                CustomMusic it = (CustomMusic)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getUri(), (Object)uri)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public MusicModel(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.customMusicDAO = new CustomMusicDAO(Companion.getCustomMusicSharedPrefs$library_release(this.context));
        this.musicTitles = new ArrayMap(16);
        this.localCustomMusics$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<CustomMusic>>(this){
            final /* synthetic */ MusicModel this$0;

            @NotNull
            public final List<CustomMusic> invoke() {
                return MusicModel.access$getCustomMusicDAO$p(this.this$0).getCustomMusics();
            }
            {
                this.this$0 = musicModel;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ CustomMusicDAO access$getCustomMusicDAO$p(MusicModel $this) {
        return $this.customMusicDAO;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lxyz/aprildown/ultimatemusicpicker/data/MusicModel$Companion;", "", "()V", "getCustomMusicSharedPrefs", "Landroid/content/SharedPreferences;", "Landroid/content/Context;", "getCustomMusicSharedPrefs$library_release", "library_release"})
    public static final class Companion {
        @NotNull
        public final SharedPreferences getCustomMusicSharedPrefs$library_release(@NotNull Context $this$getCustomMusicSharedPrefs) {
            Intrinsics.checkParameterIsNotNull((Object)$this$getCustomMusicSharedPrefs, (String)"$this$getCustomMusicSharedPrefs");
            SharedPreferences sharedPreferences = UtilsKt.safeContext($this$getCustomMusicSharedPrefs).getSharedPreferences("music_picker_prefs", 0);
            Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"safeContext().getSharedP\u2026ODE_PRIVATE\n            )");
            return sharedPreferences;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

