/*
 * Decompiled with CFR 0.152.
 */
package com.dantsu.escposprinter.textparser;

import com.dantsu.escposprinter.EscPosPrinter;
import com.dantsu.escposprinter.EscPosPrinterCommands;
import com.dantsu.escposprinter.barcode.Barcode;
import com.dantsu.escposprinter.barcode.Barcode128;
import com.dantsu.escposprinter.barcode.Barcode39;
import com.dantsu.escposprinter.barcode.BarcodeEAN13;
import com.dantsu.escposprinter.barcode.BarcodeEAN8;
import com.dantsu.escposprinter.barcode.BarcodeUPCA;
import com.dantsu.escposprinter.barcode.BarcodeUPCE;
import com.dantsu.escposprinter.exceptions.EscPosBarcodeException;
import com.dantsu.escposprinter.exceptions.EscPosEncodingException;
import com.dantsu.escposprinter.exceptions.EscPosParserException;
import com.dantsu.escposprinter.textparser.IPrinterTextParserElement;
import com.dantsu.escposprinter.textparser.PrinterTextParserColumn;
import java.util.Hashtable;

public class PrinterTextParserBarcode
implements IPrinterTextParserElement {
    private Barcode barcode;
    private int length;
    private byte[] align;

    public PrinterTextParserBarcode(PrinterTextParserColumn printerTextParserColumn, String textAlign, Hashtable<String, String> barcodeAttributes, String code) throws EscPosParserException, EscPosBarcodeException {
        EscPosPrinter printer = printerTextParserColumn.getLine().getTextParser().getPrinter();
        code = code.trim();
        this.align = EscPosPrinterCommands.TEXT_ALIGN_LEFT;
        switch (textAlign) {
            case "C": {
                this.align = EscPosPrinterCommands.TEXT_ALIGN_CENTER;
                break;
            }
            case "R": {
                this.align = EscPosPrinterCommands.TEXT_ALIGN_RIGHT;
            }
        }
        this.length = printer.getPrinterNbrCharactersPerLine();
        float height = 10.0f;
        if (barcodeAttributes.containsKey("height")) {
            String barCodeAttribute = barcodeAttributes.get("height");
            if (barCodeAttribute == null) {
                throw new EscPosParserException("Invalid barcode attribute: height");
            }
            try {
                height = Float.parseFloat(barCodeAttribute);
            }
            catch (NumberFormatException nfe) {
                throw new EscPosParserException("Invalid barcode height value");
            }
        }
        float width = 0.0f;
        if (barcodeAttributes.containsKey("width")) {
            String barCodeAttribute = barcodeAttributes.get("width");
            if (barCodeAttribute == null) {
                throw new EscPosParserException("Invalid barcode attribute: width");
            }
            try {
                width = Float.parseFloat(barCodeAttribute);
            }
            catch (NumberFormatException nfe) {
                throw new EscPosParserException("Invalid barcode width value");
            }
        }
        int textPosition = 2;
        if (barcodeAttributes.containsKey("text")) {
            String barCodeAttribute = barcodeAttributes.get("text");
            if (barCodeAttribute == null) {
                throw new EscPosParserException("Invalid barcode attribute: text");
            }
            switch (barCodeAttribute) {
                case "none": {
                    textPosition = 0;
                    break;
                }
                case "above": {
                    textPosition = 1;
                }
            }
        }
        String barcodeType = "ean13";
        if (barcodeAttributes.containsKey("type") && (barcodeType = barcodeAttributes.get("type")) == null) {
            throw new EscPosParserException("Invalid barcode attribute : type");
        }
        switch (barcodeType) {
            case "ean8": {
                this.barcode = new BarcodeEAN8(printer, code, width, height, textPosition);
                break;
            }
            case "ean13": {
                this.barcode = new BarcodeEAN13(printer, code, width, height, textPosition);
                break;
            }
            case "upca": {
                this.barcode = new BarcodeUPCA(printer, code, width, height, textPosition);
                break;
            }
            case "upce": {
                this.barcode = new BarcodeUPCE(printer, code, width, height, textPosition);
                break;
            }
            case "128": {
                this.barcode = new Barcode128(printer, code, width, height, textPosition);
                break;
            }
            case "39": {
                this.barcode = new Barcode39(printer, code, width, height, textPosition);
                break;
            }
            default: {
                throw new EscPosParserException("Invalid barcode attribute : type");
            }
        }
    }

    @Override
    public int length() throws EscPosEncodingException {
        return this.length;
    }

    @Override
    public PrinterTextParserBarcode print(EscPosPrinterCommands printerSocket) {
        printerSocket.setAlign(this.align).printBarcode(this.barcode);
        return this;
    }
}

