/*
 * Decompiled with CFR 0.152.
 */
package com.dantsu.escposprinter.connection.usb;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import com.dantsu.escposprinter.connection.DeviceConnection;
import com.dantsu.escposprinter.connection.usb.UsbOutputStream;
import com.dantsu.escposprinter.exceptions.EscPosConnectionException;
import java.io.IOException;

public class UsbConnection
extends DeviceConnection {
    private UsbManager usbManager;
    private UsbDevice usbDevice;

    public UsbConnection(UsbManager usbManager, UsbDevice usbDevice) {
        this.usbManager = usbManager;
        this.usbDevice = usbDevice;
    }

    public UsbDevice getDevice() {
        return this.usbDevice;
    }

    @Override
    public UsbConnection connect() throws EscPosConnectionException {
        if (this.isConnected()) {
            return this;
        }
        try {
            this.stream = new UsbOutputStream(this.usbManager, this.usbDevice);
            this.data = new byte[0];
        }
        catch (IOException e) {
            e.printStackTrace();
            this.stream = null;
            throw new EscPosConnectionException("Unable to connect to USB device.");
        }
        return this;
    }

    @Override
    public UsbConnection disconnect() {
        this.data = new byte[0];
        if (this.isConnected()) {
            try {
                this.stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.stream = null;
        }
        return this;
    }

    @Override
    public void send() throws EscPosConnectionException {
        this.send(0);
    }

    @Override
    public void send(int addWaitingTime) throws EscPosConnectionException {
        try {
            this.stream.write(this.data);
            this.data = new byte[0];
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new EscPosConnectionException(e.getMessage());
        }
    }
}

