/*
 * Decompiled with CFR 0.152.
 */
package com.dantsu.escposprinter;

import android.graphics.Bitmap;
import com.dantsu.escposprinter.EscPosCharsetEncoding;
import com.dantsu.escposprinter.barcode.Barcode;
import com.dantsu.escposprinter.connection.DeviceConnection;
import com.dantsu.escposprinter.exceptions.EscPosBarcodeException;
import com.dantsu.escposprinter.exceptions.EscPosConnectionException;
import com.dantsu.escposprinter.exceptions.EscPosEncodingException;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.Encoder;
import com.google.zxing.qrcode.encoder.QRCode;
import java.io.UnsupportedEncodingException;
import java.util.EnumMap;

public class EscPosPrinterCommands {
    public static final byte LF = 10;
    public static final byte[] TEXT_ALIGN_LEFT = new byte[]{27, 97, 0};
    public static final byte[] TEXT_ALIGN_CENTER = new byte[]{27, 97, 1};
    public static final byte[] TEXT_ALIGN_RIGHT = new byte[]{27, 97, 2};
    public static final byte[] TEXT_WEIGHT_NORMAL = new byte[]{27, 69, 0};
    public static final byte[] TEXT_WEIGHT_BOLD = new byte[]{27, 69, 1};
    public static final byte[] TEXT_SIZE_NORMAL = new byte[]{27, 33, 3};
    public static final byte[] TEXT_SIZE_MEDIUM = new byte[]{27, 33, 8};
    public static final byte[] TEXT_SIZE_DOUBLE_HEIGHT = new byte[]{27, 33, 16};
    public static final byte[] TEXT_SIZE_DOUBLE_WIDTH = new byte[]{27, 33, 32};
    public static final byte[] TEXT_SIZE_BIG = new byte[]{27, 33, 48};
    public static final byte[] TEXT_UNDERLINE_OFF = new byte[]{27, 45, 0};
    public static final byte[] TEXT_UNDERLINE_ON = new byte[]{27, 45, 1};
    public static final byte[] TEXT_UNDERLINE_LARGE = new byte[]{27, 45, 2};
    public static final byte[] TEXT_DOUBLE_STRIKE_OFF = new byte[]{27, 71, 0};
    public static final byte[] TEXT_DOUBLE_STRIKE_ON = new byte[]{27, 71, 1};
    public static final int BARCODE_TYPE_UPCA = 65;
    public static final int BARCODE_TYPE_UPCE = 66;
    public static final int BARCODE_TYPE_EAN13 = 67;
    public static final int BARCODE_TYPE_EAN8 = 68;
    public static final int BARCODE_TYPE_ITF = 70;
    public static final int BARCODE_TYPE_128 = 73;
    public static final int BARCODE_TEXT_POSITION_NONE = 0;
    public static final int BARCODE_TEXT_POSITION_ABOVE = 1;
    public static final int BARCODE_TEXT_POSITION_BELOW = 2;
    public static final int QRCODE_1 = 49;
    public static final int QRCODE_2 = 50;
    private DeviceConnection printerConnection;
    private EscPosCharsetEncoding charsetEncoding;

    public static byte[] initImageCommand(int bytesByLine, int bitmapHeight) {
        int xH = bytesByLine / 256;
        int xL = bytesByLine - xH * 256;
        int yH = bitmapHeight / 256;
        int yL = bitmapHeight - yH * 256;
        byte[] imageBytes = new byte[8 + bytesByLine * bitmapHeight];
        System.arraycopy(new byte[]{29, 118, 48, 0, (byte)xL, (byte)xH, (byte)yL, (byte)yH}, 0, imageBytes, 0, 8);
        return imageBytes;
    }

    public static byte[] bitmapToBytes(Bitmap bitmap) {
        int bitmapWidth = bitmap.getWidth();
        int bitmapHeight = bitmap.getHeight();
        int bytesByLine = (int)Math.ceil((float)bitmapWidth / 8.0f);
        byte[] imageBytes = EscPosPrinterCommands.initImageCommand(bytesByLine, bitmapHeight);
        int i = 8;
        for (int posY = 0; posY < bitmapHeight; ++posY) {
            for (int j = 0; j < bitmapWidth; j += 8) {
                StringBuilder stringBinary = new StringBuilder();
                for (int k = 0; k < 8; ++k) {
                    int posX = j + k;
                    if (posX < bitmapWidth) {
                        int color = bitmap.getPixel(posX, posY);
                        int r = color >> 16 & 0xFF;
                        int g = color >> 8 & 0xFF;
                        int b = color & 0xFF;
                        if (r > 160 && g > 160 && b > 160) {
                            stringBinary.append("0");
                            continue;
                        }
                        stringBinary.append("1");
                        continue;
                    }
                    stringBinary.append("0");
                }
                imageBytes[i++] = (byte)Integer.parseInt(stringBinary.toString(), 2);
            }
        }
        return imageBytes;
    }

    public static byte[] QRCodeDataToBytes(String data, int size) throws EscPosBarcodeException {
        ByteMatrix byteMatrix = null;
        try {
            EnumMap<EncodeHintType, String> hints = new EnumMap<EncodeHintType, String>(EncodeHintType.class);
            hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            QRCode code = Encoder.encode((String)data, (ErrorCorrectionLevel)ErrorCorrectionLevel.L, hints);
            byteMatrix = code.getMatrix();
        }
        catch (WriterException e) {
            e.printStackTrace();
            throw new EscPosBarcodeException("Unable to encode QR code");
        }
        if (byteMatrix == null) {
            return EscPosPrinterCommands.initImageCommand(0, 0);
        }
        int width = byteMatrix.getWidth();
        int height = byteMatrix.getHeight();
        int coefficient = Math.round((float)size / (float)width);
        int imageWidth = width * coefficient;
        int imageHeight = height * coefficient;
        int bytesByLine = (int)Math.ceil((float)imageWidth / 8.0f);
        int i = 8;
        if (coefficient < 1) {
            return EscPosPrinterCommands.initImageCommand(0, 0);
        }
        byte[] imageBytes = EscPosPrinterCommands.initImageCommand(bytesByLine, imageHeight);
        for (int y = 0; y < height; ++y) {
            byte[] lineBytes = new byte[bytesByLine];
            int x = -1;
            int multipleX = coefficient;
            boolean isBlack = false;
            for (int j = 0; j < bytesByLine; ++j) {
                StringBuilder stringBinary = new StringBuilder();
                for (int k = 0; k < 8; ++k) {
                    if (multipleX == coefficient) {
                        isBlack = ++x < width && byteMatrix.get(x, y) == 1;
                        multipleX = 0;
                    }
                    stringBinary.append(isBlack ? "1" : "0");
                    ++multipleX;
                }
                lineBytes[j] = (byte)Integer.parseInt(stringBinary.toString(), 2);
            }
            for (int multipleY = 0; multipleY < coefficient; ++multipleY) {
                System.arraycopy(lineBytes, 0, imageBytes, i, lineBytes.length);
                i += lineBytes.length;
            }
        }
        return imageBytes;
    }

    public EscPosPrinterCommands(DeviceConnection printerConnection) {
        this(printerConnection, new EscPosCharsetEncoding("ISO-8859-1", 6));
    }

    public EscPosPrinterCommands(DeviceConnection printerConnection, EscPosCharsetEncoding charsetEncoding) {
        this.printerConnection = printerConnection;
        this.charsetEncoding = charsetEncoding;
    }

    public EscPosPrinterCommands connect() throws EscPosConnectionException {
        this.printerConnection.connect();
        return this;
    }

    public void disconnect() {
        this.printerConnection.disconnect();
    }

    public EscPosPrinterCommands setAlign(byte[] align) {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        this.printerConnection.write(align);
        return this;
    }

    public EscPosPrinterCommands printText(String text) throws EscPosEncodingException {
        return this.printText(text, null);
    }

    public EscPosPrinterCommands printText(String text, byte[] textSize) throws EscPosEncodingException {
        return this.printText(text, textSize, null);
    }

    public EscPosPrinterCommands printText(String text, byte[] textSize, byte[] textBold) throws EscPosEncodingException {
        return this.printText(text, textSize, textBold, null);
    }

    public EscPosPrinterCommands printText(String text, byte[] textSize, byte[] textBold, byte[] textUnderline) throws EscPosEncodingException {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        try {
            byte[] textBytes = text.getBytes(this.charsetEncoding.getName());
            this.printerConnection.write(this.charsetEncoding.getCommand());
            this.printerConnection.write(TEXT_SIZE_NORMAL);
            this.printerConnection.write(TEXT_WEIGHT_NORMAL);
            this.printerConnection.write(TEXT_UNDERLINE_OFF);
            if (textSize != null) {
                this.printerConnection.write(textSize);
            }
            if (textBold != null) {
                this.printerConnection.write(textBold);
            }
            if (textUnderline != null) {
                this.printerConnection.write(textUnderline);
            }
            this.printerConnection.write(textBytes);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new EscPosEncodingException(e.getMessage());
        }
        return this;
    }

    public EscPosPrinterCommands printImage(byte[] image) {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        this.printerConnection.write(image);
        return this;
    }

    public EscPosPrinterCommands printBarcode(Barcode barcode) {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        String code = barcode.getCode();
        int barcodeLength = barcode.getCodeLength();
        byte[] barcodeCommand = new byte[barcodeLength + 4];
        System.arraycopy(new byte[]{29, 107, (byte)barcode.getBarcodeType(), (byte)barcodeLength}, 0, barcodeCommand, 0, 4);
        for (int i = 0; i < barcodeLength; ++i) {
            barcodeCommand[i + 4] = (byte)code.charAt(i);
        }
        this.printerConnection.write(new byte[]{29, 72, (byte)barcode.getTextPosition()});
        this.printerConnection.write(new byte[]{29, 119, (byte)barcode.getColWidth()});
        this.printerConnection.write(new byte[]{29, 104, (byte)barcode.getHeight()});
        this.printerConnection.write(barcodeCommand);
        return this;
    }

    public EscPosPrinterCommands printQRCode(int qrCodeType, String text, int size) throws EscPosEncodingException {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        if (size < 1) {
            size = 1;
        } else if (size > 16) {
            size = 16;
        }
        try {
            this.printerConnection.write(this.charsetEncoding.getCommand());
            byte[] textBytes = text.getBytes(this.charsetEncoding.getName());
            int commandLength = textBytes.length + 3;
            int pL = commandLength % 256;
            int pH = (int)Math.floor(commandLength / 256);
            this.printerConnection.write(new byte[]{29, 40, 107, 4, 0, 49, 65, (byte)qrCodeType, 0});
            this.printerConnection.write(new byte[]{29, 40, 107, 3, 0, 49, 67, (byte)size});
            this.printerConnection.write(new byte[]{29, 40, 107, 3, 0, 49, 69, 48});
            byte[] qrCodeCommand = new byte[textBytes.length + 8];
            System.arraycopy(new byte[]{29, 40, 107, (byte)pL, (byte)pH, 49, 80, 48}, 0, qrCodeCommand, 0, 8);
            System.arraycopy(textBytes, 0, qrCodeCommand, 8, textBytes.length);
            this.printerConnection.write(qrCodeCommand);
            this.printerConnection.write(new byte[]{29, 40, 107, 3, 0, 49, 81, 48});
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new EscPosEncodingException(e.getMessage());
        }
        return this;
    }

    public EscPosPrinterCommands newLine() throws EscPosConnectionException {
        return this.newLine(null);
    }

    public EscPosPrinterCommands newLine(byte[] align) throws EscPosConnectionException {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        this.printerConnection.write(new byte[]{10});
        this.printerConnection.send();
        if (align != null) {
            this.printerConnection.write(align);
        }
        return this;
    }

    public EscPosPrinterCommands feedPaper(int dots) throws EscPosConnectionException {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        if (dots > 0) {
            this.printerConnection.write(new byte[]{27, 74, (byte)dots});
            this.printerConnection.send(dots);
        }
        return this;
    }

    public EscPosPrinterCommands cutPaper() throws EscPosConnectionException {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        this.printerConnection.write(new byte[]{29, 86, 1});
        this.printerConnection.send(100);
        return this;
    }
}

