/*
 * Decompiled with CFR 0.152.
 */
package com.dantsu.escposprinter.connection.bluetooth;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.os.ParcelUuid;
import com.dantsu.escposprinter.connection.DeviceConnection;
import com.dantsu.escposprinter.exceptions.EscPosConnectionException;
import java.io.IOException;
import java.util.UUID;

public class BluetoothConnection
extends DeviceConnection {
    private BluetoothDevice device;
    private BluetoothSocket socket = null;

    public BluetoothConnection(BluetoothDevice device) {
        this.device = device;
    }

    public BluetoothDevice getDevice() {
        return this.device;
    }

    @Override
    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected() && super.isConnected();
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public BluetoothConnection connect() throws EscPosConnectionException {
        if (this.isConnected()) {
            return this;
        }
        if (this.device == null) {
            throw new EscPosConnectionException("Bluetooth device is not connected.");
        }
        ParcelUuid[] uuids = this.device.getUuids();
        UUID uuid = uuids != null && uuids.length > 0 ? uuids[0].getUuid() : UUID.randomUUID();
        try {
            this.socket = this.device.createRfcommSocketToServiceRecord(uuid);
            this.socket.connect();
            this.stream = this.socket.getOutputStream();
            this.data = new byte[0];
        }
        catch (IOException e) {
            e.printStackTrace();
            this.socket = null;
            this.stream = null;
            throw new EscPosConnectionException("Unable to connect to bluetooth device.");
        }
        return this;
    }

    @Override
    public BluetoothConnection disconnect() {
        this.data = new byte[0];
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.stream = null;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.socket = null;
        }
        return this;
    }
}

