/*
 * Decompiled with CFR 0.152.
 */
package com.dantsu.escposprinter.textparser;

import com.dantsu.escposprinter.EscPosPrinterCommands;
import com.dantsu.escposprinter.exceptions.EscPosBarcodeException;
import com.dantsu.escposprinter.exceptions.EscPosParserException;
import com.dantsu.escposprinter.textparser.IPrinterTextParserElement;
import com.dantsu.escposprinter.textparser.PrinterTextParser;
import com.dantsu.escposprinter.textparser.PrinterTextParserBarcode;
import com.dantsu.escposprinter.textparser.PrinterTextParserImg;
import com.dantsu.escposprinter.textparser.PrinterTextParserLine;
import com.dantsu.escposprinter.textparser.PrinterTextParserQRCode;
import com.dantsu.escposprinter.textparser.PrinterTextParserString;
import com.dantsu.escposprinter.textparser.PrinterTextParserTag;
import java.util.Hashtable;

public class PrinterTextParserColumn {
    private PrinterTextParserLine textParserLine;
    private IPrinterTextParserElement[] elements = new IPrinterTextParserElement[0];

    private static String generateSpace(int nbrSpace) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < nbrSpace; ++i) {
            str.append(" ");
        }
        return str.toString();
    }

    public PrinterTextParserColumn(PrinterTextParserLine textParserLine, String textColumn) throws EscPosParserException, EscPosBarcodeException {
        int openTagEndIndex;
        int openTagIndex;
        this.textParserLine = textParserLine;
        PrinterTextParser textParser = this.textParserLine.getTextParser();
        String textAlign = "L";
        byte[] textUnderlineStartColumn = textParser.getLastTextUnderline();
        switch (textColumn.substring(0, 3).toUpperCase()) {
            case "[L]": 
            case "[C]": 
            case "[R]": {
                textAlign = textColumn.substring(1, 2).toUpperCase();
                textColumn = textColumn.substring(3);
            }
        }
        String trimmedTextColumn = textColumn.trim();
        boolean isImgOrBarcodeLine = false;
        if (this.textParserLine.getNbrColumns() == 1 && trimmedTextColumn.indexOf("<") == 0 && (openTagIndex = trimmedTextColumn.indexOf("<")) < (openTagEndIndex = trimmedTextColumn.indexOf(">", openTagIndex + 1) + 1)) {
            PrinterTextParserTag textParserTag = new PrinterTextParserTag(trimmedTextColumn.substring(openTagIndex, openTagEndIndex));
            switch (textParserTag.getTagName()) {
                case "img": 
                case "barcode": 
                case "qrcode": {
                    String closeTag = "</" + textParserTag.getTagName() + ">";
                    int closeTagPosition = trimmedTextColumn.length() - closeTag.length();
                    if (!trimmedTextColumn.substring(closeTagPosition).equals(closeTag)) break;
                    switch (textParserTag.getTagName()) {
                        case "img": {
                            this.appendImage(textAlign, trimmedTextColumn.substring(openTagEndIndex, closeTagPosition));
                            break;
                        }
                        case "barcode": {
                            this.appendBarcode(textAlign, textParserTag.getAttributes(), trimmedTextColumn.substring(openTagEndIndex, closeTagPosition));
                            break;
                        }
                        case "qrcode": {
                            this.appendQRCode(textAlign, textParserTag.getAttributes(), trimmedTextColumn.substring(openTagEndIndex, closeTagPosition));
                        }
                    }
                    isImgOrBarcodeLine = true;
                }
            }
        }
        if (!isImgOrBarcodeLine) {
            int offset = 0;
            while (true) {
                PrinterTextParserTag textParserTag;
                int openTagIndex2 = textColumn.indexOf("<", offset);
                int closeTagIndex = -1;
                if (openTagIndex2 != -1) {
                    closeTagIndex = textColumn.indexOf(">", openTagIndex2);
                } else {
                    openTagIndex2 = textColumn.length();
                }
                this.appendString(textColumn.substring(offset, openTagIndex2));
                if (closeTagIndex == -1) break;
                if (PrinterTextParser.isTagTextFormat((textParserTag = new PrinterTextParserTag(textColumn.substring(openTagIndex2, ++closeTagIndex))).getTagName())) {
                    if (textParserTag.isCloseTag()) {
                        switch (textParserTag.getTagName()) {
                            case "b": {
                                textParser.dropTextBold(EscPosPrinterCommands.TEXT_WEIGHT_BOLD);
                                break;
                            }
                            case "u": {
                                textParser.dropLastTextUnderline(EscPosPrinterCommands.TEXT_UNDERLINE_LARGE);
                                break;
                            }
                            case "font": {
                                textParser.dropLastTextSize();
                            }
                        }
                    } else {
                        block41 : switch (textParserTag.getTagName()) {
                            case "b": {
                                textParser.addTextBold(EscPosPrinterCommands.TEXT_WEIGHT_BOLD);
                                break;
                            }
                            case "u": {
                                textParser.addTextUnderline(EscPosPrinterCommands.TEXT_UNDERLINE_LARGE);
                                break;
                            }
                            case "font": {
                                if (!textParserTag.hasAttribute("size")) break;
                                switch (textParserTag.getAttribute("size")) {
                                    case "small": {
                                        textParser.addTextSize(EscPosPrinterCommands.TEXT_SIZE_NORMAL);
                                        break block41;
                                    }
                                    case "medium": {
                                        textParser.addTextSize(EscPosPrinterCommands.TEXT_SIZE_MEDIUM);
                                        break block41;
                                    }
                                    case "tall": {
                                        textParser.addTextSize(EscPosPrinterCommands.TEXT_SIZE_DOUBLE_HEIGHT);
                                        break block41;
                                    }
                                    case "wide": {
                                        textParser.addTextSize(EscPosPrinterCommands.TEXT_SIZE_DOUBLE_WIDTH);
                                        break block41;
                                    }
                                    case "big": {
                                        textParser.addTextSize(EscPosPrinterCommands.TEXT_SIZE_BIG);
                                    }
                                }
                            }
                        }
                    }
                    offset = closeTagIndex;
                    continue;
                }
                this.appendString("<");
                offset = openTagIndex2 + 1;
            }
            int nbrCharColumn = this.textParserLine.getNbrCharColumn();
            int nbrCharForgetted = this.textParserLine.getNbrCharForgetted();
            int nbrCharColumnExceeded = this.textParserLine.getNbrCharColumnExceeded();
            int nbrCharTextWithoutTag = 0;
            int leftSpace = 0;
            int rightSpace = 0;
            for (IPrinterTextParserElement textParserElement : this.elements) {
                nbrCharTextWithoutTag += textParserElement.length();
            }
            switch (textAlign) {
                case "L": {
                    rightSpace = nbrCharColumn - nbrCharTextWithoutTag;
                    break;
                }
                case "C": {
                    leftSpace = (int)Math.floor(((float)nbrCharColumn - (float)nbrCharTextWithoutTag) / 2.0f);
                    rightSpace = nbrCharColumn - nbrCharTextWithoutTag - leftSpace;
                    break;
                }
                case "R": {
                    leftSpace = nbrCharColumn - nbrCharTextWithoutTag;
                }
            }
            if (nbrCharForgetted > 0) {
                --nbrCharForgetted;
                ++rightSpace;
            }
            if (nbrCharColumnExceeded < 0) {
                leftSpace += nbrCharColumnExceeded;
                nbrCharColumnExceeded = 0;
                if (leftSpace < 1) {
                    rightSpace += leftSpace - 1;
                    leftSpace = 1;
                }
            }
            if (leftSpace < 0) {
                nbrCharColumnExceeded += leftSpace;
                leftSpace = 0;
            }
            if (rightSpace < 0) {
                nbrCharColumnExceeded += rightSpace;
                rightSpace = 0;
            }
            if (leftSpace > 0) {
                this.prependString(PrinterTextParserColumn.generateSpace(leftSpace), EscPosPrinterCommands.TEXT_SIZE_MEDIUM, EscPosPrinterCommands.TEXT_WEIGHT_NORMAL, textUnderlineStartColumn);
            }
            if (rightSpace > 0) {
                this.appendString(PrinterTextParserColumn.generateSpace(rightSpace), EscPosPrinterCommands.TEXT_SIZE_MEDIUM, EscPosPrinterCommands.TEXT_WEIGHT_NORMAL, textParser.getLastTextUnderline());
            }
            this.textParserLine.setNbrCharForgetted(nbrCharForgetted).setNbrCharColumnExceeded(nbrCharColumnExceeded);
        }
    }

    private PrinterTextParserColumn prependString(String text) {
        PrinterTextParser textParser = this.textParserLine.getTextParser();
        return this.prependString(text, textParser.getLastTextSize(), textParser.getLastTextBold(), textParser.getLastTextUnderline());
    }

    private PrinterTextParserColumn prependString(String text, byte[] textSize, byte[] textBold, byte[] textUnderline) {
        return this.prependElement(new PrinterTextParserString(text, textSize, textBold, textUnderline));
    }

    private PrinterTextParserColumn appendString(String text) {
        PrinterTextParser textParser = this.textParserLine.getTextParser();
        return this.appendString(text, textParser.getLastTextSize(), textParser.getLastTextBold(), textParser.getLastTextUnderline());
    }

    private PrinterTextParserColumn appendString(String text, byte[] textSize, byte[] textBold, byte[] textUnderline) {
        return this.appendElement(new PrinterTextParserString(text, textSize, textBold, textUnderline));
    }

    private PrinterTextParserColumn prependImage(String textAlign, String hexString) {
        return this.prependElement(new PrinterTextParserImg(this, textAlign, hexString));
    }

    private PrinterTextParserColumn appendImage(String textAlign, String hexString) {
        return this.appendElement(new PrinterTextParserImg(this, textAlign, hexString));
    }

    private PrinterTextParserColumn prependBarcode(String textAlign, Hashtable<String, String> barcodeAttributes, String code) throws EscPosParserException, EscPosBarcodeException {
        return this.prependElement(new PrinterTextParserBarcode(this, textAlign, barcodeAttributes, code));
    }

    private PrinterTextParserColumn appendBarcode(String textAlign, Hashtable<String, String> barcodeAttributes, String code) throws EscPosParserException, EscPosBarcodeException {
        return this.appendElement(new PrinterTextParserBarcode(this, textAlign, barcodeAttributes, code));
    }

    private PrinterTextParserColumn prependQRCode(String textAlign, Hashtable<String, String> qrCodeAttributes, String data) throws EscPosParserException, EscPosBarcodeException {
        return this.prependElement(new PrinterTextParserBarcode(this, textAlign, qrCodeAttributes, data));
    }

    private PrinterTextParserColumn appendQRCode(String textAlign, Hashtable<String, String> qrCodeAttributes, String data) throws EscPosParserException, EscPosBarcodeException {
        return this.appendElement(new PrinterTextParserQRCode(this, textAlign, qrCodeAttributes, data));
    }

    private PrinterTextParserColumn prependElement(IPrinterTextParserElement element) {
        IPrinterTextParserElement[] elementsTmp = new IPrinterTextParserElement[this.elements.length + 1];
        elementsTmp[0] = element;
        System.arraycopy(this.elements, 0, elementsTmp, 1, this.elements.length);
        this.elements = elementsTmp;
        return this;
    }

    private PrinterTextParserColumn appendElement(IPrinterTextParserElement element) {
        IPrinterTextParserElement[] elementsTmp = new IPrinterTextParserElement[this.elements.length + 1];
        System.arraycopy(this.elements, 0, elementsTmp, 0, this.elements.length);
        elementsTmp[this.elements.length] = element;
        this.elements = elementsTmp;
        return this;
    }

    public PrinterTextParserLine getLine() {
        return this.textParserLine;
    }

    public IPrinterTextParserElement[] getElements() {
        return this.elements;
    }
}

