/*
 * Decompiled with CFR 0.152.
 */
package com.dantsu.escposprinter.textparser;

import com.dantsu.escposprinter.EscPosPrinter;
import com.dantsu.escposprinter.EscPosPrinterCommands;
import com.dantsu.escposprinter.textparser.IPrinterTextParserElement;
import com.dantsu.escposprinter.textparser.PrinterTextParserColumn;
import java.util.Hashtable;

public class PrinterTextParserBarcode
implements IPrinterTextParserElement {
    private int length;
    private int height;
    private byte[] align;
    private String code;
    private int barcodeType;

    public PrinterTextParserBarcode(PrinterTextParserColumn printerTextParserColumn, String textAlign, Hashtable<String, String> barcodeAttributes, String code) {
        EscPosPrinter printer = printerTextParserColumn.getLine().getTextParser().getPrinter();
        code = code.trim();
        this.align = EscPosPrinterCommands.TEXT_ALIGN_LEFT;
        switch (textAlign) {
            case "C": {
                this.align = EscPosPrinterCommands.TEXT_ALIGN_CENTER;
                break;
            }
            case "R": {
                this.align = EscPosPrinterCommands.TEXT_ALIGN_RIGHT;
            }
        }
        this.barcodeType = 2;
        try {
            if (barcodeAttributes.containsKey("type")) {
                switch (barcodeAttributes.get("type")) {
                    case "ean8": {
                        this.barcodeType = 3;
                        break;
                    }
                    case "upca": {
                        this.barcodeType = 0;
                        break;
                    }
                    case "upce": {
                        this.barcodeType = 1;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.length = printer.getNbrCharactersPerLine();
        this.height = printer.mmToPx(10.0f);
        try {
            if (barcodeAttributes.containsKey("height")) {
                this.height = printer.mmToPx(Float.parseFloat(barcodeAttributes.get("height")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.code = code;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public PrinterTextParserBarcode print(EscPosPrinterCommands printerSocket) {
        printerSocket.setAlign(this.align).printBarcode(this.barcodeType, this.code, this.height);
        return this;
    }
}

