/*
 * Decompiled with CFR 0.152.
 */
package com.dantsu.escposprinter.connection.usb;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import com.dantsu.escposprinter.connection.DeviceConnection;
import com.dantsu.escposprinter.connection.usb.UsbOutputStream;
import java.io.IOException;

public class UsbConnection
extends DeviceConnection {
    private UsbManager usbManager;
    private UsbDevice usbDevice;

    public UsbConnection(UsbManager usbManager, UsbDevice usbDevice) {
        this.usbManager = usbManager;
        this.usbDevice = usbDevice;
    }

    public UsbDevice getDevice() {
        return this.usbDevice;
    }

    @Override
    public boolean connect() {
        if (this.isConnected()) {
            return true;
        }
        try {
            this.stream = new UsbOutputStream(this.usbManager, this.usbDevice);
            this.data = new byte[0];
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.disconnect();
            this.stream = null;
            return false;
        }
    }

    @Override
    public boolean disconnect() {
        this.data = new byte[0];
        if (this.isConnected()) {
            try {
                this.stream.close();
                this.stream = null;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return true;
    }

    @Override
    public void send() {
        try {
            this.stream.write(this.data);
            this.data = new byte[0];
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

