/*
 * Decompiled with CFR 0.152.
 */
package com.effective.android.panel.device;

import android.content.Context;
import android.content.res.Resources;
import android.view.Window;
import com.effective.android.panel.device.DeviceInfo;
import com.effective.android.panel.utils.DisplayUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001f\u001a\u00020\n2\b\b\u0002\u0010 \u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0014\"\u0004\b\u0018\u0010\u0016R\u001a\u0010\u0019\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0014\"\u0004\b\u001a\u0010\u0016R\u001a\u0010\u001b\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0014\"\u0004\b\u001c\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006!"}, d2={"Lcom/effective/android/panel/device/DeviceRuntime;", "", "context", "Landroid/content/Context;", "window", "Landroid/view/Window;", "(Landroid/content/Context;Landroid/view/Window;)V", "getContext", "()Landroid/content/Context;", "deviceInfoL", "Lcom/effective/android/panel/device/DeviceInfo;", "getDeviceInfoL", "()Lcom/effective/android/panel/device/DeviceInfo;", "setDeviceInfoL", "(Lcom/effective/android/panel/device/DeviceInfo;)V", "deviceInfoP", "getDeviceInfoP", "setDeviceInfoP", "isFullScreen", "", "()Z", "setFullScreen", "(Z)V", "isNavigationBarShow", "setNavigationBarShow", "isPad", "setPad", "isPortrait", "setPortrait", "getWindow", "()Landroid/view/Window;", "getDeviceInfoByOrientation", "cache", "panel-androidx_release"})
public final class DeviceRuntime {
    @Nullable
    private DeviceInfo deviceInfoP;
    @Nullable
    private DeviceInfo deviceInfoL;
    private boolean isNavigationBarShow;
    private boolean isPortrait;
    private boolean isPad;
    private boolean isFullScreen;
    @NotNull
    private final Context context;
    @NotNull
    private final Window window;

    @Nullable
    public final DeviceInfo getDeviceInfoP() {
        return this.deviceInfoP;
    }

    public final void setDeviceInfoP(@Nullable DeviceInfo deviceInfo) {
        this.deviceInfoP = deviceInfo;
    }

    @Nullable
    public final DeviceInfo getDeviceInfoL() {
        return this.deviceInfoL;
    }

    public final void setDeviceInfoL(@Nullable DeviceInfo deviceInfo) {
        this.deviceInfoL = deviceInfo;
    }

    public final boolean isNavigationBarShow() {
        return this.isNavigationBarShow;
    }

    public final void setNavigationBarShow(boolean bl) {
        this.isNavigationBarShow = bl;
    }

    public final boolean isPortrait() {
        return this.isPortrait;
    }

    public final void setPortrait(boolean bl) {
        this.isPortrait = bl;
    }

    public final boolean isPad() {
        return this.isPad;
    }

    public final void setPad(boolean bl) {
        this.isPad = bl;
    }

    public final boolean isFullScreen() {
        return this.isFullScreen;
    }

    public final void setFullScreen(boolean bl) {
        this.isFullScreen = bl;
    }

    @NotNull
    public final DeviceInfo getDeviceInfoByOrientation(boolean cache) {
        DeviceInfo deviceInfo;
        this.isPortrait = DisplayUtil.isPortrait(this.context);
        this.isNavigationBarShow = DisplayUtil.isNavigationBarShow(this.context, this.window);
        this.isFullScreen = DisplayUtil.isFullScreen(this.window);
        if (cache) {
            if (this.isPortrait && this.deviceInfoP != null) {
                DeviceInfo deviceInfo2 = this.deviceInfoP;
                if (deviceInfo2 == null) {
                    Intrinsics.throwNpe();
                }
                return deviceInfo2;
            }
            if (!this.isPortrait && this.deviceInfoL != null) {
                DeviceInfo deviceInfo3 = this.deviceInfoL;
                if (deviceInfo3 == null) {
                    Intrinsics.throwNpe();
                }
                return deviceInfo3;
            }
        }
        int navigationBarHeight = DisplayUtil.getNavigationBarHeight(this.context, this.window);
        int statusBarHeight = DisplayUtil.getStatusBarHeight(this.window);
        int toolbarH = DisplayUtil.getToolbarHeight(this.window);
        if (toolbarH == statusBarHeight) {
            toolbarH = 0;
        }
        int screenHeight = DisplayUtil.INSTANCE.getScreenRealHeight(this.window);
        int screenWithoutSystemUIHeight = DisplayUtil.getScreenHeightWithoutSystemUI(this.window);
        int screenWithoutNavigationHeight = DisplayUtil.getScreenHeightWithoutNavigationBar(this.context);
        if (this.isPortrait) {
            this.deviceInfoP = new DeviceInfo(this.window, true, statusBarHeight, navigationBarHeight, toolbarH, screenHeight, screenWithoutSystemUIHeight, screenWithoutNavigationHeight);
            deviceInfo = this.deviceInfoP;
            if (deviceInfo == null) {
                Intrinsics.throwNpe();
            }
        } else {
            this.deviceInfoL = new DeviceInfo(this.window, false, statusBarHeight, navigationBarHeight, toolbarH, screenHeight, screenWithoutSystemUIHeight, screenWithoutNavigationHeight);
            deviceInfo = this.deviceInfoL;
            if (deviceInfo == null) {
                Intrinsics.throwNpe();
            }
        }
        return deviceInfo;
    }

    public static /* synthetic */ DeviceInfo getDeviceInfoByOrientation$default(DeviceRuntime deviceRuntime, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return deviceRuntime.getDeviceInfoByOrientation(bl);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final Window getWindow() {
        return this.window;
    }

    public DeviceRuntime(@NotNull Context context, @NotNull Window window) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)window, (String)"window");
        this.context = context;
        this.window = window;
        Resources resources = this.context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        this.isPad = (resources.getConfiguration().screenLayout & 0xF) >= 3;
        this.isPortrait = DisplayUtil.isPortrait(this.context);
        this.isNavigationBarShow = DisplayUtil.isNavigationBarShow(this.context, this.window);
        this.isFullScreen = DisplayUtil.isFullScreen(this.window);
    }
}

