/*
 * Decompiled with CFR 0.152.
 */
package com.chad.library.adapter.base;

import android.util.SparseArray;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.chad.library.adapter.base.provider.BaseItemProvider;
import com.chad.library.adapter.base.util.MultiTypeDelegate;
import com.chad.library.adapter.base.util.ProviderDelegate;
import java.util.List;

public abstract class MultipleItemRvAdapter<T, V extends BaseViewHolder>
extends BaseQuickAdapter<T, V> {
    private SparseArray<BaseItemProvider> mItemProviders;
    protected ProviderDelegate mProviderDelegate;

    public MultipleItemRvAdapter(@Nullable List<T> data) {
        super(data);
    }

    public void finishInitialize() {
        this.mProviderDelegate = new ProviderDelegate();
        this.setMultiTypeDelegate(new MultiTypeDelegate<T>(){

            @Override
            protected int getItemType(T t) {
                return MultipleItemRvAdapter.this.getViewType(t);
            }
        });
        this.registerItemProvider();
        this.mItemProviders = this.mProviderDelegate.getItemProviders();
        for (int i = 0; i < this.mItemProviders.size(); ++i) {
            int key = this.mItemProviders.keyAt(i);
            BaseItemProvider provider = (BaseItemProvider)this.mItemProviders.get(key);
            provider.mData = this.mData;
            this.getMultiTypeDelegate().registerItemType(key, provider.layout());
        }
    }

    protected abstract int getViewType(T var1);

    public abstract void registerItemProvider();

    @Override
    protected void convert(@NonNull V helper, T item) {
        int itemViewType = helper.getItemViewType();
        BaseItemProvider provider = (BaseItemProvider)this.mItemProviders.get(itemViewType);
        provider.mContext = ((BaseViewHolder)((Object)helper)).itemView.getContext();
        int position = helper.getLayoutPosition() - this.getHeaderLayoutCount();
        provider.convert(helper, item, position);
        this.bindClick(helper, item, position, provider);
    }

    private void bindClick(V helper, T item, int position, final BaseItemProvider provider) {
        BaseQuickAdapter.OnItemClickListener clickListener = this.getOnItemClickListener();
        BaseQuickAdapter.OnItemLongClickListener longClickListener = this.getOnItemLongClickListener();
        if (clickListener != null && longClickListener != null) {
            return;
        }
        View itemView = ((BaseViewHolder)((Object)helper)).itemView;
        if (clickListener == null) {
            itemView.setOnClickListener(new View.OnClickListener((BaseViewHolder)((Object)helper), item, position){
                final /* synthetic */ BaseViewHolder val$helper;
                final /* synthetic */ Object val$item;
                final /* synthetic */ int val$position;
                {
                    this.val$helper = baseViewHolder;
                    this.val$item = object;
                    this.val$position = n;
                }

                public void onClick(View v) {
                    provider.onClick(this.val$helper, this.val$item, this.val$position);
                }
            });
        }
        if (longClickListener == null) {
            itemView.setOnLongClickListener(new View.OnLongClickListener((BaseViewHolder)((Object)helper), item, position){
                final /* synthetic */ BaseViewHolder val$helper;
                final /* synthetic */ Object val$item;
                final /* synthetic */ int val$position;
                {
                    this.val$helper = baseViewHolder;
                    this.val$item = object;
                    this.val$position = n;
                }

                public boolean onLongClick(View v) {
                    return provider.onLongClick(this.val$helper, this.val$item, this.val$position);
                }
            });
        }
    }
}

