/*
 * Decompiled with CFR 0.152.
 */
package com.chad.library.adapter.base.diff;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.DiffUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseQuickDiffCallback<T>
extends DiffUtil.Callback {
    private List<T> newList;
    private List<T> oldList;

    public BaseQuickDiffCallback(@Nullable List<T> newList) {
        this.newList = newList == null ? new ArrayList() : newList;
    }

    public List<T> getNewList() {
        return this.newList;
    }

    public List<T> getOldList() {
        return this.oldList;
    }

    public void setOldList(@Nullable List<T> oldList) {
        this.oldList = oldList == null ? new ArrayList() : oldList;
    }

    public int getOldListSize() {
        return this.oldList.size();
    }

    public int getNewListSize() {
        return this.newList.size();
    }

    public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
        return this.areItemsTheSame(this.oldList.get(oldItemPosition), this.newList.get(newItemPosition));
    }

    public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
        return this.areContentsTheSame(this.oldList.get(oldItemPosition), this.newList.get(newItemPosition));
    }

    @Nullable
    public Object getChangePayload(int oldItemPosition, int newItemPosition) {
        return this.getChangePayload(this.oldList.get(oldItemPosition), this.newList.get(newItemPosition));
    }

    protected abstract boolean areItemsTheSame(@NonNull T var1, @NonNull T var2);

    protected abstract boolean areContentsTheSame(@NonNull T var1, @NonNull T var2);

    @Nullable
    protected Object getChangePayload(@NonNull T oldItem, @NonNull T newItem) {
        return null;
    }
}

