/*
 * Decompiled with CFR 0.152.
 */
package com.chad.library.adapter.base;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import androidx.annotation.IdRes;
import androidx.annotation.IntRange;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.chad.library.adapter.base.BaseViewHolder;
import com.chad.library.adapter.base.animation.AlphaInAnimation;
import com.chad.library.adapter.base.animation.BaseAnimation;
import com.chad.library.adapter.base.animation.ScaleInAnimation;
import com.chad.library.adapter.base.animation.SlideInBottomAnimation;
import com.chad.library.adapter.base.animation.SlideInLeftAnimation;
import com.chad.library.adapter.base.animation.SlideInRightAnimation;
import com.chad.library.adapter.base.entity.IExpandable;
import com.chad.library.adapter.base.loadmore.LoadMoreView;
import com.chad.library.adapter.base.loadmore.SimpleLoadMoreView;
import com.chad.library.adapter.base.util.MultiTypeDelegate;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class BaseQuickAdapter<T, K extends BaseViewHolder>
extends RecyclerView.Adapter<K> {
    private boolean mNextLoadEnable = false;
    private boolean mLoadMoreEnable = false;
    private boolean mLoading = false;
    private LoadMoreView mLoadMoreView = new SimpleLoadMoreView();
    private RequestLoadMoreListener mRequestLoadMoreListener;
    private boolean mEnableLoadMoreEndClick = false;
    public static final int ALPHAIN = 1;
    public static final int SCALEIN = 2;
    public static final int SLIDEIN_BOTTOM = 3;
    public static final int SLIDEIN_LEFT = 4;
    public static final int SLIDEIN_RIGHT = 5;
    private OnItemClickListener mOnItemClickListener;
    private OnItemLongClickListener mOnItemLongClickListener;
    private OnItemChildClickListener mOnItemChildClickListener;
    private OnItemChildLongClickListener mOnItemChildLongClickListener;
    private boolean mFirstOnlyEnable = true;
    private boolean mOpenAnimationEnable = false;
    private Interpolator mInterpolator = new LinearInterpolator();
    private int mDuration = 300;
    private int mLastPosition = -1;
    private BaseAnimation mCustomAnimation;
    private BaseAnimation mSelectAnimation = new AlphaInAnimation();
    private LinearLayout mHeaderLayout;
    private LinearLayout mFooterLayout;
    private FrameLayout mEmptyLayout;
    private boolean mIsUseEmpty = true;
    private boolean mHeadAndEmptyEnable;
    private boolean mFootAndEmptyEnable;
    protected static final String TAG = BaseQuickAdapter.class.getSimpleName();
    protected Context mContext;
    protected int mLayoutResId;
    protected LayoutInflater mLayoutInflater;
    protected List<T> mData;
    public static final int HEADER_VIEW = 273;
    public static final int LOADING_VIEW = 546;
    public static final int FOOTER_VIEW = 819;
    public static final int EMPTY_VIEW = 1365;
    private RecyclerView mRecyclerView;
    private boolean mUpFetchEnable;
    private boolean mUpFetching;
    private UpFetchListener mUpFetchListener;
    private int mStartUpFetchPosition = 1;
    private boolean headerViewAsFlow;
    private boolean footerViewAsFlow;
    private SpanSizeLookup mSpanSizeLookup;
    private MultiTypeDelegate<T> mMultiTypeDelegate;
    private int mPreLoadNumber = 1;

    protected RecyclerView getRecyclerView() {
        return this.mRecyclerView;
    }

    private void setRecyclerView(RecyclerView recyclerView) {
        this.mRecyclerView = recyclerView;
    }

    private void checkNotNull() {
        if (this.getRecyclerView() == null) {
            throw new RuntimeException("please bind recyclerView first!");
        }
    }

    public void bindToRecyclerView(RecyclerView recyclerView) {
        if (this.getRecyclerView() != null) {
            throw new RuntimeException("Don't bind twice");
        }
        this.setRecyclerView(recyclerView);
        this.getRecyclerView().setAdapter((RecyclerView.Adapter)this);
    }

    @Deprecated
    public void setOnLoadMoreListener(RequestLoadMoreListener requestLoadMoreListener) {
        this.openLoadMore(requestLoadMoreListener);
    }

    private void openLoadMore(RequestLoadMoreListener requestLoadMoreListener) {
        this.mRequestLoadMoreListener = requestLoadMoreListener;
        this.mNextLoadEnable = true;
        this.mLoadMoreEnable = true;
        this.mLoading = false;
    }

    public void setOnLoadMoreListener(RequestLoadMoreListener requestLoadMoreListener, RecyclerView recyclerView) {
        this.openLoadMore(requestLoadMoreListener);
        if (this.getRecyclerView() == null) {
            this.setRecyclerView(recyclerView);
        }
    }

    public void disableLoadMoreIfNotFullPage() {
        this.checkNotNull();
        this.disableLoadMoreIfNotFullPage(this.getRecyclerView());
    }

    public void disableLoadMoreIfNotFullPage(RecyclerView recyclerView) {
        this.setEnableLoadMore(false);
        if (recyclerView == null) {
            return;
        }
        RecyclerView.LayoutManager manager = recyclerView.getLayoutManager();
        if (manager == null) {
            return;
        }
        if (manager instanceof LinearLayoutManager) {
            final LinearLayoutManager linearLayoutManager = (LinearLayoutManager)manager;
            recyclerView.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (BaseQuickAdapter.this.isFullScreen(linearLayoutManager)) {
                        BaseQuickAdapter.this.setEnableLoadMore(true);
                    }
                }
            }, 50L);
        } else if (manager instanceof StaggeredGridLayoutManager) {
            final StaggeredGridLayoutManager staggeredGridLayoutManager = (StaggeredGridLayoutManager)manager;
            recyclerView.postDelayed(new Runnable(){

                @Override
                public void run() {
                    int[] positions = new int[staggeredGridLayoutManager.getSpanCount()];
                    staggeredGridLayoutManager.findLastCompletelyVisibleItemPositions(positions);
                    int pos = BaseQuickAdapter.this.getTheBiggestNumber(positions) + 1;
                    if (pos != BaseQuickAdapter.this.getItemCount()) {
                        BaseQuickAdapter.this.setEnableLoadMore(true);
                    }
                }
            }, 50L);
        }
    }

    private boolean isFullScreen(LinearLayoutManager llm) {
        return llm.findLastCompletelyVisibleItemPosition() + 1 != this.getItemCount() || llm.findFirstCompletelyVisibleItemPosition() != 0;
    }

    private int getTheBiggestNumber(int[] numbers) {
        int tmp = -1;
        if (numbers == null || numbers.length == 0) {
            return tmp;
        }
        for (int num : numbers) {
            if (num <= tmp) continue;
            tmp = num;
        }
        return tmp;
    }

    public void setUpFetchEnable(boolean upFetch) {
        this.mUpFetchEnable = upFetch;
    }

    public boolean isUpFetchEnable() {
        return this.mUpFetchEnable;
    }

    public void setStartUpFetchPosition(int startUpFetchPosition) {
        this.mStartUpFetchPosition = startUpFetchPosition;
    }

    private void autoUpFetch(int positions) {
        if (!this.isUpFetchEnable() || this.isUpFetching()) {
            return;
        }
        if (positions <= this.mStartUpFetchPosition && this.mUpFetchListener != null) {
            this.mUpFetchListener.onUpFetch();
        }
    }

    public boolean isUpFetching() {
        return this.mUpFetching;
    }

    public void setUpFetching(boolean upFetching) {
        this.mUpFetching = upFetching;
    }

    public void setUpFetchListener(UpFetchListener upFetchListener) {
        this.mUpFetchListener = upFetchListener;
    }

    public void setNotDoAnimationCount(int count) {
        this.mLastPosition = count;
    }

    public void setLoadMoreView(LoadMoreView loadingView) {
        this.mLoadMoreView = loadingView;
    }

    public int getLoadMoreViewCount() {
        if (this.mRequestLoadMoreListener == null || !this.mLoadMoreEnable) {
            return 0;
        }
        if (!this.mNextLoadEnable && this.mLoadMoreView.isLoadEndMoreGone()) {
            return 0;
        }
        if (this.mData.size() == 0) {
            return 0;
        }
        return 1;
    }

    public int getLoadMoreViewPosition() {
        return this.getHeaderLayoutCount() + this.mData.size() + this.getFooterLayoutCount();
    }

    public boolean isLoading() {
        return this.mLoading;
    }

    public void loadMoreEnd() {
        this.loadMoreEnd(false);
    }

    public void loadMoreEnd(boolean gone) {
        if (this.getLoadMoreViewCount() == 0) {
            return;
        }
        this.mLoading = false;
        this.mNextLoadEnable = false;
        this.mLoadMoreView.setLoadMoreEndGone(gone);
        if (gone) {
            this.notifyItemRemoved(this.getLoadMoreViewPosition());
        } else {
            this.mLoadMoreView.setLoadMoreStatus(4);
            this.notifyItemChanged(this.getLoadMoreViewPosition());
        }
    }

    public void loadMoreComplete() {
        if (this.getLoadMoreViewCount() == 0) {
            return;
        }
        this.mLoading = false;
        this.mNextLoadEnable = true;
        this.mLoadMoreView.setLoadMoreStatus(1);
        this.notifyItemChanged(this.getLoadMoreViewPosition());
    }

    public void loadMoreFail() {
        if (this.getLoadMoreViewCount() == 0) {
            return;
        }
        this.mLoading = false;
        this.mLoadMoreView.setLoadMoreStatus(3);
        this.notifyItemChanged(this.getLoadMoreViewPosition());
    }

    public void setEnableLoadMore(boolean enable) {
        int oldLoadMoreCount = this.getLoadMoreViewCount();
        this.mLoadMoreEnable = enable;
        int newLoadMoreCount = this.getLoadMoreViewCount();
        if (oldLoadMoreCount == 1) {
            if (newLoadMoreCount == 0) {
                this.notifyItemRemoved(this.getLoadMoreViewPosition());
            }
        } else if (newLoadMoreCount == 1) {
            this.mLoadMoreView.setLoadMoreStatus(1);
            this.notifyItemInserted(this.getLoadMoreViewPosition());
        }
    }

    public boolean isLoadMoreEnable() {
        return this.mLoadMoreEnable;
    }

    public void setDuration(int duration) {
        this.mDuration = duration;
    }

    public final void refreshNotifyItemChanged(int position) {
        this.notifyItemChanged(position + this.getHeaderLayoutCount());
    }

    public BaseQuickAdapter(@LayoutRes int layoutResId, @Nullable List<T> data) {
        ArrayList arrayList = this.mData = data == null ? new ArrayList() : data;
        if (layoutResId != 0) {
            this.mLayoutResId = layoutResId;
        }
    }

    public BaseQuickAdapter(@Nullable List<T> data) {
        this(0, data);
    }

    public BaseQuickAdapter(@LayoutRes int layoutResId) {
        this(layoutResId, null);
    }

    public void setNewData(@Nullable List<T> data) {
        ArrayList arrayList = this.mData = data == null ? new ArrayList() : data;
        if (this.mRequestLoadMoreListener != null) {
            this.mNextLoadEnable = true;
            this.mLoadMoreEnable = true;
            this.mLoading = false;
            this.mLoadMoreView.setLoadMoreStatus(1);
        }
        this.mLastPosition = -1;
        this.notifyDataSetChanged();
    }

    @Deprecated
    public void add(@IntRange(from=0L) int position, @NonNull T item) {
        this.addData(position, item);
    }

    public void addData(@IntRange(from=0L) int position, @NonNull T data) {
        this.mData.add(position, data);
        this.notifyItemInserted(position + this.getHeaderLayoutCount());
        this.compatibilityDataSizeChanged(1);
    }

    public void addData(@NonNull T data) {
        this.mData.add(data);
        this.notifyItemInserted(this.mData.size() + this.getHeaderLayoutCount());
        this.compatibilityDataSizeChanged(1);
    }

    public void remove(@IntRange(from=0L) int position) {
        this.mData.remove(position);
        int internalPosition = position + this.getHeaderLayoutCount();
        this.notifyItemRemoved(internalPosition);
        this.compatibilityDataSizeChanged(0);
        this.notifyItemRangeChanged(internalPosition, this.mData.size() - internalPosition);
    }

    public void setData(@IntRange(from=0L) int index, @NonNull T data) {
        this.mData.set(index, data);
        this.notifyItemChanged(index + this.getHeaderLayoutCount());
    }

    public void addData(@IntRange(from=0L) int position, @NonNull Collection<? extends T> newData) {
        this.mData.addAll(position, newData);
        this.notifyItemRangeInserted(position + this.getHeaderLayoutCount(), newData.size());
        this.compatibilityDataSizeChanged(newData.size());
    }

    public void addData(@NonNull Collection<? extends T> newData) {
        this.mData.addAll(newData);
        this.notifyItemRangeInserted(this.mData.size() - newData.size() + this.getHeaderLayoutCount(), newData.size());
        this.compatibilityDataSizeChanged(newData.size());
    }

    public void replaceData(@NonNull Collection<? extends T> data) {
        if (data != this.mData) {
            this.mData.clear();
            this.mData.addAll(data);
        }
        this.notifyDataSetChanged();
    }

    private void compatibilityDataSizeChanged(int size) {
        int dataSize;
        int n = dataSize = this.mData == null ? 0 : this.mData.size();
        if (dataSize == size) {
            this.notifyDataSetChanged();
        }
    }

    @NonNull
    public List<T> getData() {
        return this.mData;
    }

    @Nullable
    public T getItem(@IntRange(from=0L) int position) {
        if (position >= 0 && position < this.mData.size()) {
            return this.mData.get(position);
        }
        return null;
    }

    @Deprecated
    public int getHeaderViewsCount() {
        return this.getHeaderLayoutCount();
    }

    @Deprecated
    public int getFooterViewsCount() {
        return this.getFooterLayoutCount();
    }

    public int getHeaderLayoutCount() {
        if (this.mHeaderLayout == null || this.mHeaderLayout.getChildCount() == 0) {
            return 0;
        }
        return 1;
    }

    public int getFooterLayoutCount() {
        if (this.mFooterLayout == null || this.mFooterLayout.getChildCount() == 0) {
            return 0;
        }
        return 1;
    }

    public int getEmptyViewCount() {
        if (this.mEmptyLayout == null || this.mEmptyLayout.getChildCount() == 0) {
            return 0;
        }
        if (!this.mIsUseEmpty) {
            return 0;
        }
        if (this.mData.size() != 0) {
            return 0;
        }
        return 1;
    }

    public int getItemCount() {
        int count;
        if (this.getEmptyViewCount() == 1) {
            count = 1;
            if (this.mHeadAndEmptyEnable && this.getHeaderLayoutCount() != 0) {
                ++count;
            }
            if (this.mFootAndEmptyEnable && this.getFooterLayoutCount() != 0) {
                ++count;
            }
        } else {
            count = this.getHeaderLayoutCount() + this.mData.size() + this.getFooterLayoutCount() + this.getLoadMoreViewCount();
        }
        return count;
    }

    public int getItemViewType(int position) {
        if (this.getEmptyViewCount() == 1) {
            boolean header = this.mHeadAndEmptyEnable && this.getHeaderLayoutCount() != 0;
            switch (position) {
                case 0: {
                    if (header) {
                        return 273;
                    }
                    return 1365;
                }
                case 1: {
                    if (header) {
                        return 1365;
                    }
                    return 819;
                }
                case 2: {
                    return 819;
                }
            }
            return 1365;
        }
        int numHeaders = this.getHeaderLayoutCount();
        if (position < numHeaders) {
            return 273;
        }
        int adjPosition = position - numHeaders;
        int adapterCount = this.mData.size();
        if (adjPosition < adapterCount) {
            return this.getDefItemViewType(adjPosition);
        }
        int numFooters = this.getFooterLayoutCount();
        if ((adjPosition -= adapterCount) < numFooters) {
            return 819;
        }
        return 546;
    }

    protected int getDefItemViewType(int position) {
        if (this.mMultiTypeDelegate != null) {
            return this.mMultiTypeDelegate.getDefItemViewType(this.mData, position);
        }
        return super.getItemViewType(position);
    }

    public K onCreateViewHolder(ViewGroup parent, int viewType) {
        BaseViewHolder baseViewHolder = null;
        this.mContext = parent.getContext();
        this.mLayoutInflater = LayoutInflater.from((Context)this.mContext);
        switch (viewType) {
            case 546: {
                baseViewHolder = (BaseViewHolder)((Object)this.getLoadingView(parent));
                break;
            }
            case 273: {
                baseViewHolder = (BaseViewHolder)((Object)this.createBaseViewHolder((View)this.mHeaderLayout));
                break;
            }
            case 1365: {
                baseViewHolder = (BaseViewHolder)((Object)this.createBaseViewHolder((View)this.mEmptyLayout));
                break;
            }
            case 819: {
                baseViewHolder = (BaseViewHolder)((Object)this.createBaseViewHolder((View)this.mFooterLayout));
                break;
            }
            default: {
                baseViewHolder = (BaseViewHolder)((Object)this.onCreateDefViewHolder(parent, viewType));
                this.bindViewClickListener(baseViewHolder);
            }
        }
        baseViewHolder.setAdapter(this);
        return (K)((Object)baseViewHolder);
    }

    private K getLoadingView(ViewGroup parent) {
        View view = this.getItemView(this.mLoadMoreView.getLayoutId(), parent);
        K holder = this.createBaseViewHolder(view);
        ((BaseViewHolder)((Object)holder)).itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (BaseQuickAdapter.this.mLoadMoreView.getLoadMoreStatus() == 3) {
                    BaseQuickAdapter.this.notifyLoadMoreToLoading();
                }
                if (BaseQuickAdapter.this.mEnableLoadMoreEndClick && BaseQuickAdapter.this.mLoadMoreView.getLoadMoreStatus() == 4) {
                    BaseQuickAdapter.this.notifyLoadMoreToLoading();
                }
            }
        });
        return holder;
    }

    public void notifyLoadMoreToLoading() {
        if (this.mLoadMoreView.getLoadMoreStatus() == 2) {
            return;
        }
        this.mLoadMoreView.setLoadMoreStatus(1);
        this.notifyItemChanged(this.getLoadMoreViewPosition());
    }

    public void enableLoadMoreEndClick(boolean enable) {
        this.mEnableLoadMoreEndClick = enable;
    }

    public void onViewAttachedToWindow(K holder) {
        super.onViewAttachedToWindow(holder);
        int type = holder.getItemViewType();
        if (type == 1365 || type == 273 || type == 819 || type == 546) {
            this.setFullSpan((RecyclerView.ViewHolder)holder);
        } else {
            this.addAnimation((RecyclerView.ViewHolder)holder);
        }
    }

    protected void setFullSpan(RecyclerView.ViewHolder holder) {
        if (holder.itemView.getLayoutParams() instanceof StaggeredGridLayoutManager.LayoutParams) {
            StaggeredGridLayoutManager.LayoutParams params = (StaggeredGridLayoutManager.LayoutParams)holder.itemView.getLayoutParams();
            params.setFullSpan(true);
        }
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        RecyclerView.LayoutManager manager = recyclerView.getLayoutManager();
        if (manager instanceof GridLayoutManager) {
            final GridLayoutManager gridManager = (GridLayoutManager)manager;
            gridManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    int type = BaseQuickAdapter.this.getItemViewType(position);
                    if (type == 273 && BaseQuickAdapter.this.isHeaderViewAsFlow()) {
                        return 1;
                    }
                    if (type == 819 && BaseQuickAdapter.this.isFooterViewAsFlow()) {
                        return 1;
                    }
                    if (BaseQuickAdapter.this.mSpanSizeLookup == null) {
                        return BaseQuickAdapter.this.isFixedViewType(type) ? gridManager.getSpanCount() : 1;
                    }
                    return BaseQuickAdapter.this.isFixedViewType(type) ? gridManager.getSpanCount() : BaseQuickAdapter.this.mSpanSizeLookup.getSpanSize(gridManager, position - BaseQuickAdapter.this.getHeaderLayoutCount());
                }
            });
        }
    }

    protected boolean isFixedViewType(int type) {
        return type == 1365 || type == 273 || type == 819 || type == 546;
    }

    public void setHeaderViewAsFlow(boolean headerViewAsFlow) {
        this.headerViewAsFlow = headerViewAsFlow;
    }

    public boolean isHeaderViewAsFlow() {
        return this.headerViewAsFlow;
    }

    public void setFooterViewAsFlow(boolean footerViewAsFlow) {
        this.footerViewAsFlow = footerViewAsFlow;
    }

    public boolean isFooterViewAsFlow() {
        return this.footerViewAsFlow;
    }

    public void setSpanSizeLookup(SpanSizeLookup spanSizeLookup) {
        this.mSpanSizeLookup = spanSizeLookup;
    }

    public void onBindViewHolder(K holder, int position) {
        this.autoUpFetch(position);
        this.autoLoadMore(position);
        int viewType = holder.getItemViewType();
        switch (viewType) {
            case 0: {
                this.convert(holder, this.getItem(position - this.getHeaderLayoutCount()));
                break;
            }
            case 546: {
                this.mLoadMoreView.convert((BaseViewHolder)((Object)holder));
                break;
            }
            case 273: {
                break;
            }
            case 1365: {
                break;
            }
            case 819: {
                break;
            }
            default: {
                this.convert(holder, this.getItem(position - this.getHeaderLayoutCount()));
            }
        }
    }

    private void bindViewClickListener(final BaseViewHolder baseViewHolder) {
        if (baseViewHolder == null) {
            return;
        }
        View view = baseViewHolder.itemView;
        if (view == null) {
            return;
        }
        if (this.getOnItemClickListener() != null) {
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    BaseQuickAdapter.this.setOnItemClick(v, baseViewHolder.getLayoutPosition() - BaseQuickAdapter.this.getHeaderLayoutCount());
                }
            });
        }
        if (this.getOnItemLongClickListener() != null) {
            view.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    return BaseQuickAdapter.this.setOnItemLongClick(v, baseViewHolder.getLayoutPosition() - BaseQuickAdapter.this.getHeaderLayoutCount());
                }
            });
        }
    }

    public void setOnItemClick(View v, int position) {
        this.getOnItemClickListener().onItemClick(this, v, position);
    }

    public boolean setOnItemLongClick(View v, int position) {
        return this.getOnItemLongClickListener().onItemLongClick(this, v, position);
    }

    public void setMultiTypeDelegate(MultiTypeDelegate<T> multiTypeDelegate) {
        this.mMultiTypeDelegate = multiTypeDelegate;
    }

    public MultiTypeDelegate<T> getMultiTypeDelegate() {
        return this.mMultiTypeDelegate;
    }

    protected K onCreateDefViewHolder(ViewGroup parent, int viewType) {
        int layoutId = this.mLayoutResId;
        if (this.mMultiTypeDelegate != null) {
            layoutId = this.mMultiTypeDelegate.getLayoutId(viewType);
        }
        return this.createBaseViewHolder(parent, layoutId);
    }

    protected K createBaseViewHolder(ViewGroup parent, int layoutResId) {
        return this.createBaseViewHolder(this.getItemView(layoutResId, parent));
    }

    protected K createBaseViewHolder(View view) {
        Class z = null;
        for (Class<?> temp = ((Object)((Object)this)).getClass(); z == null && null != temp; temp = temp.getSuperclass()) {
            z = this.getInstancedGenericKClass(temp);
        }
        BaseViewHolder k = z == null ? new BaseViewHolder(view) : this.createGenericKInstance(z, view);
        return (K)((Object)(k != null ? k : new BaseViewHolder(view)));
    }

    private K createGenericKInstance(Class z, View view) {
        try {
            if (z.isMemberClass() && !Modifier.isStatic(z.getModifiers())) {
                Constructor constructor = z.getDeclaredConstructor(((Object)((Object)this)).getClass(), View.class);
                constructor.setAccessible(true);
                return (K)((Object)((BaseViewHolder)((Object)constructor.newInstance(new Object[]{this, view}))));
            }
            Constructor constructor = z.getDeclaredConstructor(View.class);
            constructor.setAccessible(true);
            return (K)((Object)((BaseViewHolder)((Object)constructor.newInstance(view))));
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    private Class getInstancedGenericKClass(Class z) {
        Type type = z.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            Type[] types;
            for (Type temp : types = ((ParameterizedType)type).getActualTypeArguments()) {
                Type rawType;
                if (temp instanceof Class) {
                    Class tempClass = (Class)temp;
                    if (!BaseViewHolder.class.isAssignableFrom(tempClass)) continue;
                    return tempClass;
                }
                if (!(temp instanceof ParameterizedType) || !((rawType = ((ParameterizedType)temp).getRawType()) instanceof Class) || !BaseViewHolder.class.isAssignableFrom((Class)rawType)) continue;
                return (Class)rawType;
            }
        }
        return null;
    }

    public LinearLayout getHeaderLayout() {
        return this.mHeaderLayout;
    }

    public LinearLayout getFooterLayout() {
        return this.mFooterLayout;
    }

    public int addHeaderView(View header) {
        return this.addHeaderView(header, -1);
    }

    public int addHeaderView(View header, int index) {
        return this.addHeaderView(header, index, 1);
    }

    public int addHeaderView(View header, int index, int orientation) {
        int position;
        if (this.mHeaderLayout == null) {
            this.mHeaderLayout = new LinearLayout(header.getContext());
            if (orientation == 1) {
                this.mHeaderLayout.setOrientation(1);
                this.mHeaderLayout.setLayoutParams((ViewGroup.LayoutParams)new RecyclerView.LayoutParams(-1, -2));
            } else {
                this.mHeaderLayout.setOrientation(0);
                this.mHeaderLayout.setLayoutParams((ViewGroup.LayoutParams)new RecyclerView.LayoutParams(-2, -1));
            }
        }
        int childCount = this.mHeaderLayout.getChildCount();
        if (index < 0 || index > childCount) {
            index = childCount;
        }
        this.mHeaderLayout.addView(header, index);
        if (this.mHeaderLayout.getChildCount() == 1 && (position = this.getHeaderViewPosition()) != -1) {
            this.notifyItemInserted(position);
        }
        return index;
    }

    public int setHeaderView(View header) {
        return this.setHeaderView(header, 0, 1);
    }

    public int setHeaderView(View header, int index) {
        return this.setHeaderView(header, index, 1);
    }

    public int setHeaderView(View header, int index, int orientation) {
        if (this.mHeaderLayout == null || this.mHeaderLayout.getChildCount() <= index) {
            return this.addHeaderView(header, index, orientation);
        }
        this.mHeaderLayout.removeViewAt(index);
        this.mHeaderLayout.addView(header, index);
        return index;
    }

    public int addFooterView(View footer) {
        return this.addFooterView(footer, -1, 1);
    }

    public int addFooterView(View footer, int index) {
        return this.addFooterView(footer, index, 1);
    }

    public int addFooterView(View footer, int index, int orientation) {
        int position;
        if (this.mFooterLayout == null) {
            this.mFooterLayout = new LinearLayout(footer.getContext());
            if (orientation == 1) {
                this.mFooterLayout.setOrientation(1);
                this.mFooterLayout.setLayoutParams((ViewGroup.LayoutParams)new RecyclerView.LayoutParams(-1, -2));
            } else {
                this.mFooterLayout.setOrientation(0);
                this.mFooterLayout.setLayoutParams((ViewGroup.LayoutParams)new RecyclerView.LayoutParams(-2, -1));
            }
        }
        int childCount = this.mFooterLayout.getChildCount();
        if (index < 0 || index > childCount) {
            index = childCount;
        }
        this.mFooterLayout.addView(footer, index);
        if (this.mFooterLayout.getChildCount() == 1 && (position = this.getFooterViewPosition()) != -1) {
            this.notifyItemInserted(position);
        }
        return index;
    }

    public int setFooterView(View header) {
        return this.setFooterView(header, 0, 1);
    }

    public int setFooterView(View header, int index) {
        return this.setFooterView(header, index, 1);
    }

    public int setFooterView(View header, int index, int orientation) {
        if (this.mFooterLayout == null || this.mFooterLayout.getChildCount() <= index) {
            return this.addFooterView(header, index, orientation);
        }
        this.mFooterLayout.removeViewAt(index);
        this.mFooterLayout.addView(header, index);
        return index;
    }

    public void removeHeaderView(View header) {
        int position;
        if (this.getHeaderLayoutCount() == 0) {
            return;
        }
        this.mHeaderLayout.removeView(header);
        if (this.mHeaderLayout.getChildCount() == 0 && (position = this.getHeaderViewPosition()) != -1) {
            this.notifyItemRemoved(position);
        }
    }

    public void removeFooterView(View footer) {
        int position;
        if (this.getFooterLayoutCount() == 0) {
            return;
        }
        this.mFooterLayout.removeView(footer);
        if (this.mFooterLayout.getChildCount() == 0 && (position = this.getFooterViewPosition()) != -1) {
            this.notifyItemRemoved(position);
        }
    }

    public void removeAllHeaderView() {
        if (this.getHeaderLayoutCount() == 0) {
            return;
        }
        this.mHeaderLayout.removeAllViews();
        int position = this.getHeaderViewPosition();
        if (position != -1) {
            this.notifyItemRemoved(position);
        }
    }

    public void removeAllFooterView() {
        if (this.getFooterLayoutCount() == 0) {
            return;
        }
        this.mFooterLayout.removeAllViews();
        int position = this.getFooterViewPosition();
        if (position != -1) {
            this.notifyItemRemoved(position);
        }
    }

    private int getHeaderViewPosition() {
        if (this.getEmptyViewCount() == 1) {
            if (this.mHeadAndEmptyEnable) {
                return 0;
            }
        } else {
            return 0;
        }
        return -1;
    }

    private int getFooterViewPosition() {
        if (this.getEmptyViewCount() == 1) {
            int position = 1;
            if (this.mHeadAndEmptyEnable && this.getHeaderLayoutCount() != 0) {
                ++position;
            }
            if (this.mFootAndEmptyEnable) {
                return position;
            }
        } else {
            return this.getHeaderLayoutCount() + this.mData.size();
        }
        return -1;
    }

    public void setEmptyView(int layoutResId, ViewGroup viewGroup) {
        View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(layoutResId, viewGroup, false);
        this.setEmptyView(view);
    }

    @Deprecated
    public void setEmptyView(int layoutResId) {
        this.checkNotNull();
        this.setEmptyView(layoutResId, (ViewGroup)this.getRecyclerView());
    }

    public void setEmptyView(View emptyView) {
        boolean insert = false;
        if (this.mEmptyLayout == null) {
            this.mEmptyLayout = new FrameLayout(emptyView.getContext());
            RecyclerView.LayoutParams layoutParams = new RecyclerView.LayoutParams(-1, -1);
            ViewGroup.LayoutParams lp = emptyView.getLayoutParams();
            if (lp != null) {
                layoutParams.width = lp.width;
                layoutParams.height = lp.height;
            }
            this.mEmptyLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            insert = true;
        }
        this.mEmptyLayout.removeAllViews();
        this.mEmptyLayout.addView(emptyView);
        this.mIsUseEmpty = true;
        if (insert && this.getEmptyViewCount() == 1) {
            int position = 0;
            if (this.mHeadAndEmptyEnable && this.getHeaderLayoutCount() != 0) {
                ++position;
            }
            this.notifyItemInserted(position);
        }
    }

    public void setHeaderAndEmpty(boolean isHeadAndEmpty) {
        this.setHeaderFooterEmpty(isHeadAndEmpty, false);
    }

    public void setHeaderFooterEmpty(boolean isHeadAndEmpty, boolean isFootAndEmpty) {
        this.mHeadAndEmptyEnable = isHeadAndEmpty;
        this.mFootAndEmptyEnable = isFootAndEmpty;
    }

    public void isUseEmpty(boolean isUseEmpty) {
        this.mIsUseEmpty = isUseEmpty;
    }

    public View getEmptyView() {
        return this.mEmptyLayout;
    }

    @Deprecated
    public void setAutoLoadMoreSize(int preLoadNumber) {
        this.setPreLoadNumber(preLoadNumber);
    }

    public void setPreLoadNumber(int preLoadNumber) {
        if (preLoadNumber > 1) {
            this.mPreLoadNumber = preLoadNumber;
        }
    }

    private void autoLoadMore(int position) {
        if (this.getLoadMoreViewCount() == 0) {
            return;
        }
        if (position < this.getItemCount() - this.mPreLoadNumber) {
            return;
        }
        if (this.mLoadMoreView.getLoadMoreStatus() != 1) {
            return;
        }
        this.mLoadMoreView.setLoadMoreStatus(2);
        if (!this.mLoading) {
            this.mLoading = true;
            if (this.getRecyclerView() != null) {
                this.getRecyclerView().post(new Runnable(){

                    @Override
                    public void run() {
                        BaseQuickAdapter.this.mRequestLoadMoreListener.onLoadMoreRequested();
                    }
                });
            } else {
                this.mRequestLoadMoreListener.onLoadMoreRequested();
            }
        }
    }

    private void addAnimation(RecyclerView.ViewHolder holder) {
        if (this.mOpenAnimationEnable && (!this.mFirstOnlyEnable || holder.getLayoutPosition() > this.mLastPosition)) {
            BaseAnimation animation = null;
            animation = this.mCustomAnimation != null ? this.mCustomAnimation : this.mSelectAnimation;
            for (Animator anim : animation.getAnimators(holder.itemView)) {
                this.startAnim(anim, holder.getLayoutPosition());
            }
            this.mLastPosition = holder.getLayoutPosition();
        }
    }

    protected void startAnim(Animator anim, int index) {
        anim.setDuration((long)this.mDuration).start();
        anim.setInterpolator((TimeInterpolator)this.mInterpolator);
    }

    protected View getItemView(@LayoutRes int layoutResId, ViewGroup parent) {
        return this.mLayoutInflater.inflate(layoutResId, parent, false);
    }

    public void openLoadAnimation(int animationType) {
        this.mOpenAnimationEnable = true;
        this.mCustomAnimation = null;
        switch (animationType) {
            case 1: {
                this.mSelectAnimation = new AlphaInAnimation();
                break;
            }
            case 2: {
                this.mSelectAnimation = new ScaleInAnimation();
                break;
            }
            case 3: {
                this.mSelectAnimation = new SlideInBottomAnimation();
                break;
            }
            case 4: {
                this.mSelectAnimation = new SlideInLeftAnimation();
                break;
            }
            case 5: {
                this.mSelectAnimation = new SlideInRightAnimation();
                break;
            }
        }
    }

    public void openLoadAnimation(BaseAnimation animation) {
        this.mOpenAnimationEnable = true;
        this.mCustomAnimation = animation;
    }

    public void openLoadAnimation() {
        this.mOpenAnimationEnable = true;
    }

    public void closeLoadAnimation() {
        this.mOpenAnimationEnable = false;
    }

    public void isFirstOnly(boolean firstOnly) {
        this.mFirstOnlyEnable = firstOnly;
    }

    protected abstract void convert(K var1, T var2);

    @Nullable
    public View getViewByPosition(int position, @IdRes int viewId) {
        this.checkNotNull();
        return this.getViewByPosition(this.getRecyclerView(), position, viewId);
    }

    @Nullable
    public View getViewByPosition(RecyclerView recyclerView, int position, @IdRes int viewId) {
        if (recyclerView == null) {
            return null;
        }
        BaseViewHolder viewHolder = (BaseViewHolder)recyclerView.findViewHolderForLayoutPosition(position);
        if (viewHolder == null) {
            return null;
        }
        return viewHolder.getView(viewId);
    }

    public long getItemId(int position) {
        return position;
    }

    private int recursiveExpand(int position, @NonNull List list) {
        int count = list.size();
        int pos = position + list.size() - 1;
        int i = list.size() - 1;
        while (i >= 0) {
            IExpandable item;
            if (list.get(i) instanceof IExpandable && (item = (IExpandable)list.get(i)).isExpanded() && this.hasSubItems(item)) {
                List subList = item.getSubItems();
                this.mData.addAll(pos + 1, subList);
                int subItemCount = this.recursiveExpand(pos + 1, subList);
                count += subItemCount;
            }
            --i;
            --pos;
        }
        return count;
    }

    public int expand(@IntRange(from=0L) int position, boolean animate, boolean shouldNotify) {
        IExpandable expandable = this.getExpandableItem(position -= this.getHeaderLayoutCount());
        if (expandable == null) {
            return 0;
        }
        if (!this.hasSubItems(expandable)) {
            expandable.setExpanded(true);
            this.notifyItemChanged(position);
            return 0;
        }
        int subItemCount = 0;
        if (!expandable.isExpanded()) {
            List list = expandable.getSubItems();
            this.mData.addAll(position + 1, list);
            subItemCount += this.recursiveExpand(position + 1, list);
            expandable.setExpanded(true);
        }
        int parentPos = position + this.getHeaderLayoutCount();
        if (shouldNotify) {
            if (animate) {
                this.notifyItemChanged(parentPos);
                this.notifyItemRangeInserted(parentPos + 1, subItemCount);
            } else {
                this.notifyDataSetChanged();
            }
        }
        return subItemCount;
    }

    public int expand(@IntRange(from=0L) int position, boolean animate) {
        return this.expand(position, animate, true);
    }

    public int expand(@IntRange(from=0L) int position) {
        return this.expand(position, true, true);
    }

    public int expandAll(int position, boolean animate, boolean notify) {
        T item;
        IExpandable expandable;
        Object endItem = null;
        if ((position -= this.getHeaderLayoutCount()) + 1 < this.mData.size()) {
            endItem = this.getItem(position + 1);
        }
        if ((expandable = this.getExpandableItem(position)) == null) {
            return 0;
        }
        if (!this.hasSubItems(expandable)) {
            expandable.setExpanded(true);
            this.notifyItemChanged(position);
            return 0;
        }
        int count = this.expand(position + this.getHeaderLayoutCount(), false, false);
        for (int i = position + 1; i < this.mData.size() && (item = this.getItem(i)) != endItem; ++i) {
            if (!this.isExpandable(item)) continue;
            count += this.expand(i + this.getHeaderLayoutCount(), false, false);
        }
        if (notify) {
            if (animate) {
                this.notifyItemRangeInserted(position + this.getHeaderLayoutCount() + 1, count);
            } else {
                this.notifyDataSetChanged();
            }
        }
        return count;
    }

    public int expandAll(int position, boolean init) {
        return this.expandAll(position, true, !init);
    }

    public void expandAll() {
        for (int i = this.mData.size() - 1 + this.getHeaderLayoutCount(); i >= this.getHeaderLayoutCount(); --i) {
            this.expandAll(i, false, false);
        }
    }

    private int recursiveCollapse(@IntRange(from=0L) int position) {
        T item = this.getItem(position);
        if (!this.isExpandable(item)) {
            return 0;
        }
        IExpandable expandable = (IExpandable)item;
        int subItemCount = 0;
        if (expandable.isExpanded()) {
            List subItems = expandable.getSubItems();
            if (null == subItems) {
                return 0;
            }
            for (int i = subItems.size() - 1; i >= 0; --i) {
                Object subItem = subItems.get(i);
                int pos = this.getItemPosition(subItem);
                if (pos < 0 || pos < position && (pos = position + i + 1) >= this.mData.size()) continue;
                if (subItem instanceof IExpandable) {
                    subItemCount += this.recursiveCollapse(pos);
                }
                this.mData.remove(pos);
                ++subItemCount;
            }
        }
        return subItemCount;
    }

    public int collapse(@IntRange(from=0L) int position, boolean animate, boolean notify) {
        IExpandable expandable = this.getExpandableItem(position -= this.getHeaderLayoutCount());
        if (expandable == null) {
            return 0;
        }
        int subItemCount = this.recursiveCollapse(position);
        expandable.setExpanded(false);
        int parentPos = position + this.getHeaderLayoutCount();
        if (notify) {
            if (animate) {
                this.notifyItemChanged(parentPos);
                this.notifyItemRangeRemoved(parentPos + 1, subItemCount);
            } else {
                this.notifyDataSetChanged();
            }
        }
        return subItemCount;
    }

    public int collapse(@IntRange(from=0L) int position) {
        return this.collapse(position, true, true);
    }

    public int collapse(@IntRange(from=0L) int position, boolean animate) {
        return this.collapse(position, animate, true);
    }

    private int getItemPosition(T item) {
        return item != null && this.mData != null && !this.mData.isEmpty() ? this.mData.indexOf(item) : -1;
    }

    public boolean hasSubItems(IExpandable item) {
        if (item == null) {
            return false;
        }
        List list = item.getSubItems();
        return list != null && list.size() > 0;
    }

    public boolean isExpandable(T item) {
        return item != null && item instanceof IExpandable;
    }

    private IExpandable getExpandableItem(int position) {
        T item = this.getItem(position);
        if (this.isExpandable(item)) {
            return (IExpandable)item;
        }
        return null;
    }

    public int getParentPosition(@NonNull T item) {
        int position = this.getItemPosition(item);
        if (position == -1) {
            return -1;
        }
        int level = item instanceof IExpandable ? ((IExpandable)item).getLevel() : Integer.MAX_VALUE;
        if (level == 0) {
            return position;
        }
        if (level == -1) {
            return -1;
        }
        for (int i = position; i >= 0; --i) {
            IExpandable expandable;
            T temp = this.mData.get(i);
            if (!(temp instanceof IExpandable) || (expandable = (IExpandable)temp).getLevel() < 0 || expandable.getLevel() >= level) continue;
            return i;
        }
        return -1;
    }

    public void setOnItemClickListener(@Nullable OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
    }

    public void setOnItemChildClickListener(OnItemChildClickListener listener) {
        this.mOnItemChildClickListener = listener;
    }

    public void setOnItemLongClickListener(OnItemLongClickListener listener) {
        this.mOnItemLongClickListener = listener;
    }

    public void setOnItemChildLongClickListener(OnItemChildLongClickListener listener) {
        this.mOnItemChildLongClickListener = listener;
    }

    public final OnItemLongClickListener getOnItemLongClickListener() {
        return this.mOnItemLongClickListener;
    }

    public final OnItemClickListener getOnItemClickListener() {
        return this.mOnItemClickListener;
    }

    @Nullable
    public final OnItemChildClickListener getOnItemChildClickListener() {
        return this.mOnItemChildClickListener;
    }

    @Nullable
    public final OnItemChildLongClickListener getOnItemChildLongClickListener() {
        return this.mOnItemChildLongClickListener;
    }

    public static interface OnItemClickListener {
        public void onItemClick(BaseQuickAdapter var1, View var2, int var3);
    }

    public static interface OnItemLongClickListener {
        public boolean onItemLongClick(BaseQuickAdapter var1, View var2, int var3);
    }

    public static interface OnItemChildLongClickListener {
        public boolean onItemChildLongClick(BaseQuickAdapter var1, View var2, int var3);
    }

    public static interface OnItemChildClickListener {
        public void onItemChildClick(BaseQuickAdapter var1, View var2, int var3);
    }

    public static interface RequestLoadMoreListener {
        public void onLoadMoreRequested();
    }

    public static interface SpanSizeLookup {
        public int getSpanSize(GridLayoutManager var1, int var2);
    }

    public static interface UpFetchListener {
        public void onUpFetch();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AnimationType {
    }
}

