/*
 * Decompiled with CFR 0.152.
 */
package com.msgilligan.bitcoinj.rpc.bitcoind;

import com.msgilligan.bitcoinj.rpc.bitcoind.AppDataDirectory;
import com.msgilligan.bitcoinj.rpc.bitcoind.BitcoinConf;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitcoinConfFile {
    private static final Logger log = LoggerFactory.getLogger(BitcoinConfFile.class);
    private static String BITCOINAPPNAME = "Bitcoin";
    private File file;

    public BitcoinConfFile() {
        this(new File(AppDataDirectory.forAppName(BITCOINAPPNAME), "bitcoin.conf"));
    }

    public BitcoinConfFile(File confFile) {
        this.file = confFile;
    }

    public static BitcoinConf readDefaultConfig() {
        return new BitcoinConfFile().readWithFallback();
    }

    public BitcoinConf read() throws IOException {
        List<String> lines = Files.readAllLines(this.file.toPath(), Charset.defaultCharset());
        return this.parseLines(lines);
    }

    public BitcoinConf readWithFallback() {
        BitcoinConf conf = new BitcoinConf();
        this.setDefaults(conf);
        try {
            conf = this.read();
        }
        catch (IOException e) {
            if (e instanceof NoSuchFileException) {
                log.warn("NoSuchFileException: " + this.file.getAbsolutePath());
            }
            log.error("Error reading " + this.file.getAbsolutePath() + ": " + e.getMessage());
            e.printStackTrace();
        }
        return conf;
    }

    private BitcoinConf parseLines(List<String> lines) {
        BitcoinConf conf = new BitcoinConf();
        for (String line : lines) {
            String trimmed;
            String[] kv;
            if (line.startsWith("#") || (kv = (trimmed = line.split("#")[0].trim()).split("=")).length != 2) continue;
            conf.put(kv[0], kv[1]);
        }
        return conf;
    }

    private void setDefaults(BitcoinConf conf) {
        conf.put("rpcconnect", "127.0.0.1");
        conf.put("rpcport", "8332");
        conf.put("rpcuser", "");
        conf.put("rpcpassword", "");
    }
}

