/*
 * Decompiled with CFR 0.152.
 */
package com.msgilligan.bitcoinj.rpc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import org.bitcoinj.core.NetworkParameters;

public class RpcConfig {
    private final NetworkParameters netParams;
    private final URI uri;
    private final String username;
    private final String password;

    public RpcConfig(NetworkParameters netParams, URI uri, String username, String password) {
        this.netParams = netParams;
        this.uri = uri;
        this.username = username;
        this.password = password;
    }

    public RpcConfig(String netIdString, URI uri, String username, String password) {
        this(NetworkParameters.fromID((String)netIdString), uri, username, password);
    }

    @JsonCreator
    public RpcConfig(@JsonProperty(value="netid") String netIdString, @JsonProperty(value="uri") String uri, @JsonProperty(value="username") String username, @JsonProperty(value="password") String password) {
        this(NetworkParameters.fromID((String)netIdString), URI.create(uri), username, password);
    }

    @JsonIgnore
    public NetworkParameters getNetParams() {
        return this.netParams;
    }

    @JsonProperty(value="netid")
    public String getNetIdString() {
        return this.netParams.getId();
    }

    public URI getURI() {
        return this.uri;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

