/*
 * Decompiled with CFR 0.152.
 */
package com.msgilligan.bitcoinj.json.conversion;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.msgilligan.bitcoinj.json.conversion.BitcoinMath;
import java.io.IOException;
import java.math.BigDecimal;
import org.bitcoinj.core.Coin;

public class CoinDeserializer
extends JsonDeserializer<Coin> {
    public Coin deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken token = p.getCurrentToken();
        switch (token) {
            case VALUE_NUMBER_FLOAT: {
                BigDecimal bd = p.getDecimalValue();
                return BitcoinMath.btcToCoin(bd);
            }
            case VALUE_NUMBER_INT: {
                long val = p.getNumberValue().longValue();
                return Coin.valueOf((long)val);
            }
        }
        return (Coin)ctxt.handleUnexpectedToken(Coin.class, p);
    }
}

