/*
 * Decompiled with CFR 0.152.
 */
package com.msgilligan.bitcoinj.json.conversion;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.bitcoinj.core.Coin;

public class BitcoinMath {
    public static final MathContext DEFAULT_CONTEXT = new MathContext(0, RoundingMode.UNNECESSARY);
    public static final int DEFAULT_SCALE = 8;
    public static final BigDecimal satoshiPerCoinDecimal = new BigDecimal(Coin.COIN.value, DEFAULT_CONTEXT);

    public static long btcToSatoshi(BigDecimal btc) {
        BigDecimal satoshisDecimal = btc.multiply(satoshiPerCoinDecimal);
        return satoshisDecimal.longValueExact();
    }

    public static BigDecimal satoshiToBtc(long satoshi) {
        BigDecimal bdSatoshi = new BigDecimal(satoshi, DEFAULT_CONTEXT);
        return bdSatoshi.divide(satoshiPerCoinDecimal, 8, RoundingMode.UNNECESSARY);
    }

    public static Coin btcToCoin(BigDecimal btc) {
        return Coin.valueOf((long)BitcoinMath.btcToSatoshi(btc));
    }

    public static BigDecimal coinToBTC(Coin coin) {
        return BitcoinMath.satoshiToBtc(coin.value);
    }
}

