/*
 * Decompiled with CFR 0.152.
 */
package com.commit451.foregroundviews;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import com.commit451.foregroundviews.R;

public class ForegroundDelegate {
    private Drawable mForeground;
    private Rect mSelfBounds = new Rect();
    private Rect mOverlayBounds = new Rect();
    private int mForegroundGravity = 119;
    private boolean mForegroundInPadding = true;
    private boolean mForegroundBoundsChanged = false;
    private View mView;

    public ForegroundDelegate(View view) {
        this.mView = view;
    }

    public void init(Context context, AttributeSet attrs, int defStyle, int defStyleRes) {
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ForegroundView, defStyle, defStyleRes);
            this.mForegroundGravity = a.getInt(R.styleable.ForegroundView_android_foregroundGravity, this.mForegroundGravity);
            Drawable d = a.getDrawable(R.styleable.ForegroundView_android_foreground);
            if (d != null) {
                this.setForeground(d);
            }
            this.mForegroundInPadding = a.getBoolean(R.styleable.ForegroundView_foregroundInsidePadding, true);
            a.recycle();
        }
    }

    public void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.mForegroundBoundsChanged = changed;
    }

    public void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.mForegroundBoundsChanged = true;
    }

    public Drawable getForeground() {
        return this.mForeground;
    }

    public void setForeground(Drawable drawable) {
        if (this.mForeground != drawable) {
            if (this.mForeground != null) {
                this.mForeground.setCallback(null);
                this.mView.unscheduleDrawable(this.mForeground);
            }
            this.mForeground = drawable;
            if (drawable != null) {
                this.mView.setWillNotDraw(false);
                drawable.setCallback((Drawable.Callback)this.mView);
                if (drawable.isStateful()) {
                    drawable.setState(this.mView.getDrawableState());
                }
                if (this.mForegroundGravity == 119) {
                    Rect padding = new Rect();
                    drawable.getPadding(padding);
                }
            } else {
                this.mView.setWillNotDraw(true);
            }
            this.mView.requestLayout();
            this.mView.invalidate();
        }
    }

    public int getForegroundGravity() {
        return this.mForegroundGravity;
    }

    public void setForegroundGravity(int foregroundGravity) {
        if (this.mForegroundGravity != foregroundGravity) {
            if ((foregroundGravity & 0x800007) == 0) {
                foregroundGravity |= 0x800003;
            }
            if ((foregroundGravity & 0x70) == 0) {
                foregroundGravity |= 0x30;
            }
            this.mForegroundGravity = foregroundGravity;
            if (this.mForegroundGravity == 119 && this.mForeground != null) {
                Rect padding = new Rect();
                this.mForeground.getPadding(padding);
            }
            this.mView.requestLayout();
        }
    }

    public void jumpDrawablesToCurrentState() {
        if (this.mForeground != null) {
            this.mForeground.jumpToCurrentState();
        }
    }

    public void drawableStateChanged() {
        if (this.mForeground != null && this.mForeground.isStateful()) {
            this.mForeground.setState(this.mView.getDrawableState());
        }
    }

    public void draw(Canvas canvas) {
        if (this.mForeground != null) {
            Drawable foreground = this.mForeground;
            if (this.mForegroundBoundsChanged) {
                this.mForegroundBoundsChanged = false;
                Rect selfBounds = this.mSelfBounds;
                Rect overlayBounds = this.mOverlayBounds;
                int w = this.mView.getRight() - this.mView.getLeft();
                int h = this.mView.getBottom() - this.mView.getTop();
                if (this.mForegroundInPadding) {
                    selfBounds.set(0, 0, w, h);
                } else {
                    selfBounds.set(this.mView.getPaddingLeft(), this.mView.getPaddingTop(), w - this.mView.getPaddingRight(), h - this.mView.getPaddingBottom());
                }
                Gravity.apply((int)this.mForegroundGravity, (int)foreground.getIntrinsicWidth(), (int)foreground.getIntrinsicHeight(), (Rect)selfBounds, (Rect)overlayBounds);
                foreground.setBounds(overlayBounds);
            }
            foreground.draw(canvas);
        }
    }

    @TargetApi(value=21)
    public void drawableHotspotChanged(float x, float y) {
        if (Build.VERSION.SDK_INT >= 21 && this.mForeground != null) {
            this.mForeground.setHotspot(x, y);
        }
    }
}

