/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.methods;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.clyze.jphantom.Signature;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.MethodNode;

public class MethodSignature
extends Signature {
    private final Method m;
    private final List<Type> exceptions;

    private MethodSignature(Builder builder) {
        super(builder.access);
        this.m = new Method(builder.name, builder.desc);
        this.exceptions = Collections.unmodifiableList(Arrays.asList(builder.exceptions));
    }

    public List<Type> getExceptions() {
        return this.exceptions;
    }

    public String[] getExceptionNames() {
        String[] exceptionNames = new String[this.exceptions.size()];
        int i = 0;
        for (Type exception : this.exceptions) {
            exceptionNames[i++] = exception.getInternalName();
        }
        return exceptionNames;
    }

    @Override
    public String toStringAux() {
        StringBuilder builder = new StringBuilder();
        this.appendAccess(builder);
        builder.append(this.toString(this.getReturnType()) + " " + this.getName() + "(");
        for (Type arg : this.getArgumentTypes()) {
            builder.append(this.toString(arg)).append(", ");
        }
        if (this.getArgumentTypes().length > 0) {
            builder.setLength(builder.length() - 2);
        }
        builder.append(")");
        if (!this.exceptions.isEmpty()) {
            builder.append(" throws ");
            for (Type exc : this.exceptions) {
                builder.append(this.toString(exc)).append(", ");
            }
            builder.setLength(builder.length() - 2);
        }
        return builder.toString();
    }

    public boolean equals(Object obj) {
        return this.m.equals(obj);
    }

    public int hashCode() {
        return this.m.hashCode();
    }

    public Type[] getArgumentTypes() {
        return this.m.getArgumentTypes();
    }

    public String getDescriptor() {
        return this.m.getDescriptor();
    }

    public String getName() {
        return this.m.getName();
    }

    public Type getReturnType() {
        return this.m.getReturnType();
    }

    public static MethodSignature fromMethodNode(MethodNode node) {
        return new Builder(node.name, node.desc).access(node.access).exceptions(node.exceptions.toArray(new String[0])).build();
    }

    public static class Builder {
        private final String name;
        private final String desc;
        private int access = 0;
        private Type[] exceptions = new Type[0];

        public Builder(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        public Builder access(int access) {
            this.access = access;
            return this;
        }

        public Builder exceptions(String ... exceptions) {
            if (exceptions != null) {
                this.exceptions = new Type[exceptions.length];
                int i = 0;
                for (String exc : exceptions) {
                    this.exceptions[i++] = Type.getObjectType((String)exc);
                }
            } else {
                this.exceptions = new Type[0];
            }
            return this;
        }

        public MethodSignature build() {
            return new MethodSignature(this);
        }
    }
}

