/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.jar;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarExtender {
    private final Path in;
    private final Path out;
    private final Path dir;
    private final byte[] buffer = new byte[1024];
    private int bytesRead;
    private final Logger logger = LoggerFactory.getLogger(JarExtender.class);

    public JarExtender(Path in, Path out, Path dir) {
        this.in = in;
        this.out = out;
        this.dir = dir;
        if (!Files.exists(in, new LinkOption[0])) {
            throw new IllegalArgumentException();
        }
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IllegalArgumentException("" + dir);
        }
    }

    public void extend() throws IOException {
        try (JarFile injar = new JarFile(this.in.toFile());
             JarOutputStream outjar = new JarOutputStream(new FileOutputStream(this.out.toFile()));){
            this.logger.info("Copying old entries...");
            for (JarEntry entry : Collections.list(injar.entries())) {
                InputStream entryStream = injar.getInputStream(entry);
                outjar.putNextEntry(entry);
                while ((this.bytesRead = entryStream.read(this.buffer)) != -1) {
                    outjar.write(this.buffer, 0, this.bytesRead);
                }
            }
            Files.walkFileTree(this.dir, new JarEntryCopyingVisitor(outjar));
        }
    }

    private class JarEntryCopyingVisitor
    extends SimpleFileVisitor<Path> {
        private final JarOutputStream jar;

        public JarEntryCopyingVisitor(JarOutputStream jar) {
            this.jar = jar;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            try (FileInputStream stream = new FileInputStream(file.toFile());){
                file = file.toAbsolutePath();
                file = JarExtender.this.dir.toAbsolutePath().relativize(file);
                JarExtender.this.logger.info("Adding entry: " + file);
                JarEntry entry = new JarEntry(file.toString().replace("\\", "/"));
                this.jar.putNextEntry(entry);
                while ((JarExtender.this.bytesRead = ((InputStream)stream).read(JarExtender.this.buffer)) != -1) {
                    this.jar.write(JarExtender.this.buffer, 0, JarExtender.this.bytesRead);
                }
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

