/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.hier;

import org.clyze.jphantom.hier.ClassHierarchies;
import org.clyze.jphantom.hier.ClassHierarchy;
import org.clyze.jphantom.hier.ForwardingClassHierarchy;
import org.clyze.jphantom.hier.graph.GraphConverter;
import org.clyze.jphantom.hier.graph.Node;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graphs;
import org.jgrapht.graph.DefaultEdge;
import org.objectweb.asm.Type;

public class PrintableClassHierarchy
extends ForwardingClassHierarchy {
    private static final String step = "  ";
    private static final Node ROOT = Node.get(OBJECT);
    private DirectedGraph<Node, DefaultEdge> graph = null;
    private StringBuilder builder = null;

    public PrintableClassHierarchy(ClassHierarchy hierarchy) {
        super(hierarchy);
    }

    private boolean isInterface(Node n) {
        return this.isInterface(n.asType());
    }

    @Override
    public void addClass(Type clazz, Type superclass, Type[] interfaces) {
        this.builder = null;
        super.addClass(clazz, superclass, interfaces);
    }

    @Override
    public void addInterface(Type iface, Type[] superInterfaces) {
        this.builder = null;
        super.addInterface(iface, superInterfaces);
    }

    @Override
    public String toString() {
        if (this.builder != null) {
            return this.builder.toString();
        }
        if (!ClassHierarchies.unknownTypes(this.hierarchy).isEmpty()) {
            throw new IllegalStateException();
        }
        this.graph = new GraphConverter(this.hierarchy).convert();
        this.builder = new StringBuilder();
        return this.appendHierarchy().toString();
    }

    private StringBuilder appendClassTree(Node root) {
        return this.appendClassTree(root, "");
    }

    private StringBuilder appendInterfaceTree(Node root, Node parent) {
        return this.appendInterfaceTree(root, parent, "");
    }

    private StringBuilder appendClassTree(Node root, String prefix) {
        if (this.isInterface(root)) {
            return this.builder;
        }
        this.builder.append(prefix).append("* class ").append(root);
        if (this.graph.outDegreeOf((Object)root) > 1) {
            this.builder.append(" (implements ");
            for (Node succ : Graphs.successorListOf(this.graph, (Object)root)) {
                if (!this.isInterface(succ)) continue;
                this.builder.append(succ).append(", ");
            }
            this.builder.setLength(this.builder.length() - 2);
            this.builder.append(")");
        }
        this.builder.append('\n');
        for (Node pred : Graphs.predecessorListOf(this.graph, (Object)root)) {
            this.appendClassTree(pred, prefix + step);
        }
        return this.builder;
    }

    private StringBuilder appendInterfaceTree(Node root, Node parent, String prefix) {
        if (!this.isInterface(root)) {
            return this.builder;
        }
        this.builder.append(prefix).append("* interface ").append(root);
        if (this.graph.outDegreeOf((Object)root) > 2) {
            this.builder.append(" (also extends ");
            for (Node succ : Graphs.successorListOf(this.graph, (Object)root)) {
                if (!this.isInterface(succ) || succ.equals(parent)) continue;
                this.builder.append(succ).append(", ");
            }
            this.builder.setLength(this.builder.length() - 2);
            this.builder.append(")");
        }
        this.builder.append('\n');
        for (Node pred : Graphs.predecessorListOf(this.graph, (Object)root)) {
            this.appendInterfaceTree(pred, root, prefix + step);
        }
        return this.builder;
    }

    private StringBuilder appendHierarchy() {
        this.builder.append("Class Hierarchy\n\n");
        this.appendClassTree(ROOT);
        this.builder.append("\n\nInterface Hierarchy\n\n");
        for (Node pred : Graphs.predecessorListOf(this.graph, (Object)ROOT)) {
            if (!this.isInterface(pred) || this.graph.outDegreeOf((Object)pred) > 1) continue;
            this.appendInterfaceTree(pred, ROOT);
        }
        return this.builder;
    }
}

