/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.hier;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.clyze.jphantom.Types;
import org.clyze.jphantom.hier.ClassHierarchy;
import org.clyze.jphantom.hier.SystemClassHierarchy;
import org.clyze.jphantom.util.Command;
import org.objectweb.asm.Type;

public class Importer
implements Command,
Types {
    private final ClassHierarchy target;
    private final ClassHierarchy source;

    public Importer(ClassHierarchy target, ClassHierarchy source) {
        this.target = target;
        this.source = source;
    }

    public Importer(ClassHierarchy target, ClassLoader loader) {
        this(target, SystemClassHierarchy.getInstance(loader));
    }

    protected ClassHierarchy getTarget() {
        return this.target;
    }

    protected ClassHierarchy getSource() {
        return this.source;
    }

    @Override
    public void execute() {
        LinkedList<Type> copy = new LinkedList<Type>();
        for (Type i : this.target) {
            copy.add(i);
        }
        for (Type i : copy) {
            HashSet<Type> supertypes = new HashSet<Type>(this.target.getInterfaces(i));
            Type sc = this.target.getSuperclass(i);
            if (sc != null) {
                supertypes.add(sc);
            }
            for (Type j : supertypes) {
                this.importFrom(j);
            }
        }
    }

    public void execute(Type el) {
        if (!this.source.contains(el)) {
            throw new IllegalArgumentException();
        }
        this.importFrom(el);
    }

    public void importFrom(Type root) {
        if (root == null || !this.source.contains(root)) {
            return;
        }
        if (!this.target.contains(root)) {
            Type sc = this.source.getSuperclass(root);
            Set<Type> ifaces = this.source.getInterfaces(root);
            for (Type i : ifaces) {
                this.importFrom(i);
            }
            this.importFrom(sc);
            if (this.source.isInterface(root)) {
                this.target.addInterface(root, ifaces.toArray(new Type[0]));
            } else {
                this.target.addClass(root, sc, ifaces.toArray(new Type[0]));
            }
        }
    }
}

