/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.hier;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.clyze.jphantom.Types;
import org.clyze.jphantom.hier.ClassHierarchy;
import org.clyze.jphantom.hier.Importer;
import org.clyze.jphantom.hier.IncrementalClassHierarchy;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class ClassHierarchies
implements Opcodes,
Types {
    private ClassHierarchies() {
        throw new AssertionError();
    }

    public static void loadSystemType(ClassHierarchy hierarchy, Class<?> clazz) {
        new Importer(hierarchy, clazz.getClassLoader()).execute(Type.getType(clazz));
    }

    public static Set<Type> unknownTypes(ClassHierarchy hierarchy) {
        HashSet<Type> unknown = new HashSet<Type>();
        for (Type c : hierarchy) {
            Type sc = hierarchy.getSuperclass(c);
            Set<Type> ifaces = hierarchy.getInterfaces(c);
            if (sc != null) {
                if (!hierarchy.contains(sc)) {
                    unknown.add(sc);
                } else assert (!hierarchy.isInterface(sc)) : sc;
            }
            for (Type iface : ifaces) {
                if (!hierarchy.contains(iface)) {
                    unknown.add(iface);
                    continue;
                }
                assert (hierarchy.isInterface(iface)) : iface;
            }
        }
        return unknown;
    }

    public static ClassHierarchy fromJar(String jarname) throws IOException {
        return ClassHierarchies.fromJar(new JarFile(jarname));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassHierarchy fromJar(JarFile file) throws IOException {
        try {
            IncrementalClassHierarchy hierarchy = new IncrementalClassHierarchy();
            Enumeration<JarEntry> e = file.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
                InputStream stream = file.getInputStream(entry);
                Throwable throwable = null;
                try {
                    boolean isInterface;
                    ClassReader reader = new ClassReader(stream);
                    String[] ifaceNames = reader.getInterfaces();
                    String superName = reader.getSuperName();
                    if (superName == null) {
                        superName = "java/lang/Object";
                    }
                    Type clazz = Type.getObjectType((String)reader.getClassName());
                    Type superclass = Type.getObjectType((String)superName);
                    Type[] ifaces = new Type[ifaceNames.length];
                    for (int i = 0; i < ifaces.length; ++i) {
                        ifaces[i] = Type.getObjectType((String)ifaceNames[i]);
                    }
                    boolean bl = isInterface = (reader.getAccess() & 0x200) != 0;
                    if (isInterface) {
                        hierarchy.addInterface(clazz, ifaces);
                        assert (superclass.equals((Object)OBJECT));
                        continue;
                    }
                    hierarchy.addClass(clazz, superclass, ifaces);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            IncrementalClassHierarchy incrementalClassHierarchy = hierarchy;
            return incrementalClassHierarchy;
        }
        finally {
            file.close();
        }
    }
}

