/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.dataflow;

import java.util.LinkedList;
import java.util.List;
import org.clyze.jphantom.dataflow.CompoundValue;
import org.clyze.jphantom.dataflow.TypeInterpreter;
import org.clyze.jphantom.hier.ClassHierarchy;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Interpreter;

public class ExtendedInterpreter
extends Interpreter<CompoundValue>
implements Opcodes {
    private TypeInterpreter i;

    public ExtendedInterpreter(ClassHierarchy hier) {
        this(589824, hier);
    }

    public ExtendedInterpreter(int api, ClassHierarchy hier) {
        super(api);
        this.i = new TypeInterpreter(api, hier);
    }

    public CompoundValue newValue(Type type) {
        return CompoundValue.fromBasicValue(this.i.newValue(type));
    }

    public CompoundValue newOperation(AbstractInsnNode insn) throws AnalyzerException {
        return CompoundValue.fromBasicValue(this.i.newOperation(insn));
    }

    public CompoundValue copyOperation(AbstractInsnNode insn, CompoundValue value) throws AnalyzerException {
        return value;
    }

    public CompoundValue unaryOperation(AbstractInsnNode insn, CompoundValue value) throws AnalyzerException {
        return CompoundValue.fromBasicValue(this.i.unaryOperation(insn, value.asBasicValue()));
    }

    public CompoundValue binaryOperation(AbstractInsnNode insn, CompoundValue value1, CompoundValue value2) throws AnalyzerException {
        BasicValue v1 = value1.asBasicValue();
        BasicValue v2 = value2.asBasicValue();
        if (insn.getOpcode() == 50) {
            switch (value1.values().size()) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    CompoundValue left = null;
                    for (BasicValue b : value1.values()) {
                        CompoundValue right = CompoundValue.fromBasicValue(this.i.binaryOperation(insn, b, v2));
                        left = left == null ? right : this.merge(left, right);
                    }
                    return left;
                }
            }
        }
        return CompoundValue.fromBasicValue(this.i.binaryOperation(insn, v1, v2));
    }

    public CompoundValue ternaryOperation(AbstractInsnNode insn, CompoundValue value1, CompoundValue value2, CompoundValue value3) throws AnalyzerException {
        return CompoundValue.fromBasicValue(this.i.ternaryOperation(insn, value1.asBasicValue(), value2.asBasicValue(), value3.asBasicValue()));
    }

    public CompoundValue naryOperation(AbstractInsnNode insn, List<? extends CompoundValue> values) throws AnalyzerException {
        LinkedList<BasicValue> l = new LinkedList<BasicValue>();
        for (CompoundValue compoundValue : values) {
            l.add(compoundValue.asBasicValue());
        }
        return CompoundValue.fromBasicValue(this.i.naryOperation(insn, l));
    }

    public void returnOperation(AbstractInsnNode insn, CompoundValue value, CompoundValue expected) throws AnalyzerException {
        this.i.returnOperation(insn, value.asBasicValue(), expected.asBasicValue());
    }

    public CompoundValue merge(CompoundValue v, CompoundValue w) {
        return CompoundValue.fromMerge(v, w);
    }
}

