/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.dataflow;

import java.util.Collections;
import java.util.Set;
import org.clyze.jphantom.dataflow.TypeInterpreter;
import org.clyze.jphantom.util.Utils;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Value;

public abstract class CompoundValue
implements Value {
    private final Set<BasicValue> v;
    protected final Set<BasicValue> uv;

    private CompoundValue(Set<BasicValue> basic) {
        this.v = basic;
        this.uv = Collections.unmodifiableSet(this.v);
    }

    public Set<BasicValue> values() {
        assert (!this.uv.isEmpty() || this.asBasicValue().equals((Object)TypeInterpreter.NULL_VALUE));
        return this.uv;
    }

    public boolean isEmpty() {
        return this.uv.isEmpty();
    }

    protected boolean contains(CompoundValue other) {
        return this.uv.containsAll(other.uv);
    }

    public abstract BasicValue asBasicValue();

    public abstract boolean isReference();

    public static CompoundValue fromBasicValue(BasicValue val) {
        return val == null ? null : new SimpleCompoundValue(val);
    }

    public static CompoundValue fromMerge(CompoundValue left, CompoundValue right) {
        if (left.equals(right)) {
            return left;
        }
        if (!left.isReference() || !right.isReference()) {
            if (BasicValue.UNINITIALIZED_VALUE.equals((Object)left.asBasicValue()) || BasicValue.UNINITIALIZED_VALUE.equals((Object)right.asBasicValue())) {
                // empty if block
            }
            return CompoundValue.fromBasicValue(BasicValue.UNINITIALIZED_VALUE);
        }
        if (left.isEmpty() || right.contains(left)) {
            return right;
        }
        if (right.isEmpty() || left.contains(right)) {
            return left;
        }
        return new MergedCompoundValue(left, right);
    }

    private static class MergingException
    extends RuntimeException {
        protected static final long serialVersionUID = 8347563458345634534L;
        private final CompoundValue left;
        private final CompoundValue right;

        MergingException(CompoundValue left, CompoundValue right) {
            this.left = left;
            this.right = right;
        }
    }

    private static class MergedCompoundValue
    extends CompoundValue {
        private final CompoundValue left;
        private final CompoundValue right;

        private MergedCompoundValue(CompoundValue left, CompoundValue right) {
            super(Utils.union(left.values(), right.values()));
            this.left = left;
            this.right = right;
            if (left.getSize() != right.getSize()) {
                throw new IllegalArgumentException(left + " " + right);
            }
            if (!left.isReference()) {
                throw new IllegalArgumentException(left.toString());
            }
            if (!right.isReference()) {
                throw new IllegalArgumentException(right.toString());
            }
            for (BasicValue v : this.uv) {
                if (v == BasicValue.UNINITIALIZED_VALUE) {
                    throw new IllegalArgumentException("Uninitialized value participates in a merge!!!");
                }
                assert (v.getType() != null);
            }
            assert (this.uv.size() > 1);
            assert (this.uv.size() > left.values().size());
            assert (this.uv.size() > right.values().size());
        }

        @Override
        public BasicValue asBasicValue() {
            return null;
        }

        public int getSize() {
            return this.left.getSize();
        }

        @Override
        public boolean isReference() {
            return true;
        }

        public String toString() {
            return "(" + this.left.toString() + "," + this.right.toString() + ")";
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MergedCompoundValue)) {
                return false;
            }
            MergedCompoundValue v = (MergedCompoundValue)other;
            return this.uv.equals(v.uv);
        }

        public int hashCode() {
            return this.uv.hashCode();
        }
    }

    private static class SimpleCompoundValue
    extends CompoundValue {
        private final BasicValue val;

        private SimpleCompoundValue(BasicValue val) {
            super(SimpleCompoundValue.makeSet(val));
            this.val = val;
        }

        private static Set<BasicValue> makeSet(BasicValue val) {
            return val.equals((Object)TypeInterpreter.NULL_VALUE) ? Collections.emptySet() : Collections.singleton(val);
        }

        @Override
        public BasicValue asBasicValue() {
            return this.val;
        }

        public int getSize() {
            return this.val.getSize();
        }

        @Override
        public boolean isReference() {
            return this.val.isReference();
        }

        public String toString() {
            return this.val.toString();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SimpleCompoundValue)) {
                return false;
            }
            SimpleCompoundValue v = (SimpleCompoundValue)other;
            return this.val.equals((Object)v.val);
        }

        public int hashCode() {
            return this.val.hashCode();
        }
    }
}

