/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.conversions;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.clyze.jphantom.ArrayTypes;
import org.clyze.jphantom.Types;
import org.clyze.jphantom.conversions.Conversion;
import org.clyze.jphantom.conversions.IdentityConversion;
import org.clyze.jphantom.conversions.IllegalConversion;
import org.clyze.jphantom.conversions.NarrowingPrimitiveConversion;
import org.clyze.jphantom.conversions.NullConversion;
import org.clyze.jphantom.conversions.WideningPrimitiveConversion;
import org.clyze.jphantom.conversions.WideningReferenceConversion;
import org.clyze.jphantom.util.Pair;
import org.objectweb.asm.Type;

public class Conversions
implements Types {
    private static final Map<Type, Set<Type>> WIDENING_PRIMITIVE_CONVERSIONS;
    private static final Map<Type, Set<Type>> NARROWING_PRIMITIVE_CONVERSIONS;
    private static final Map<Pair<Type, Type>, Conversion> cache;

    private Conversions() {
        throw new AssertionError();
    }

    public static boolean isPrimitive(Type t) {
        switch (t.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
            case 0: 
            case 9: 
            case 10: 
            case 11: {
                return false;
            }
        }
        throw new AssertionError();
    }

    public static boolean isReference(Type t) {
        switch (t.getSort()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                return false;
            }
            case 9: 
            case 10: {
                return true;
            }
        }
        throw new AssertionError();
    }

    private static final boolean isWideningPrimConv(Pair<Type, Type> pair) {
        return WIDENING_PRIMITIVE_CONVERSIONS.containsKey(pair.fst) && WIDENING_PRIMITIVE_CONVERSIONS.get(pair.fst).contains(pair.snd);
    }

    private static final boolean isNarrowingPrimConv(Pair<Type, Type> pair) {
        return NARROWING_PRIMITIVE_CONVERSIONS.containsKey(pair.fst) && NARROWING_PRIMITIVE_CONVERSIONS.get(pair.fst).contains(pair.snd);
    }

    public static Conversion getAssignmentConversion(Type from, Type to) {
        Pair<Type, Type> pair = new Pair<Type, Type>(from, to);
        if (!cache.containsKey(pair)) {
            cache.put(pair, Conversions.newAssignmentConversion(pair));
        }
        return cache.get(pair);
    }

    public static Conversion newAssignmentConversion(Pair<Type, Type> pair) {
        Type from = (Type)pair.fst;
        Type to = (Type)pair.snd;
        if (from.equals((Object)to)) {
            return new IdentityConversion(from, to);
        }
        if (Conversions.isWideningPrimConv(pair)) {
            return new WideningPrimitiveConversion(from, to);
        }
        if (Conversions.isNarrowingPrimConv(pair)) {
            return new NarrowingPrimitiveConversion(from, to);
        }
        if (!Conversions.isReference(from)) {
            return new IllegalConversion(from, to);
        }
        if (!Conversions.isReference(to)) {
            return new IllegalConversion(from, to);
        }
        if (from.equals((Object)NULL_TYPE)) {
            return new NullConversion(to);
        }
        if (from.getSort() == 9) {
            Conversion subconv;
            if (!(ARRAY_INTERFACES.contains(to) || to.equals((Object)OBJECT) || to.getSort() == 9 && !((subconv = Conversions.getAssignmentConversion(ArrayTypes.elementOf(from), ArrayTypes.elementOf(to))) instanceof IllegalConversion))) {
                return new IllegalConversion(from, to);
            }
        } else if (to.getSort() == 9) {
            return new IllegalConversion(from, to);
        }
        return new WideningReferenceConversion(from, to);
    }

    static {
        Type[] types;
        WIDENING_PRIMITIVE_CONVERSIONS = new HashMap<Type, Set<Type>>();
        NARROWING_PRIMITIVE_CONVERSIONS = new HashMap<Type, Set<Type>>();
        HashSet<Type> tmp = new HashSet<Type>(Collections.singletonList(Type.DOUBLE_TYPE));
        for (Type t : types = new Type[]{Type.FLOAT_TYPE, Type.LONG_TYPE, Type.INT_TYPE, Type.CHAR_TYPE, Type.SHORT_TYPE, Type.BYTE_TYPE}) {
            WIDENING_PRIMITIVE_CONVERSIONS.put(t, new HashSet<Type>(tmp));
            tmp.add(t);
        }
        NARROWING_PRIMITIVE_CONVERSIONS.put(Type.INT_TYPE, new HashSet<Type>(Arrays.asList(Type.CHAR_TYPE, Type.SHORT_TYPE, Type.BYTE_TYPE, Type.BOOLEAN_TYPE)));
        cache = new HashMap<Pair<Type, Type>, Conversion>();
    }
}

