/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.constraints.solvers;

import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.clyze.jphantom.constraints.solvers.AbstractSolver;
import org.clyze.jphantom.constraints.solvers.Solver;
import org.clyze.jphantom.util.MapFactory;
import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.alg.ConnectivityInspector;
import org.jgrapht.graph.AsUndirectedGraph;
import org.jgrapht.graph.SimpleDirectedGraph;

public class SingleInheritanceSolver<V, E>
extends AbstractSolver<V, E, Map<V, V>> {
    protected final V root;

    public SingleInheritanceSolver(EdgeFactory<V, E> factory, V root) {
        super(factory, new MapFactory());
        this.root = root;
        this._graph.addVertex(root);
    }

    public SingleInheritanceSolver(DirectedGraph<V, E> graph, V root) {
        super(graph, new MapFactory());
        this.root = root;
        this._graph.addVertex(root);
        for (Object v : this._graph.vertexSet()) {
            if (v.equals(root)) continue;
            this._graph.addEdge(v, root);
        }
    }

    @Override
    public void addConstraintEdge(V source, V target) {
        super.addConstraintEdge(source, target);
        this._graph.addEdge(source, this.root);
        this._graph.addEdge(target, this.root);
    }

    private DirectedGraph<V, E> getComponent(DirectedGraph<V, E> graph, V node) {
        AsUndirectedGraph undirectedView = new AsUndirectedGraph(graph);
        Set nodes = new ConnectivityInspector((UndirectedGraph)undirectedView).connectedSetOf(node);
        DirectedGraph<V, E> subgraph = this.createSubgraph(graph, nodes);
        SimpleDirectedGraph result = new SimpleDirectedGraph(graph.getEdgeFactory());
        Graphs.addGraph((Graph)result, subgraph);
        return result;
    }

    private DirectedGraph<V, E> createSubgraph(DirectedGraph<V, E> graph, Set<V> nodes) {
        SimpleDirectedGraph subgraph = new SimpleDirectedGraph(graph.getEdgeFactory());
        for (V vertex : nodes) {
            subgraph.addVertex(vertex);
            for (Object edge : graph.outgoingEdgesOf(vertex)) {
                Object target = graph.getEdgeTarget(edge);
                subgraph.addVertex(target);
                subgraph.addEdge(graph.getEdgeSource(edge), target);
            }
        }
        return subgraph;
    }

    private void placeUnder(V top, DirectedGraph<V, E> graph) throws AbstractSolver.GraphCycleException {
        graph.removeVertex(top);
        HashSet unconstrained = new HashSet();
        for (Object vertex : graph.vertexSet()) {
            if (graph.outDegreeOf(vertex) != 0) continue;
            unconstrained.add(vertex);
        }
        Deque ul = this.order(unconstrained, top);
        while (!ul.isEmpty()) {
            Object next = ul.removeFirst();
            if (!graph.containsVertex(next)) continue;
            assert (!((Map)this.solution).containsKey(next));
            ((Map)this.solution).put(next, top);
            DirectedGraph<V, E> subgraph = this.getComponent(graph, next);
            graph.removeAllEdges((Collection)subgraph.edgeSet());
            for (Object vertex : subgraph.vertexSet()) {
                assert (graph.edgesOf(vertex).isEmpty());
                graph.removeVertex(vertex);
            }
            this.placeUnder(next, subgraph);
        }
        if (!graph.edgeSet().isEmpty()) {
            throw new AbstractSolver.GraphCycleException();
        }
    }

    @Override
    public SingleInheritanceSolver<V, E> solve() throws Solver.UnsatisfiableStateException {
        return (SingleInheritanceSolver)super.solve();
    }

    @Override
    protected void solve(DirectedGraph<V, E> graph) throws Solver.UnsatisfiableStateException {
        this.placeUnder(this.root, graph);
        assert (graph.vertexSet().isEmpty());
    }

    protected Deque<V> order(Set<V> unconstrained, V prev) {
        return new LinkedList<V>(unconstrained);
    }
}

