/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.constraints.solvers;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.clyze.jphantom.constraints.solvers.AbstractSolver;
import org.clyze.jphantom.constraints.solvers.Solver;
import org.clyze.jphantom.util.MapFactory;
import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.alg.CycleDetector;
import org.jgrapht.alg.TransitiveClosure;
import org.jgrapht.graph.SimpleDirectedGraph;

public class MultipleInheritanceSolver<V, E>
extends AbstractSolver<V, E, Map<V, List<V>>> {
    private final boolean minimize;

    public MultipleInheritanceSolver(EdgeFactory<V, E> factory, boolean minimize) {
        super(factory, new MapFactory());
        this.minimize = minimize;
    }

    public MultipleInheritanceSolver(DirectedGraph<V, E> graph, boolean minimize) {
        super(graph, new MapFactory());
        this.minimize = minimize;
    }

    public MultipleInheritanceSolver(EdgeFactory<V, E> factory) {
        this(factory, true);
    }

    public MultipleInheritanceSolver(DirectedGraph<V, E> graph) {
        this(graph, true);
    }

    @Override
    public MultipleInheritanceSolver<V, E> solve() throws Solver.UnsatisfiableStateException {
        return (MultipleInheritanceSolver)super.solve();
    }

    @Override
    protected void solve(DirectedGraph<V, E> graph) throws Solver.UnsatisfiableStateException {
        if (new CycleDetector(graph).detectCycles()) {
            throw new AbstractSolver.GraphCycleException();
        }
        if (this.minimize) {
            SimpleDirectedGraph closure = new SimpleDirectedGraph(this.factory);
            Graphs.addGraph((Graph)closure, graph);
            TransitiveClosure.INSTANCE.closeSimpleDirectedGraph(closure);
            block0: for (Object e : new HashSet(graph.edgeSet())) {
                Object source = graph.getEdgeSource(e);
                Object target = graph.getEdgeTarget(e);
                for (Object neighbor : Graphs.successorListOf(graph, (Object)source)) {
                    if (neighbor.equals(target) || !this.removableEdge(source, target) || !closure.containsEdge(neighbor, target)) continue;
                    graph.removeEdge(source, target);
                    continue block0;
                }
            }
        }
        for (Object v : graph.vertexSet()) {
            ((Map)this.solution).put(v, Graphs.successorListOf(graph, v));
        }
    }

    protected final boolean removableEdge(E edge, DirectedGraph<V, E> graph) {
        if (!graph.containsEdge(edge)) {
            throw new IllegalArgumentException();
        }
        return this.removableEdge(graph.getEdgeSource(edge), graph.getEdgeTarget(edge));
    }

    protected final boolean removableEdge(E edge) {
        return this.removableEdge((V)edge, (V)this._graph);
    }

    protected boolean removableEdge(V source, V target) {
        return true;
    }
}

