/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.constraints.solvers;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.clyze.jphantom.constraints.solvers.AbstractSolver;
import org.clyze.jphantom.constraints.solvers.MinClassesStrategy;
import org.clyze.jphantom.constraints.solvers.MultipleInheritanceSolver;
import org.clyze.jphantom.constraints.solvers.SingleInheritanceSolver;
import org.clyze.jphantom.constraints.solvers.Solver;
import org.clyze.jphantom.util.Factory;
import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;
import org.jgrapht.graph.SimpleDirectedGraph;

public abstract class InterfaceSolver<V, E, S>
extends AbstractSolver<V, E, S> {
    private final Strategy<V, E> strategy;
    private final V root;
    protected final boolean minimize;
    protected SingleInheritanceSolver<V, E> classSolver;
    protected MultipleInheritanceSolver<V, E> ifaceSolver;
    private Set<V> classes;

    protected InterfaceSolver(Builder<V, E, S> builder) {
        super(((Builder)builder).graph, ((Builder)builder).factory);
        this.minimize = ((Builder)builder).minimize;
        this.strategy = ((Builder)builder).strategy;
        this.root = ((Builder)builder).root;
    }

    @Override
    public InterfaceSolver<V, E, S> solve() throws Solver.UnsatisfiableStateException {
        return (InterfaceSolver)super.solve();
    }

    public void markClass(V vertex) {
        this._graph.addVertex(vertex);
        this.strategy.markClass(vertex);
    }

    public void markInterface(V vertex) {
        this._graph.addVertex(vertex);
        this.strategy.markInterface(vertex);
    }

    protected boolean inClasses(V vertex) {
        if (this.classes == null) {
            throw new IllegalStateException();
        }
        return this.classes.contains(vertex);
    }

    @Override
    protected final void solve(DirectedGraph<V, E> graph) throws Solver.UnsatisfiableStateException {
        this.classes = this.strategy.classSubsetOf(graph);
        SimpleDirectedGraph igraph = new SimpleDirectedGraph(graph.getEdgeFactory());
        for (Object e : new HashSet(graph.edgeSet())) {
            Object source = graph.getEdgeSource(e);
            Object target = graph.getEdgeTarget(e);
            if (!this.classes.contains(target)) {
                igraph.addVertex(source);
                igraph.addVertex(target);
                igraph.addEdge(source, target);
            } else {
                if (this.classes.contains(source)) continue;
                assert (target.equals(this.root));
            }
            graph.removeEdge(source, target);
        }
        for (Object v : new HashSet(graph.vertexSet())) {
            if (this.classes.contains(v)) continue;
            assert (graph.edgesOf(v).isEmpty());
            graph.removeVertex(v);
            igraph.addVertex(v);
        }
        this.solveClassGraph(graph);
        this.solveInterfaceGraph((DirectedGraph<V, E>)igraph);
        for (Object v : graph.vertexSet()) {
            if (this.classes.contains(v) ? !$assertionsDisabled && !((Map)this.classSolver.getSolution()).containsKey(v) && !v.equals(this.root) : !$assertionsDisabled && !((Map)this.ifaceSolver.getSolution()).containsKey(v)) {
                throw new AssertionError(v);
            }
        }
        this.synthesize();
        this.classes = null;
    }

    protected void solveClassGraph(DirectedGraph<V, E> graph) throws Solver.UnsatisfiableStateException {
        this.classSolver = new SingleInheritanceSolver<V, E>(graph, this.root);
        this.classSolver.solve();
    }

    protected void solveInterfaceGraph(DirectedGraph<V, E> graph) throws Solver.UnsatisfiableStateException {
        this.ifaceSolver = new MultipleInheritanceSolver<V, E>(graph, this.minimize);
        this.ifaceSolver.solve();
    }

    protected abstract void synthesize();

    public static interface Strategy<V, E> {
        public Set<V> classSubsetOf(DirectedGraph<V, E> var1) throws AbstractSolver.GraphCycleException;

        public void markClass(V var1);

        public void markInterface(V var1);
    }

    public static abstract class Builder<V, E, S> {
        private boolean minimize = true;
        private Strategy<V, E> strategy;
        private final DirectedGraph<V, E> graph;
        private final Factory<S> factory;
        private final V root;

        public Builder(V root, Factory<S> factory, DirectedGraph<V, E> graph) {
            this.root = root;
            this.strategy = new MinClassesStrategy(root);
            this.factory = factory;
            this.graph = graph;
        }

        public Builder(V root, Factory<S> factory, EdgeFactory<V, E> efactory) {
            this(root, factory, (DirectedGraph<V, E>)new SimpleDirectedGraph(efactory));
        }

        public Builder<V, E, S> minimize(boolean min) {
            this.minimize = min;
            return this;
        }

        public Builder<V, E, S> strategy(Strategy<V, E> strategy) {
            this.strategy = strategy;
            return this;
        }

        public abstract InterfaceSolver<V, E, S> build();
    }
}

