/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.constraints.solvers;

import org.clyze.jphantom.constraints.solvers.Solver;
import org.clyze.jphantom.util.Factory;
import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.graph.UnmodifiableDirectedGraph;

public abstract class AbstractSolver<V, E, S>
implements Solver<V, E, S> {
    protected boolean solved = false;
    protected S solution;
    private final Factory<S> solutionFactory;
    protected final EdgeFactory<V, E> factory;
    protected final DirectedGraph<V, E> _graph;
    private final DirectedGraph<V, E> unmodifiableGraph;

    public AbstractSolver(EdgeFactory<V, E> factory, Factory<S> solutionFactory) {
        this((DirectedGraph<V, E>)new SimpleDirectedGraph(factory), solutionFactory);
    }

    public AbstractSolver(DirectedGraph<V, E> graph, Factory<S> solutionFactory) {
        this.solutionFactory = solutionFactory;
        this.factory = graph.getEdgeFactory();
        this._graph = graph;
        this.unmodifiableGraph = new UnmodifiableDirectedGraph(graph);
    }

    @Override
    public DirectedGraph<V, E> getConstraintGraph() {
        return this.unmodifiableGraph;
    }

    @Override
    public S getSolution() {
        if (!this.solved) {
            throw new IllegalStateException();
        }
        return this.solution;
    }

    protected abstract void solve(DirectedGraph<V, E> var1) throws Solver.UnsatisfiableStateException;

    @Override
    public AbstractSolver<V, E, S> solve() throws Solver.UnsatisfiableStateException {
        if (this.solved) {
            return this;
        }
        SimpleDirectedGraph backup = new SimpleDirectedGraph(this.factory);
        Graphs.addGraph((Graph)backup, this._graph);
        this.solution = this.solutionFactory.create();
        this.solve((DirectedGraph<V, E>)backup);
        this.solved = true;
        return this;
    }

    @Override
    public void addConstraintEdge(V source, V target) {
        if (!this._graph.containsEdge(source, target)) {
            this.solved = false;
        }
        if (!this._graph.containsVertex(source)) {
            this._graph.addVertex(source);
        }
        if (!this._graph.containsVertex(target)) {
            this._graph.addVertex(target);
        }
        this._graph.addEdge(source, target);
    }

    protected static class GraphCycleException
    extends Solver.UnsatisfiableStateException {
        protected static final long serialVersionUID = 2368453345L;

        protected GraphCycleException() {
        }
    }
}

