/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.constraints.extractors;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.clyze.jphantom.Types;
import org.clyze.jphantom.constraints.extractors.AbstractExtractor;
import org.clyze.jphantom.constraints.solvers.TypeConstraintSolver;
import org.clyze.jphantom.conversions.Conversions;
import org.clyze.jphantom.dataflow.CompoundValue;
import org.clyze.jphantom.dataflow.ExtendedInterpreter;
import org.clyze.jphantom.exc.IllegalBytecodeException;
import org.clyze.jphantom.util.Command;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.util.Printer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeConstraintExtractor
extends AbstractExtractor
implements Opcodes {
    private static final Logger logger = LoggerFactory.getLogger(TypeConstraintExtractor.class);
    private final Analyzer<CompoundValue> analyzer;
    private final Interpreter<CompoundValue> interpreter;
    private String cName;
    private Type returnType;
    private Map<Integer, Type> argTypes;
    private Map<Label, List<Command>> commands;

    public TypeConstraintExtractor(TypeConstraintSolver solver) {
        super(solver);
        this.interpreter = new ExtendedInterpreter(this.hierarchy);
        this.analyzer = new Analyzer(this.interpreter);
    }

    public final void visit(ClassNode node) throws AnalyzerException {
        this.cName = node.name;
        logger.debug("... analyzing class {}", (Object)this.cName);
        for (MethodNode meth : node.methods) {
            logger.debug("  ... Method: {} {}", (Object)meth.name, (Object)meth.desc);
            this.visit(meth);
        }
    }

    public final void visit(MethodNode meth) throws AnalyzerException {
        Type methodType = Type.getMethodType((String)meth.desc);
        this.returnType = methodType.getReturnType();
        this.analyzer.analyze(this.cName, meth);
        MethodConstraintExtractor mv = new MethodConstraintExtractor();
        this.commands = new HashMap<Label, List<Command>>();
        boolean isStatic = (meth.access & 8) > 0;
        this.argTypes = new HashMap<Integer, Type>();
        if (!isStatic) {
            this.argTypes.put(0, Type.getObjectType((String)this.cName));
        }
        int argIndex = isStatic ? 0 : 1;
        for (Type argType : methodType.getArgumentTypes()) {
            this.argTypes.put(argIndex, argType);
            argIndex += argType.getSize();
        }
        if (meth.localVariables != null) {
            for (LocalVariableNode local : meth.localVariables) {
                int index = local.index;
                Type t = Type.getType((String)local.desc);
                if (!this.doesLocalMatchExpected(index, t)) continue;
                Label start = local.start.getLabel();
                Label end = local.end.getLabel();
                MethodConstraintExtractor methodConstraintExtractor = mv;
                ((Object)((Object)methodConstraintExtractor)).getClass();
                MethodConstraintExtractor.LocalVariableAddition addition = methodConstraintExtractor.new MethodConstraintExtractor.LocalVariableAddition(index, t, local.name);
                MethodConstraintExtractor methodConstraintExtractor2 = mv;
                ((Object)((Object)methodConstraintExtractor2)).getClass();
                MethodConstraintExtractor.LocalVariableRemoval removal = methodConstraintExtractor2.new MethodConstraintExtractor.LocalVariableRemoval(index, t, local.name);
                if (!this.commands.containsKey(start)) {
                    this.commands.put(start, new LinkedList());
                }
                if (!this.commands.containsKey(end)) {
                    this.commands.put(end, new LinkedList());
                }
                this.commands.get(start).add(addition);
                this.commands.get(end).add(removal);
            }
        }
        try {
            meth.accept((MethodVisitor)mv);
        }
        catch (Throwable e) {
            if (logger.isTraceEnabled()) {
                for (int i = 0; i <= mv.insnNo; ++i) {
                    logger.trace("Frame at point: {}\n{}", (Object)i, (Object)this.analyzer.getFrames()[i]);
                }
            }
            throw new IllegalBytecodeException.Builder(this.cName).message("Instruction: %d", mv.insnNo).method(meth.name, meth.desc).cause(e).build();
        }
    }

    private boolean doesLocalMatchExpected(int index, Type actualType) {
        if (this.argTypes.containsKey(index)) {
            Type known = this.argTypes.get(index);
            if (actualType.equals((Object)OBJECT) && known.getSize() >= 10) {
                return true;
            }
            try {
                return this.closure.isSubtypeOf(actualType, known);
            }
            catch (Throwable t) {
                return false;
            }
        }
        return true;
    }

    private static class UnreachableCodeException
    extends Exception {
        protected static final long serialVersionUID = 893453456345L;

        private UnreachableCodeException() {
        }
    }

    public class MethodConstraintExtractor
    extends MethodVisitor {
        private int insnNo;
        private Map<Integer, Type> declarations;

        public MethodConstraintExtractor(int api, MethodVisitor mv) {
            super(api, mv);
            this.insnNo = 0;
            this.declarations = new HashMap<Integer, Type>();
        }

        public MethodConstraintExtractor(MethodVisitor mv) {
            this(589824, mv);
        }

        public MethodConstraintExtractor() {
            this(null);
        }

        private void logInstruction(int opcode) {
            this.logInstruction(Printer.OPCODES[opcode]);
        }

        private void logInstruction(String instr) {
            logger.trace("Instruction ({}): {} ", (Object)instr, (Object)this.insnNo);
        }

        private Frame<CompoundValue> getFrame() throws UnreachableCodeException {
            Frame frame = TypeConstraintExtractor.this.analyzer.getFrames()[this.insnNo];
            if (frame == null) {
                throw new UnreachableCodeException();
            }
            return frame;
        }

        private CompoundValue getStack(int i) throws UnreachableCodeException {
            int top = this.getFrame().getStackSize();
            return (CompoundValue)this.getFrame().getStack(top - 1 - i);
        }

        private CompoundValue getLocal(int i) throws UnreachableCodeException {
            int max = this.getFrame().getLocals();
            return i < max ? (CompoundValue)this.getFrame().getLocal(i) : null;
        }

        public void visitInsn(int opcode) {
            this.logInstruction(opcode);
            try {
                switch (opcode) {
                    case 191: {
                        CompoundValue exc = this.getStack(0);
                        this.addConstraint(exc, Types.THROWABLE);
                        break;
                    }
                    case 176: {
                        this.addConstraint(this.getStack(0), TypeConstraintExtractor.this.returnType);
                        break;
                    }
                    case 83: {
                        CompoundValue val = this.getStack(0);
                        CompoundValue arrayObj = this.getStack(2);
                        if (arrayObj.asBasicValue() == null) break;
                        Type arrayType = arrayObj.asBasicValue().getType();
                        int max = this.getFrame().getLocals();
                        for (int i = 0; i < max; ++i) {
                            if (val != this.getFrame().getLocal(i) || !this.declarations.containsKey(i)) continue;
                            Type declaredType = this.declarations.get(i);
                            Type arrayParentType = Type.getType((String)arrayType.getDescriptor().substring(1));
                            this.addConstraint(declaredType, arrayParentType);
                        }
                        break;
                    }
                }
            }
            catch (UnreachableCodeException unreachableCodeException) {
                // empty catch block
            }
            ++this.insnNo;
            super.visitInsn(opcode);
        }

        public void visitIntInsn(int opcode, int operand) {
            this.logInstruction(opcode);
            ++this.insnNo;
            super.visitIntInsn(opcode, operand);
        }

        public void visitVarInsn(int opcode, int var) {
            this.logInstruction(opcode);
            try {
                switch (opcode) {
                    case 25: {
                        if (!this.declarations.containsKey(var)) break;
                        CompoundValue val = this.getLocal(var);
                        Type declaredType = this.declarations.get(var);
                        assert (declaredType != null);
                        if (val != null) {
                            for (BasicValue value : val.values()) {
                                Type actualType = value.getType();
                                if (TypeConstraintExtractor.this.doesLocalMatchExpected(var, declaredType) && TypeConstraintExtractor.this.doesLocalMatchExpected(var, actualType)) {
                                    this.addConstraint(value, declaredType);
                                    continue;
                                }
                                logger.debug("Local variable {} is declared as {} but found {}. Ignoring it.", new Object[]{var, declaredType, actualType});
                            }
                        }
                        break;
                    }
                    case 58: {
                        CompoundValue val = this.getLocal(var);
                        CompoundValue obj = this.getStack(0);
                        if (!this.declarations.containsKey(var)) break;
                        Type declaredType = this.declarations.get(var);
                        assert (declaredType != null);
                        if (obj != null) {
                            for (BasicValue value : obj.values()) {
                                Type actualType = value.getType();
                                if (TypeConstraintExtractor.this.doesLocalMatchExpected(var, declaredType) && TypeConstraintExtractor.this.doesLocalMatchExpected(var, actualType)) {
                                    this.addConstraint(value, declaredType);
                                    continue;
                                }
                                logger.debug("Local variable {} is declared as {} but found {}. Ignoring it.", new Object[]{var, declaredType, actualType});
                            }
                        }
                        break;
                    }
                }
            }
            catch (UnreachableCodeException unreachableCodeException) {
                // empty catch block
            }
            ++this.insnNo;
            super.visitVarInsn(opcode, var);
        }

        public void visitTypeInsn(int opcode, String type) {
            this.logInstruction(opcode);
            ++this.insnNo;
            super.visitTypeInsn(opcode, type);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            this.logInstruction(opcode);
            try {
                switch (opcode) {
                    case 178: {
                        break;
                    }
                    case 180: {
                        CompoundValue obj = this.getStack(0);
                        this.addConstraint(obj, Type.getObjectType((String)owner));
                        break;
                    }
                    case 181: {
                        CompoundValue obj = this.getStack(1);
                        this.addConstraint(obj, Type.getObjectType((String)owner));
                    }
                    case 179: {
                        CompoundValue val = this.getStack(0);
                        this.addConstraint(val, Type.getType((String)desc));
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            catch (UnreachableCodeException unreachableCodeException) {
                // empty catch block
            }
            ++this.insnNo;
            super.visitFieldInsn(opcode, owner, name, desc);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            this.logInstruction(opcode);
            try {
                Type[] args = Type.getArgumentTypes((String)desc);
                int pos = 0;
                for (int i = args.length - 1; i >= 0; --i) {
                    Type formalArg = args[i];
                    CompoundValue actualArg = this.getStack(pos++);
                    this.addConstraint(actualArg, formalArg);
                }
                switch (opcode) {
                    case 183: {
                        if (!"<init>".equals(name)) break;
                    }
                    case 182: 
                    case 185: {
                        CompoundValue receiver = this.getStack(pos);
                        this.addConstraint(receiver, Type.getObjectType((String)owner));
                    }
                    case 184: {
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            catch (UnreachableCodeException unreachableCodeException) {
                // empty catch block
            }
            ++this.insnNo;
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }

        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            this.logInstruction(186);
            ++this.insnNo;
            super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
        }

        public void visitJumpInsn(int opcode, Label label) {
            this.logInstruction(opcode);
            ++this.insnNo;
            super.visitJumpInsn(opcode, label);
        }

        public void visitLabel(Label label) {
            if (TypeConstraintExtractor.this.commands.containsKey(label)) {
                for (Command command : (List)TypeConstraintExtractor.this.commands.get(label)) {
                    command.execute();
                    logger.trace("Label {}: {}", (Object)this.insnNo, (Object)command);
                }
                TypeConstraintExtractor.this.commands.remove(label);
            }
            ++this.insnNo;
            super.visitLabel(label);
        }

        public void visitLdcInsn(Object cst) {
            this.logInstruction(18);
            ++this.insnNo;
            super.visitLdcInsn(cst);
        }

        public void visitIincInsn(int var, int increment) {
            this.logInstruction(132);
            ++this.insnNo;
            super.visitIincInsn(var, increment);
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
            this.logInstruction(170);
            ++this.insnNo;
            super.visitTableSwitchInsn(min, max, dflt, labels);
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            this.logInstruction(171);
            ++this.insnNo;
            super.visitLookupSwitchInsn(dflt, keys, labels);
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            this.logInstruction(197);
            ++this.insnNo;
            super.visitMultiANewArrayInsn(desc, dims);
        }

        public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
            this.logInstruction("frame");
            ++this.insnNo;
            super.visitFrame(type, nLocal, local, nStack, stack);
        }

        public void visitLineNumber(int line, Label start) {
            this.logInstruction("line");
            ++this.insnNo;
            super.visitLineNumber(line, start);
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            if (type != null) {
                this.addConstraint(Type.getObjectType((String)type), Types.THROWABLE);
            }
            super.visitTryCatchBlock(start, end, handler, type);
        }

        public void visitCode() {
            if (TypeConstraintExtractor.this.analyzer.getFrames() == null) {
                throw new IllegalStateException("frames have not been set");
            }
            super.visitCode();
        }

        public void visitEnd() {
            if (this.insnNo != TypeConstraintExtractor.this.analyzer.getFrames().length) {
                throw new IllegalArgumentException("Total Frames (" + TypeConstraintExtractor.this.analyzer.getFrames().length + ") != Number of Instructions (" + this.insnNo + ")");
            }
            for (List commandSet : TypeConstraintExtractor.this.commands.values()) {
                assert (commandSet.isEmpty());
            }
            assert (this.declarations.isEmpty());
            super.visitEnd();
        }

        protected void addConstraint(CompoundValue subtypes, Type supertype) {
            for (BasicValue subtype : subtypes.values()) {
                this.addConstraint(subtype, supertype);
            }
        }

        protected void addConstraint(BasicValue subtype, Type supertype) {
            if (!subtype.equals((Object)BasicValue.UNINITIALIZED_VALUE)) {
                this.addConstraint(subtype.getType(), supertype);
            }
        }

        protected void addConstraint(Type subtype, Type supertype) {
            if (subtype == null) {
                throw new IllegalArgumentException("Null subtype");
            }
            if (supertype == null) {
                throw new IllegalArgumentException("Null supertype");
            }
            Conversions.getAssignmentConversion(subtype, supertype).accept(TypeConstraintExtractor.this);
        }

        public class LocalVariableRemoval
        extends LocalVariableChange {
            public LocalVariableRemoval(int index, Type type, String name) {
                super(index, type, name);
            }

            @Override
            public void execute() {
                assert (MethodConstraintExtractor.this.declarations.containsKey(this.index)) : this.name;
                assert (((Type)MethodConstraintExtractor.this.declarations.get(this.index)).equals((Object)this.type)) : this.name;
                MethodConstraintExtractor.this.declarations.remove(this.index);
            }

            public String toString() {
                return "Removing local variable: " + this.type.getClassName() + " " + this.name + " at slot " + this.index;
            }
        }

        public class LocalVariableAddition
        extends LocalVariableChange {
            public LocalVariableAddition(int index, Type type, String name) {
                super(index, type, name);
            }

            @Override
            public void execute() {
                assert (!MethodConstraintExtractor.this.declarations.containsKey(this.index)) : this.name;
                MethodConstraintExtractor.this.declarations.put(this.index, this.type);
            }

            public String toString() {
                return "Adding local variable: " + this.type.getClassName() + " " + this.name + " at slot " + this.index;
            }
        }

        public abstract class LocalVariableChange
        implements Command {
            protected final int index;
            protected final Type type;
            protected final String name;

            public LocalVariableChange(int index, Type type, String name) {
                this.index = index;
                this.type = type;
                this.name = name;
            }
        }
    }
}

