/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.constraints.extractors;

import org.clyze.jphantom.ArrayTypes;
import org.clyze.jphantom.Types;
import org.clyze.jphantom.constraints.solvers.TypeConstraintSolver;
import org.clyze.jphantom.conversions.Conversion;
import org.clyze.jphantom.conversions.ConversionVisitor;
import org.clyze.jphantom.conversions.Conversions;
import org.clyze.jphantom.conversions.IdentityConversion;
import org.clyze.jphantom.conversions.IllegalConversion;
import org.clyze.jphantom.conversions.NarrowingPrimitiveConversion;
import org.clyze.jphantom.conversions.NullConversion;
import org.clyze.jphantom.conversions.WideningPrimitiveConversion;
import org.clyze.jphantom.conversions.WideningReferenceConversion;
import org.clyze.jphantom.exc.InsolvableConstraintException;
import org.clyze.jphantom.hier.ClassHierarchy;
import org.clyze.jphantom.hier.IncompleteSupertypesException;
import org.clyze.jphantom.hier.closure.CopyingSnapshot;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExtractor
implements ConversionVisitor,
Types {
    protected final TypeConstraintSolver solver;
    protected final ClassHierarchy hierarchy;
    protected final ClassHierarchy.Snapshot closure;
    private static final Logger logger = LoggerFactory.getLogger(AbstractExtractor.class);

    public AbstractExtractor(TypeConstraintSolver solver) {
        this.solver = solver;
        this.hierarchy = solver.getHierarchy();
        this.closure = new CopyingSnapshot(this.hierarchy);
    }

    @Override
    public void visit(IdentityConversion conv) {
    }

    @Override
    public void visit(WideningPrimitiveConversion conv) {
    }

    @Override
    public void visit(NarrowingPrimitiveConversion conv) {
    }

    @Override
    public void visit(IllegalConversion conv) {
        throw new InsolvableConstraintException(conv.asConstraint());
    }

    @Override
    public void visit(NullConversion conv) {
    }

    @Override
    public void visit(WideningReferenceConversion conv) {
        if (conv.to.equals((Object)OBJECT)) {
            return;
        }
        if (conv.from.getSort() == 9 && conv.to.getSort() == 9) {
            Type from = ArrayTypes.elementOf(conv.from);
            Type to = ArrayTypes.elementOf(conv.to);
            Conversion subconv = Conversions.getAssignmentConversion(from, to);
            subconv.accept(this);
        }
        if (conv.from.getSort() == 9 || conv.to.getSort() == 9) {
            return;
        }
        if (this.hierarchy.contains(conv.from) && this.hierarchy.contains(conv.to)) {
            try {
                if (!this.closure.isSubtypeOf(conv.from, conv.to)) {
                    throw new InsolvableConstraintException(conv.asConstraint());
                }
                return;
            }
            catch (IncompleteSupertypesException incompleteSupertypesException) {
                // empty catch block
            }
        }
        conv.asConstraint().accept(this.solver);
        logger.debug("Adding constaint: {}", (Object)conv.asConstraint());
    }
}

