/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.adapters;

import org.clyze.jphantom.methods.MethodSignature;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class MethodAdder
extends ClassVisitor
implements Opcodes {
    private final int mAcc;
    private final String mName;
    private final String mDesc;
    private final String[] mExc;
    private boolean isMethodPresent;
    private boolean iface;

    public MethodAdder(ClassVisitor cv, MethodSignature m) {
        this(cv, m.getAccess(), m.getName(), m.getDescriptor(), m.getExceptionNames());
    }

    public MethodAdder(ClassVisitor cv, int mAcc, String mName, String mDesc) {
        this(cv, mAcc, mName, mDesc, null);
    }

    public MethodAdder(ClassVisitor cv, int mAcc, String mName, String mDesc, String[] mExc) {
        super(589824, cv);
        this.mAcc = mAcc;
        this.mName = mName;
        this.mDesc = mDesc;
        this.mExc = mExc;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (name.equals(this.mName) && desc.equals(this.mDesc)) {
            this.isMethodPresent = true;
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.iface = (access & 0x200) != 0;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public void visitEnd() {
        if (!this.isMethodPresent && this.cv != null) {
            boolean isStatic = (this.mAcc & 8) != 0;
            boolean isAbstract = (this.mAcc & 0x400) != 0;
            MethodVisitor mv = this.cv.visitMethod(this.mAcc, this.mName, this.mDesc, null, this.mExc);
            if (mv != null) {
                if (isStatic || !this.iface && !isAbstract) {
                    int maxStack = 2;
                    int maxLocals = 0;
                    for (Type arg : Type.getArgumentTypes((String)this.mDesc)) {
                        maxLocals += arg.getSize();
                    }
                    mv.visitCode();
                    if (!isStatic) {
                        mv.visitVarInsn(25, 0);
                        ++maxStack;
                        ++maxLocals;
                    }
                    mv.visitInsn(0);
                    String exc = Type.getInternalName(UnsupportedOperationException.class);
                    String desc = Type.getMethodType((Type)Type.VOID_TYPE, (Type[])new Type[0]).getDescriptor();
                    mv.visitTypeInsn(187, exc);
                    mv.visitInsn(89);
                    mv.visitMethodInsn(183, exc, "<init>", desc, this.iface);
                    mv.visitInsn(191);
                    mv.visitMaxs(maxStack, maxLocals);
                }
                mv.visitEnd();
            }
        }
        super.visitEnd();
    }
}

