/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.adapters;

import java.util.HashSet;
import java.util.Set;
import org.clyze.jphantom.ClassMembers;
import org.clyze.jphantom.Options;
import org.clyze.jphantom.Phantoms;
import org.clyze.jphantom.Transformer;
import org.clyze.jphantom.access.ClassAccessEvent;
import org.clyze.jphantom.access.ClassAccessStateMachine;
import org.clyze.jphantom.access.FieldAccessEvent;
import org.clyze.jphantom.access.FieldAccessStateMachine;
import org.clyze.jphantom.access.IllegalTransitionException;
import org.clyze.jphantom.access.MethodAccessEvent;
import org.clyze.jphantom.access.MethodAccessStateMachine;
import org.clyze.jphantom.adapters.AccessAdapter;
import org.clyze.jphantom.adapters.AnnotationAdapter;
import org.clyze.jphantom.adapters.FieldAdder;
import org.clyze.jphantom.adapters.MethodAdder;
import org.clyze.jphantom.adapters.PhantomAdder;
import org.clyze.jphantom.exc.IllegalBytecodeException;
import org.clyze.jphantom.exc.PhantomLookupException;
import org.clyze.jphantom.fields.FieldSignature;
import org.clyze.jphantom.hier.ClassHierarchy;
import org.clyze.jphantom.hier.IncompleteSupertypesException;
import org.clyze.jphantom.hier.closure.PseudoSnapshot;
import org.clyze.jphantom.methods.MethodSignature;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPhantomExtractor
extends ClassVisitor
implements Opcodes {
    protected static final Logger logger = LoggerFactory.getLogger(ClassPhantomExtractor.class);
    private final Set<Type> seenAnnos = new HashSet<Type>();
    private final Phantoms phantoms = Phantoms.V();
    private final ClassHierarchy hierarchy;
    private final ClassMembers members;
    private final SignatureVisitor sv;
    private Type clazz;
    private String mname;
    private String mdesc;

    public ClassPhantomExtractor(int api, ClassVisitor cv, ClassHierarchy hierarchy, ClassMembers members) {
        super(api, cv);
        this.hierarchy = hierarchy;
        this.members = members;
        this.sv = new PhantomAdder(hierarchy, members, this.phantoms);
    }

    public ClassPhantomExtractor(ClassVisitor cv, ClassHierarchy hierarchy, ClassMembers members) {
        this(589824, cv, hierarchy, members);
    }

    public ClassPhantomExtractor(ClassHierarchy hierarchy, ClassMembers members) {
        this(null, hierarchy, members);
    }

    private boolean hasPhantomSupertype(Type type) {
        if (!this.hierarchy.contains(type)) {
            throw new IllegalArgumentException();
        }
        try {
            new PseudoSnapshot(this.hierarchy).getAllSupertypes(type);
        }
        catch (IncompleteSupertypesException exc) {
            for (Type i : exc.getSupertypes()) {
                new SignatureReader("" + i).acceptType(this.sv);
            }
            return true;
        }
        return false;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (superName != null) {
            Type sc = Type.getObjectType((String)superName);
            new SignatureReader("" + sc).acceptType(this.sv);
        }
        if (interfaces != null) {
            for (String i : interfaces) {
                Type iface = Type.getObjectType((String)i);
                new SignatureReader("" + iface).acceptType(this.sv);
            }
        }
        this.clazz = Type.getObjectType((String)name);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    private void visitAnnotationClass(Type klass) {
        new SignatureReader(klass.toString()).acceptType(this.sv);
        if (this.seenAnnos.add(klass) && !this.hierarchy.contains(klass)) {
            assert (this.phantoms.contains(klass)) : klass;
            Transformer tr = this.phantoms.getTransformer(klass);
            ClassAccessEvent event = ClassAccessEvent.IS_ANNOTATION;
            ClassAccessStateMachine.v().getEventSequence(klass).moveTo(event).getCurrentAccess();
            assert (tr.top != null);
            tr.top = new AnnotationAdapter(tr.top);
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return new AnnotationPhantomExtractor(desc, super.visitAnnotation(desc, visible));
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        return new AnnotationPhantomExtractor(desc, super.visitTypeAnnotation(typeRef, typePath, desc, visible));
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        Type phantom = Type.getType((String)desc);
        new SignatureReader(phantom.toString()).acceptType(this.sv);
        return new FieldPhantomExtractor(super.visitField(access, name, desc, signature, value));
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        this.mname = name;
        this.mdesc = desc;
        if (exceptions != null) {
            for (String type : exceptions) {
                Type exc = Type.getObjectType((String)type);
                new SignatureReader(exc.toString()).acceptType(this.sv);
            }
        }
        new SignatureReader(desc).accept(this.sv);
        return new MethodPhantomExtractor(super.visitMethod(access, name, desc, signature, exceptions));
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        Type inner = Type.getObjectType((String)name);
        new SignatureReader("" + inner).acceptType(this.sv);
        if (outerName != null) {
            new SignatureReader("" + Type.getObjectType((String)outerName)).acceptType(this.sv);
        }
        if (!this.hierarchy.contains(inner)) {
            assert (this.phantoms.contains(inner)) : inner;
            Transformer tr = this.phantoms.getTransformer(inner);
            assert (tr.top != null);
        }
    }

    private class MethodPhantomExtractor
    extends MethodVisitor {
        public MethodPhantomExtractor() {
            super(ClassPhantomExtractor.this.api);
        }

        public MethodPhantomExtractor(MethodVisitor mv) {
            super(ClassPhantomExtractor.this.api, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            block15: {
                Type phantom = Type.getObjectType((String)owner);
                new SignatureReader(phantom.toString()).acceptType(ClassPhantomExtractor.this.sv);
                new SignatureReader(desc).accept(ClassPhantomExtractor.this.sv);
                if (phantom.getSort() != 9) {
                    boolean abstractMethod;
                    block16: {
                        abstractMethod = itf;
                        if (ClassPhantomExtractor.this.hierarchy.contains(phantom)) {
                            try {
                                if (ClassPhantomExtractor.this.hasPhantomSupertype(phantom)) {
                                    MethodSignature sign = ClassPhantomExtractor.this.members.lookupMethod(phantom, name, desc);
                                    if (sign == null) {
                                        abstractMethod = true;
                                        sign = ClassPhantomExtractor.this.members.lookupInterfaceMethod(phantom, name, desc);
                                        if (sign == null) {
                                            throw new IllegalBytecodeException.Builder(ClassPhantomExtractor.this.clazz).method(ClassPhantomExtractor.this.mname, ClassPhantomExtractor.this.mdesc).message("Method Lookup failed (%s): %s %s", phantom, desc, name).build();
                                        }
                                    } else if (!sign.getDescriptor().equals(desc)) {
                                        throw new IllegalBytecodeException.Builder(ClassPhantomExtractor.this.clazz).method(ClassPhantomExtractor.this.mname, ClassPhantomExtractor.this.mdesc).message("Descriptors differ: %s != %s", desc, sign.getDescriptor()).build();
                                    }
                                }
                                break block15;
                            }
                            catch (PhantomLookupException exc) {
                                logger.trace("Found missing method reference in {}: {} {}", new Object[]{phantom, desc, name});
                                logger.trace("First supertype: {}", (Object)exc.missingClass());
                                phantom = exc.missingClass();
                                if ($assertionsDisabled || phantom != null) break block16;
                                throw new AssertionError();
                            }
                        }
                    }
                    if (!Options.V().isSoftFail()) assert (ClassPhantomExtractor.this.phantoms.contains(phantom)) : phantom;
                    Transformer tr = ClassPhantomExtractor.this.phantoms.getTransformer(phantom);
                    MethodAccessEvent eventMAcc = new MethodAccessEvent.Builder().setOpcode(abstractMethod ? 185 : opcode).setDescriptor(desc).setName(name).build();
                    if (itf) {
                        ClassAccessEvent eventItf = ClassAccessEvent.IS_INTERFACE;
                        int access = ClassAccessStateMachine.v().getEventSequence(phantom).moveTo(eventItf).getCurrentAccess();
                        assert (tr.top != null);
                        tr.top = new AccessAdapter(tr.top, access);
                    }
                    try {
                        int access = MethodAccessStateMachine.v().getEventSequence(name, phantom, desc).moveTo(eventMAcc).getCurrentAccess();
                        assert (tr.top != null);
                        tr.top = new MethodAdder(tr.top, access, name, desc);
                    }
                    catch (IllegalTransitionException exc) {
                        throw new IllegalBytecodeException.Builder(ClassPhantomExtractor.this.clazz).method(ClassPhantomExtractor.this.mname, ClassPhantomExtractor.this.mdesc).cause(exc).build();
                    }
                }
            }
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }

        public void visitTypeInsn(int opcode, String type) {
            new SignatureReader(Type.getObjectType((String)type).toString()).acceptType(ClassPhantomExtractor.this.sv);
            super.visitTypeInsn(opcode, type);
        }

        public void visitLdcInsn(Object cst) {
            if (cst instanceof Type) {
                new SignatureReader(((Type)cst).toString()).acceptType(ClassPhantomExtractor.this.sv);
            }
            super.visitLdcInsn(cst);
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            new SignatureReader(desc).acceptType(ClassPhantomExtractor.this.sv);
            super.visitMultiANewArrayInsn(desc, dims);
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            new SignatureReader(desc).acceptType(ClassPhantomExtractor.this.sv);
            super.visitLocalVariable(name, desc, signature, start, end, index);
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            if (type != null) {
                Type exc = Type.getObjectType((String)type);
                new SignatureReader(exc.toString()).acceptType(ClassPhantomExtractor.this.sv);
            }
            super.visitTryCatchBlock(start, end, handler, type);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new AnnotationPhantomExtractor(desc, super.visitAnnotation(desc, visible));
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return new AnnotationPhantomExtractor(desc, super.visitTypeAnnotation(typeRef, typePath, desc, visible));
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            return new AnnotationPhantomExtractor(desc, super.visitParameterAnnotation(parameter, desc, visible));
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            block11: {
                Type phantom = Type.getObjectType((String)owner);
                new SignatureReader(phantom.toString()).acceptType(ClassPhantomExtractor.this.sv);
                new SignatureReader(desc).acceptType(ClassPhantomExtractor.this.sv);
                if (phantom.getSort() != 9) {
                    if (ClassPhantomExtractor.this.hierarchy.contains(phantom)) {
                        try {
                            if (ClassPhantomExtractor.this.hasPhantomSupertype(phantom)) {
                                FieldSignature sign;
                                FieldSignature fieldSignature = sign = opcode == 178 || opcode == 179 ? ClassPhantomExtractor.this.members.lookupStaticField(phantom, name) : ClassPhantomExtractor.this.members.lookupField(phantom, name);
                                if (sign == null) {
                                    throw new IllegalBytecodeException.Builder(ClassPhantomExtractor.this.clazz).method(ClassPhantomExtractor.this.mname, ClassPhantomExtractor.this.mdesc).message("Field Lookup failed (%s): %s %s", phantom, desc, name).build();
                                }
                                if (!sign.getDescriptor().equals(desc) && !this.isSubtypeOf(sign.getType(), Type.getType((String)desc))) {
                                    throw new IllegalBytecodeException.Builder(ClassPhantomExtractor.this.clazz).method(ClassPhantomExtractor.this.mname, ClassPhantomExtractor.this.mdesc).message("Descriptors differ: %s != %s", desc, sign.getDescriptor()).build();
                                }
                            }
                            break block11;
                        }
                        catch (PhantomLookupException exc) {
                            logger.trace("Found missing field reference in {}: {} {}", new Object[]{phantom, desc, name});
                            phantom = exc.missingClass();
                        }
                    }
                    if (!Options.V().isSoftFail()) assert (ClassPhantomExtractor.this.phantoms.contains(phantom)) : phantom;
                    Transformer tr = ClassPhantomExtractor.this.phantoms.getTransformer(phantom);
                    FieldAccessEvent event = new FieldAccessEvent.Builder().setOpcode(opcode).setDescriptor(desc).setName(name).build();
                    try {
                        int access = FieldAccessStateMachine.v().getEventSequence(name, phantom).moveTo(event).getCurrentAccess();
                        assert (tr.top != null);
                        tr.top = new FieldAdder(tr.top, access, name, desc);
                    }
                    catch (IllegalTransitionException exc) {
                        throw new IllegalBytecodeException.Builder(ClassPhantomExtractor.this.clazz).method(ClassPhantomExtractor.this.mname, ClassPhantomExtractor.this.mdesc).cause(exc).build();
                    }
                }
            }
            super.visitFieldInsn(opcode, owner, name, desc);
        }

        private boolean isSubtypeOf(Type type, Type supertype) {
            try {
                if (this.isSubtypeOf(ClassPhantomExtractor.this.hierarchy.getSuperclass(type), supertype)) {
                    for (Type itf : ClassPhantomExtractor.this.hierarchy.getInterfaces(type)) {
                        if (!this.isSubtypeOf(itf, supertype)) continue;
                        return true;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }
    }

    private class FieldPhantomExtractor
    extends FieldVisitor {
        public FieldPhantomExtractor() {
            super(ClassPhantomExtractor.this.api);
        }

        public FieldPhantomExtractor(FieldVisitor fv) {
            super(ClassPhantomExtractor.this.api, fv);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new AnnotationPhantomExtractor(desc, super.visitAnnotation(desc, visible));
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return new AnnotationPhantomExtractor(desc, super.visitTypeAnnotation(typeRef, typePath, desc, visible));
        }
    }

    private class AnnotationPhantomExtractor
    extends AnnotationVisitor {
        private final Type phantom;

        public AnnotationPhantomExtractor(String desc, AnnotationVisitor annotationVisitor) {
            super(ClassPhantomExtractor.this.api, annotationVisitor);
            this.phantom = Type.getType((String)desc);
            ClassPhantomExtractor.this.visitAnnotationClass(this.phantom);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return new AnnotationPhantomExtractor(desc, super.visitAnnotation(name, desc));
        }

        public void visit(String name, Object value) {
            block9: {
                String desc;
                Type phantom;
                block10: {
                    phantom = this.phantom;
                    Class<?> cls = value.getClass();
                    desc = "()" + Type.getType(cls).getDescriptor();
                    if (ClassPhantomExtractor.this.hierarchy.contains(phantom)) {
                        try {
                            MethodSignature sign = ClassPhantomExtractor.this.members.lookupInterfaceMethod(phantom, name, desc);
                            if (sign == null) {
                                sign = this.lookupBackup(phantom, name, cls);
                            }
                            if (sign == null) {
                                throw new IllegalBytecodeException.Builder(ClassPhantomExtractor.this.clazz).message("Annotation method Lookup failed (%s): %s %s", phantom, desc, name).build();
                            }
                            break block9;
                        }
                        catch (PhantomLookupException exc) {
                            logger.trace("Found missing method reference in {}: {} {}", new Object[]{phantom, desc, name});
                            logger.trace("First supertype: {}", (Object)exc.missingClass());
                            phantom = exc.missingClass();
                            if ($assertionsDisabled || phantom != null) break block10;
                            throw new AssertionError();
                        }
                    }
                }
                assert (ClassPhantomExtractor.this.phantoms.contains(phantom)) : phantom;
                Transformer tr = ClassPhantomExtractor.this.phantoms.getTransformer(phantom);
                MethodAccessEvent event = new MethodAccessEvent.Builder().setOpcode(185).setDescriptor(desc).setName(name).build();
                try {
                    int access = MethodAccessStateMachine.v().getEventSequence(name, phantom, desc).moveTo(event).getCurrentAccess();
                    assert (tr.top != null);
                    tr.top = new MethodAdder(tr.top, access, name, desc);
                }
                catch (IllegalTransitionException exc) {
                    throw new IllegalBytecodeException.Builder(ClassPhantomExtractor.this.clazz).method(ClassPhantomExtractor.this.mname, ClassPhantomExtractor.this.mdesc).cause(exc).build();
                }
            }
            super.visit(name, value);
        }

        private MethodSignature lookupBackup(Type phantom, String name, Class<?> cls) throws PhantomLookupException {
            if (cls.equals(Type.class)) {
                cls = Class.class;
            } else if (cls.equals(Byte.class)) {
                cls = Byte.TYPE;
            } else if (cls.equals(Boolean.class)) {
                cls = Boolean.TYPE;
            } else if (cls.equals(Character.class)) {
                cls = Character.TYPE;
            } else if (cls.equals(Short.class)) {
                cls = Short.TYPE;
            } else if (cls.equals(Integer.class)) {
                cls = Integer.TYPE;
            } else if (cls.equals(Long.class)) {
                cls = Long.TYPE;
            } else if (cls.equals(Float.class)) {
                cls = Float.TYPE;
            } else if (cls.equals(Double.class)) {
                cls = Double.TYPE;
            }
            String desc = "()" + Type.getType(cls).getDescriptor();
            return ClassPhantomExtractor.this.members.lookupInterfaceMethod(phantom, name, desc);
        }

        public void visitEnum(String name, String descriptor, String value) {
            super.visitEnum(name, descriptor, value);
        }

        public AnnotationVisitor visitArray(String name) {
            return super.visitArray(name);
        }
    }
}

