/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.access;

import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import java.util.HashMap;
import java.util.Map;
import org.clyze.jphantom.access.AccessStateMachine;
import org.clyze.jphantom.access.Event;
import org.clyze.jphantom.access.MethodAccessEvent;
import org.clyze.jphantom.access.State;
import org.clyze.jphantom.constraints.IsaClassConstraint;
import org.clyze.jphantom.constraints.IsanInterfaceConstraint;
import org.objectweb.asm.Type;

public class MethodAccessStateMachine
extends AccessStateMachine {
    public static final State INIT_STATE = new State(2).asPublic();
    public static final State VIRTUAL_STATE = new State().asPublic();
    public static final State STATIC_STATE = new State(8).asPublic();
    public static final State INTERFACE_STATE = new State(1024).asPublic();
    private final Table<State, Event, State> transitions = new ImmutableTable.Builder().put((Object)INIT_STATE, (Object)new Event(182), (Object)VIRTUAL_STATE).put((Object)INIT_STATE, (Object)new Event(183), (Object)VIRTUAL_STATE).put((Object)INIT_STATE, (Object)new Event(184), (Object)STATIC_STATE).put((Object)INIT_STATE, (Object)new Event(185), (Object)INTERFACE_STATE).put((Object)VIRTUAL_STATE, (Object)new Event(182), (Object)VIRTUAL_STATE).put((Object)VIRTUAL_STATE, (Object)new Event(183), (Object)VIRTUAL_STATE).put((Object)STATIC_STATE, (Object)new Event(184), (Object)STATIC_STATE).put((Object)INTERFACE_STATE, (Object)new Event(185), (Object)INTERFACE_STATE).build();
    public static MethodAccessStateMachine instance = new MethodAccessStateMachine();
    private Map<String, EventSequence> sequences = new HashMap<String, EventSequence>();

    protected Table<State, Event, State> delegate() {
        return this.transitions;
    }

    protected MethodAccessStateMachine() {
        super(INIT_STATE);
    }

    public static MethodAccessStateMachine v() {
        return instance;
    }

    public static void refresh() {
        instance = new MethodAccessStateMachine();
    }

    public EventSequence getEventSequence(String methodName, Type owner, String desc) {
        String key = owner.getClassName() + ":" + methodName + " " + desc;
        if (!this.sequences.containsKey(key)) {
            this.sequences.put(key, new EventSequence(methodName, owner, desc));
        }
        return this.sequences.get(key);
    }

    public class EventSequence
    extends AccessStateMachine.EventSequence {
        private final String methodName;
        private final Type owner;
        private final String desc;

        private EventSequence(String name, Type owner, String desc) {
            super(MethodAccessStateMachine.this);
            this.methodName = name;
            this.owner = owner;
            this.desc = desc;
        }

        protected EventSequence checkDescriptor(String descriptor) {
            if (!this.desc.equals(descriptor)) {
                throw new IllegalStateException("Method '" + this.owner.getClassName() + " " + this.methodName + "' has multiple descriptors: " + this.desc + " " + descriptor);
            }
            return this;
        }

        public EventSequence moveTo(MethodAccessEvent event) {
            super.moveTo(event);
            switch (event.getOpcode()) {
                case 184: {
                    break;
                }
                case 182: 
                case 183: {
                    MethodAccessStateMachine.this.addConstraint(new IsaClassConstraint(this.owner));
                    break;
                }
                case 185: {
                    MethodAccessStateMachine.this.addConstraint(new IsanInterfaceConstraint(this.owner));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return this.checkDescriptor(event.desc);
        }
    }
}

