/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom;

import com.google.common.collect.ForwardingSet;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.clyze.jphantom.Transformer;
import org.clyze.jphantom.methods.MethodLookupTable;
import org.objectweb.asm.Type;

public class Phantoms
extends ForwardingSet<Type> {
    private static Phantoms instance = new Phantoms();
    private final Map<Type, Transformer> transformers = new HashMap<Type, Transformer>();
    private final MethodLookupTable mtable = new MethodLookupTable();

    public static Phantoms V() {
        return instance;
    }

    public static void refresh() {
        instance = new Phantoms();
    }

    private Phantoms() {
    }

    protected Set<Type> delegate() {
        return this.transformers.keySet();
    }

    public Transformer getTransformer(Type type) {
        if (!this.transformers.containsKey(type)) {
            Transformer tr = new Transformer(type);
            MethodLookupTable methodLookupTable = this.mtable;
            methodLookupTable.getClass();
            tr.top = methodLookupTable.new MethodLookupTable.CachingAdapter(tr.top);
            this.transformers.put(type, tr);
        }
        return this.transformers.get(type);
    }

    public MethodLookupTable getLookupTable() {
        return this.mtable;
    }

    public Map<Type, byte[]> generateClasses() throws IOException {
        HashMap<Type, byte[]> map = new HashMap<Type, byte[]>();
        for (Map.Entry<Type, Transformer> e : this.transformers.entrySet()) {
            Type key = e.getKey();
            byte[] bytes = e.getValue().transform();
            map.put(key, bytes);
        }
        return map;
    }
}

