/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.clyze.jphantom.Driver;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;
import org.slf4j.LoggerFactory;

public class Options {
    private static final FileSystem fs = FileSystems.getDefault();
    private static final Logger logger = (Logger)LoggerFactory.getLogger((String)"jphantom");
    private static final Level[] levels = new Level[]{Level.OFF, Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG, Level.TRACE, Level.ALL};
    private static final Options INSTANCE = new Options();
    public static final int ASM_VER = 589824;
    @Option(name="-v", aliases={"--log", "--verbose"}, handler=LevelOptionHandler.class, usage="Level of verbosity")
    private Level logLevel = Level.INFO;
    @Option(name="--debug", usage="Debug mode")
    private boolean debug = false;
    @Option(name="-d", metaVar="<dir>", usage="Phantom-classes destination directory", handler=DirectoryOptionHandler.class)
    private Path outDir = fs.getPath("out/phantoms/", new String[0]);
    @Option(name="--save-class-files", usage="Save phantom class files")
    private boolean saveClasses = false;
    @Option(name="--help", usage="Help")
    private boolean help = false;
    @Option(name="--soft-fail", usage="Attempt to recover partial results from conflicts")
    private boolean softFail = false;
    @Option(name="-java-version", metaVar="<ver>", usage="Java version to target, defaulting to 5")
    private int javaVersion = 5;
    @Option(name="-o", metaVar="<outjar>", usage="the destination path of the complemented jar", handler=PathOptionHandler.class)
    private Path target = fs.getPath("out.jar", new String[0]);
    @Argument(required=true, metaVar="<injar>", usage="the jar to be complemented", handler=PathOptionHandler.class)
    private Path source;

    public static Options V() {
        return INSTANCE;
    }

    protected Options() {
    }

    public Path getDestinationDir() {
        return this.outDir;
    }

    public Path getSource() {
        return this.source;
    }

    public Path getTarget() {
        return this.target;
    }

    public boolean getHelp() {
        return this.help;
    }

    public boolean isSoftFail() {
        return this.softFail;
    }

    public void setSoftFail(boolean softFail) {
        this.softFail = softFail;
    }

    public Level getLevel() {
        return this.logLevel;
    }

    public void setLogLevel(Level logLevel) {
        this.logLevel = logLevel;
    }

    public int getJavaVersion() {
        return this.javaVersion;
    }

    public void setJavaVersion(int javaVersion) {
        this.javaVersion = javaVersion;
    }

    public boolean purgeClassFiles() {
        return !this.saveClasses;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Path outDir = this.getDestinationDir();
        builder.append("  Destination directory: ").append(outDir).append('\n');
        builder.append("  Logging Level: ").append(this.logLevel).append('\n');
        builder.append("  Source Jar File: ").append(this.source).append('\n');
        builder.append("  Target Jar File: ").append(this.target).append('\n');
        return builder.toString();
    }

    static {
        logger.setLevel(Options.INSTANCE.logLevel);
    }

    public static class LevelOptionHandler
    extends OptionHandler<Level> {
        public LevelOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super Level> setter) {
            super(parser, option, setter);
        }

        public int parseArguments(Parameters params) throws CmdLineException {
            try {
                int start = 0;
                int end = levels.length - 1;
                int i = Integer.parseInt(params.getParameter(0));
                if (i < start || i > end) {
                    throw new CmdLineException(this.owner, i + " out of [" + start + "," + end + "] range");
                }
                Level lvl = levels[i];
                this.setter.addValue((Object)lvl);
                assert (Driver.logger != null);
                logger.setLevel(lvl);
            }
            catch (NumberFormatException exc) {
                throw new CmdLineException(this.owner, (Throwable)exc);
            }
            return 1;
        }

        public String getDefaultMetaVariable() {
            return "N";
        }
    }

    public static class DirectoryOptionHandler
    extends PathOptionHandler {
        public DirectoryOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super Path> setter) {
            super(parser, option, setter);
        }

        @Override
        public int parseArguments(Parameters params) throws CmdLineException {
            try {
                Path dir = fs.getPath(params.getParameter(0), new String[0]);
                if (Files.exists(dir, new LinkOption[0]) && !Files.isDirectory(dir, new LinkOption[0])) {
                    throw new CmdLineException(this.owner, "'" + params.getParameter(0) + "' is not a directory");
                }
                this.setter.addValue((Object)dir);
            }
            catch (InvalidPathException exc) {
                throw new CmdLineException(this.owner, (Throwable)exc);
            }
            return 1;
        }

        @Override
        public String getDefaultMetaVariable() {
            return "<dir>";
        }
    }

    public static class PathOptionHandler
    extends OptionHandler<Path> {
        public PathOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super Path> setter) {
            super(parser, option, setter);
        }

        public int parseArguments(Parameters params) throws CmdLineException {
            try {
                Path path = fs.getPath(params.getParameter(0), new String[0]);
                this.setter.addValue((Object)path);
            }
            catch (InvalidPathException exc) {
                throw new CmdLineException(this.owner, (Throwable)exc);
            }
            return 1;
        }

        public String getDefaultMetaVariable() {
            return "<path>";
        }
    }
}

