/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.clyze.jphantom.ClassMembers;
import org.clyze.jphantom.Driver;
import org.clyze.jphantom.Options;
import org.clyze.jphantom.Phantoms;
import org.clyze.jphantom.Transformer;
import org.clyze.jphantom.access.ClassAccessStateMachine;
import org.clyze.jphantom.access.FieldAccessStateMachine;
import org.clyze.jphantom.access.MethodAccessStateMachine;
import org.clyze.jphantom.adapters.InnerClassAdapter;
import org.clyze.jphantom.adapters.InterfaceAdder;
import org.clyze.jphantom.adapters.InterfaceTransformer;
import org.clyze.jphantom.adapters.MethodAdder;
import org.clyze.jphantom.adapters.PhantomAdder;
import org.clyze.jphantom.adapters.SuperclassAdapter;
import org.clyze.jphantom.constraints.Constraint;
import org.clyze.jphantom.constraints.extractors.TypeConstraintExtractor;
import org.clyze.jphantom.constraints.solvers.BasicSolver;
import org.clyze.jphantom.constraints.solvers.ConstraintStoringSolver;
import org.clyze.jphantom.constraints.solvers.ForwardingSolver;
import org.clyze.jphantom.constraints.solvers.PruningSolver;
import org.clyze.jphantom.constraints.solvers.Solver;
import org.clyze.jphantom.hier.ClassHierarchies;
import org.clyze.jphantom.hier.ClassHierarchy;
import org.clyze.jphantom.hier.PrintableClassHierarchy;
import org.clyze.jphantom.hier.UnmodifiableClassHierarchy;
import org.clyze.jphantom.methods.MethodDeclarations;
import org.clyze.jphantom.methods.MethodLookupTable;
import org.clyze.jphantom.methods.MethodSignature;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPhantom {
    protected static final Logger logger = LoggerFactory.getLogger(Driver.class);
    private final Phantoms phantoms = Phantoms.V();
    private final Map<Type, ClassNode> nodes;
    private final ClassHierarchy hierarchy;
    private final ClassMembers members;
    private Map<Type, byte[]> generated;

    public JPhantom(Map<Type, ClassNode> nodes, ClassHierarchy hierarchy, ClassMembers members) {
        this.nodes = nodes;
        this.hierarchy = new UnmodifiableClassHierarchy(hierarchy);
        this.members = members;
        PhantomAdder visitor = new PhantomAdder(hierarchy, members, this.phantoms);
        for (Type unknown : ClassHierarchies.unknownTypes(hierarchy)) {
            new SignatureReader("" + unknown).acceptType((SignatureVisitor)visitor);
        }
        for (Type unknown : ClassHierarchies.unknownTypes(hierarchy)) {
            assert (this.phantoms.contains(unknown));
        }
    }

    public void run() throws IOException {
        ClassHierarchy solution;
        ForwardingSolver solver = new ConstraintStoringSolver(new BasicSolver.Builder().hierarchy(this.hierarchy).build());
        solver = new PruningSolver(solver);
        TypeConstraintExtractor extractor = new TypeConstraintExtractor(solver);
        for (ClassNode node : this.nodes.values()) {
            try {
                extractor.visit(node);
            }
            catch (AnalyzerException e) {
                throw new RuntimeException(e);
            }
        }
        for (Constraint c : FieldAccessStateMachine.v().getConstraints()) {
            c.accept(solver);
        }
        for (Constraint c : MethodAccessStateMachine.v().getConstraints()) {
            c.accept(solver);
        }
        for (Constraint c : ClassAccessStateMachine.v().getConstraints()) {
            c.accept(solver);
        }
        for (Constraint c : solver.getConstraints()) {
            logger.info("Constraint: {}", (Object)c);
        }
        try {
            solution = (ClassHierarchy)solver.solve().getSolution();
        }
        catch (Solver.UnsatisfiableStateException exc) {
            throw new RuntimeException(exc);
        }
        logger.info("Found Solution: \n\n{}", (Object)new PrintableClassHierarchy(solution));
        this.addSupertypes(solution);
        this.generated = this.phantoms.generateClasses();
        this.fillLookupTable(solution);
        this.addMissingMethods(solution, new MethodDeclarations(solution, this.phantoms.getLookupTable()));
        this.addInnerOuterRelations();
    }

    private void fillLookupTable(ClassHierarchy solution) throws IOException {
        for (Type t : solution) {
            if (this.phantoms.contains(t)) continue;
            MethodLookupTable.CachingAdapter visitor = this.phantoms.getLookupTable().new MethodLookupTable.CachingAdapter();
            if (this.nodes.containsKey(t)) {
                this.nodes.get(t).accept((ClassVisitor)visitor);
                continue;
            }
            new ClassReader(t.getInternalName()).accept((ClassVisitor)visitor, 0);
        }
    }

    private void addSupertypes(ClassHierarchy solution) {
        for (Type p : solution) {
            if (this.hierarchy.contains(p)) continue;
            if (!Options.V().isSoftFail()) assert (this.phantoms.contains(p)) : p;
            Transformer tr = this.phantoms.getTransformer(p);
            assert (tr.top != null);
            tr.top = solution.isInterface(p) ? new InterfaceTransformer(tr.top) : new SuperclassAdapter(tr.top, solution.getSuperclass(p));
            tr.top = new InterfaceAdder(tr.top, solution.getInterfaces(p));
        }
    }

    private void addMissingMethods(ClassHierarchy solution, MethodDeclarations declarations) {
        Iterator iterator = this.phantoms.iterator();
        while (iterator.hasNext()) {
            Type p = (Type)iterator.next();
            Set<MethodSignature> pending = declarations.getPending(p);
            if (pending == null) {
                assert (!solution.contains(p));
                continue;
            }
            if (pending.isEmpty()) continue;
            for (MethodSignature m : pending) {
                logger.debug("Adding method {} to \"{}\"", (Object)m, (Object)p.getClassName());
                ClassWriter cw = new ClassWriter(0);
                MethodAdder cv = new MethodAdder((ClassVisitor)cw, m);
                ClassReader cr = new ClassReader(this.generated.get(p));
                cr.accept((ClassVisitor)cv, 0);
                this.generated.put(p, cw.toByteArray());
            }
        }
    }

    private void addInnerOuterRelations() {
        Map<String, Type> typeLookup = this.phantoms.stream().collect(Collectors.toMap(Type::getInternalName, t -> t));
        Iterator iterator = this.phantoms.iterator();
        while (iterator.hasNext()) {
            Type p = (Type)iterator.next();
            String name = p.getInternalName();
            int innerIndex = name.lastIndexOf(36);
            if (innerIndex <= 0) continue;
            try {
                String outer = name.substring(0, innerIndex);
                ClassReader cr = new ClassReader(this.generated.get(p));
                int access = cr.getAccess();
                ClassWriter cw = new ClassWriter(0);
                InnerClassAdapter cv = new InnerClassAdapter((ClassVisitor)cw, name, access);
                cr.accept((ClassVisitor)cv, 0);
                this.generated.put(p, cw.toByteArray());
                p = typeLookup.get(outer);
                if (p == null) continue;
                cw = new ClassWriter(0);
                cv = new InnerClassAdapter((ClassVisitor)cw, name, access);
                cr = new ClassReader(this.generated.get(p));
                cr.accept((ClassVisitor)cv, 0);
                this.generated.put(p, cw.toByteArray());
            }
            catch (Throwable throwable) {}
        }
    }

    public Map<Type, byte[]> getGenerated() {
        return this.generated;
    }
}

