/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.clyze.jphantom.Types;
import org.clyze.jphantom.exc.PhantomLookupException;
import org.clyze.jphantom.fields.FieldSignature;
import org.clyze.jphantom.hier.ClassHierarchy;
import org.clyze.jphantom.hier.IncompleteSupertypesException;
import org.clyze.jphantom.hier.closure.PseudoSnapshot;
import org.clyze.jphantom.methods.MethodSignature;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class ClassMembers
implements Opcodes,
Types {
    private final Map<Type, Record> records = new HashMap<Type, Record>();
    private final ClassHierarchy hierarchy;
    private final Random rand = new Random(System.currentTimeMillis());

    private ClassMembers(ClassHierarchy hierarchy) {
        this.hierarchy = hierarchy;
    }

    public FieldSignature lookupField(Type clazz, String fieldName) throws PhantomLookupException {
        if (!this.records.containsKey(clazz)) {
            throw new IllegalArgumentException("" + clazz);
        }
        return this.records.get(clazz).lookupField(fieldName);
    }

    public FieldSignature lookupStaticField(Type clazz, String fieldName) throws PhantomLookupException {
        if (!this.records.containsKey(clazz)) {
            throw new IllegalArgumentException("" + clazz);
        }
        return this.records.get(clazz).lookupSField(fieldName);
    }

    public MethodSignature lookupMethod(Type clazz, String methodName, String methodDesc) throws PhantomLookupException {
        if (!this.records.containsKey(clazz)) {
            throw new IllegalArgumentException(clazz + " not contained in key set");
        }
        return this.records.get(clazz).lookupMethod(methodName, methodDesc);
    }

    public MethodSignature lookupInterfaceMethod(Type clazz, String methodName, String methodDesc) throws PhantomLookupException {
        if (!this.records.containsKey(clazz)) {
            throw new IllegalArgumentException(clazz + " not contained in key set");
        }
        return this.records.get(clazz).lookupIMethod(methodName, methodDesc);
    }

    public static ClassMembers fromJar(String jarname, ClassHierarchy hierarchy) throws IOException {
        return ClassMembers.fromJar(new JarFile(jarname), hierarchy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassMembers fromJar(JarFile file, ClassHierarchy hierarchy) throws IOException {
        try {
            ClassMembers repo = new ClassMembers(hierarchy);
            new ClassReader(OBJECT.getInternalName()).accept((ClassVisitor)repo.new Feeder(), 0);
            Enumeration<JarEntry> e = file.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
                InputStream stream = file.getInputStream(entry);
                Throwable throwable = null;
                try {
                    ClassReader reader = new ClassReader(stream);
                    reader.accept((ClassVisitor)repo.new Feeder(), 0);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            ClassMembers classMembers = repo;
            return classMembers;
        }
        finally {
            file.close();
        }
    }

    public class Feeder
    extends ClassVisitor
    implements Opcodes {
        private Type clazz;

        public Feeder(int api, ClassVisitor cv) {
            super(api, cv);
        }

        public Feeder(int api) {
            super(api);
        }

        public Feeder(ClassVisitor cv) {
            this(589824, cv);
        }

        public Feeder() {
            this(589824);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.clazz = Type.getObjectType((String)name);
            ClassMembers.this.records.put(this.clazz, new Record(this.clazz));
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodSignature sign = new MethodSignature.Builder(name, desc).access(access).exceptions(exceptions).build();
            ((Record)ClassMembers.this.records.get(this.clazz)).addMethod(name, sign);
            return super.visitMethod(access, name, desc, signature, exceptions);
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            FieldSignature sign = new FieldSignature.Builder(name, desc).access(access).build();
            ((Record)ClassMembers.this.records.get(this.clazz)).addField(name, sign);
            return super.visitField(access, name, desc, signature, value);
        }
    }

    private class Record {
        private final Type type;
        private final Map<String, FieldSignature> fields = new HashMap<String, FieldSignature>();
        private final Map<String, MethodSignature> methods = new HashMap<String, MethodSignature>();

        public Record(Type type) {
            this.type = type;
        }

        private String mkey(String name, String desc) {
            return name + "::" + desc;
        }

        protected void addField(String name, FieldSignature sign) {
            this.fields.put(name, sign);
        }

        protected void addMethod(String name, MethodSignature sign) {
            this.methods.put(this.mkey(name, sign.getDescriptor()), sign);
        }

        public FieldSignature lookupField(String name) throws PhantomLookupException {
            Record rec = this;
            while (rec != null) {
                if (rec.fields.containsKey(name)) {
                    return rec.fields.get(name);
                }
                Type sc = ClassMembers.this.hierarchy.getSuperclass(rec.type);
                if (sc == null) {
                    assert (rec.type.equals((Object)Types.OBJECT));
                    break;
                }
                if (!ClassMembers.this.hierarchy.contains(sc)) {
                    throw new PhantomLookupException(sc);
                }
                rec = (Record)ClassMembers.this.records.get(sc);
            }
            return null;
        }

        private FieldSignature lookupSField(String name) throws PhantomLookupException {
            Collection<Type> ifaces;
            try {
                ifaces = new PseudoSnapshot(ClassMembers.this.hierarchy).getAllSupertypes(this.type);
            }
            catch (IncompleteSupertypesException exc) {
                ifaces = exc.getSupertypes();
            }
            LinkedList<Type> phantoms = new LinkedList<Type>();
            for (Type iface : ifaces) {
                if (!ClassMembers.this.hierarchy.contains(iface)) {
                    phantoms.add(iface);
                    continue;
                }
                Record rec = (Record)ClassMembers.this.records.get(iface);
                assert (rec != null);
                if (!rec.fields.containsKey(name)) continue;
                return rec.fields.get(name);
            }
            Collections.shuffle(phantoms, ClassMembers.this.rand);
            if (!phantoms.isEmpty()) {
                throw new PhantomLookupException((Type)phantoms.get(0));
            }
            return null;
        }

        public MethodSignature lookupMethod(String name, String desc) throws PhantomLookupException {
            block6: {
                Type sc;
                Record rec = this;
                if (ClassMembers.this.hierarchy.isInterface(rec.type)) {
                    return this.lookupIMethod(name, desc);
                }
                while (true) {
                    String key;
                    if (rec.methods.containsKey(key = this.mkey(name, desc))) {
                        return rec.methods.get(key);
                    }
                    sc = ClassMembers.this.hierarchy.getSuperclass(rec.type);
                    if (sc == null) {
                        assert (rec.type.equals((Object)Types.OBJECT));
                        break block6;
                    }
                    if (!ClassMembers.this.hierarchy.contains(sc)) {
                        throw new PhantomLookupException(sc);
                    }
                    rec = (Record)ClassMembers.this.records.get(sc);
                    assert (rec != null) : "Missing record for: " + sc;
                }
            }
            return null;
        }

        private MethodSignature lookupIMethod(String name, String desc) throws PhantomLookupException {
            Collection<Type> ifaces;
            String key = this.mkey(name, desc);
            try {
                ifaces = new PseudoSnapshot(ClassMembers.this.hierarchy).getAllSupertypes(this.type);
            }
            catch (IncompleteSupertypesException exc) {
                ifaces = exc.getSupertypes();
            }
            LinkedList<Type> phantoms = new LinkedList<Type>();
            for (Type iface : ifaces) {
                if (!ClassMembers.this.hierarchy.contains(iface)) {
                    phantoms.add(iface);
                    continue;
                }
                Record rec = (Record)ClassMembers.this.records.get(iface);
                assert (rec != null);
                if (!rec.methods.containsKey(key)) continue;
                return rec.methods.get(key);
            }
            Collections.shuffle(phantoms, ClassMembers.this.rand);
            if (!phantoms.isEmpty()) {
                throw new PhantomLookupException((Type)phantoms.get(0));
            }
            return null;
        }
    }
}

