/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.clyze.jphantom.util.Factory;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;

public class GraphUtils {
    private GraphUtils() {
        throw new AssertionError();
    }

    public static <G extends DirectedGraph<V, E>, V, E> G getSubgraph(G baseGraph, Factory<G> factory, Set<? extends V> vertexSubset, Set<? extends E> edgeSubset) {
        DirectedGraph subgraph = (DirectedGraph)factory.create();
        if (vertexSubset == null) {
            vertexSubset = baseGraph.vertexSet();
        }
        for (Object vertex : vertexSubset) {
            if (baseGraph.containsVertex(vertex)) continue;
            throw new IllegalArgumentException();
        }
        if (edgeSubset == null) {
            HashSet<E> tmp = new HashSet<E>();
            for (Object vertex : vertexSubset) {
                tmp.addAll(baseGraph.edgesOf(vertex));
            }
            edgeSubset = tmp;
        }
        for (V edge : edgeSubset) {
            if (baseGraph.containsEdge(edge) && vertexSubset.contains(baseGraph.getEdgeSource(edge)) && vertexSubset.contains(baseGraph.getEdgeTarget(edge))) continue;
            throw new IllegalArgumentException();
        }
        Graphs.addAllVertices((Graph)subgraph, (Collection)vertexSubset);
        Graphs.addAllEdges((Graph)subgraph, baseGraph, edgeSubset);
        return (G)subgraph;
    }
}

