/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.methods;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.clyze.jphantom.exc.IllegalBytecodeException;
import org.clyze.jphantom.methods.MethodSignature;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class MethodLookupTable
extends HashMap<Type, Set<MethodSignature>> {
    protected static final long serialVersionUID = 834573459345L;
    protected int pendingAdapters = 0;

    public MethodLookupTable() {
    }

    public MethodLookupTable(MethodLookupTable other) {
        super(other);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry e : this.entrySet()) {
            builder.append("Methods of: ").append(e.getKey()).append('\n');
            for (MethodSignature n : (Set)e.getValue()) {
                builder.append("   ").append(n).append("\n");
            }
        }
        return builder.toString();
    }

    public class CachingAdapter
    extends ClassVisitor
    implements Opcodes {
        private Type clazz;

        public CachingAdapter(int api, ClassVisitor cv) {
            super(api, cv);
            ++MethodLookupTable.this.pendingAdapters;
        }

        public CachingAdapter(int api) {
            super(api);
            ++MethodLookupTable.this.pendingAdapters;
        }

        public CachingAdapter(ClassVisitor cv) {
            this(589824, cv);
        }

        public CachingAdapter() {
            this(589824);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if (this.clazz != null) {
                throw new IllegalStateException();
            }
            this.clazz = Type.getObjectType((String)name);
            MethodLookupTable.this.put(this.clazz, new HashSet());
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            try {
                ((Set)MethodLookupTable.this.get(this.clazz)).add(new MethodSignature.Builder(name, desc).access(access).exceptions(exceptions).build());
            }
            catch (RuntimeException exc) {
                throw new IllegalBytecodeException.Builder(this.clazz).method(name, desc).cause(exc).build();
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }

        public void visitEnd() {
            super.visitEnd();
            --MethodLookupTable.this.pendingAdapters;
        }
    }
}

