/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.hier;

import org.clyze.jphantom.hier.ClassHierarchy;
import org.objectweb.asm.Type;

public abstract class AbstractClassHierarchy
implements ClassHierarchy {
    protected static final Type checkedObject(Type obj) {
        if (obj.getSort() != 10) {
            throw new IllegalArgumentException(obj + " is not an object type");
        }
        return obj;
    }

    protected final Type checkedContainedObject(Type obj) {
        if (!this.contains(AbstractClassHierarchy.checkedObject(obj))) {
            throw new TypeNotPresentException(obj.getClassName(), null);
        }
        return obj;
    }

    protected final Type checkedContainedClass(Type obj) {
        if (this.isInterface(obj)) {
            throw new IllegalArgumentException(obj + " is not a class");
        }
        return obj;
    }

    protected final Type checkedContainedInterface(Type obj) {
        if (!this.isInterface(obj)) {
            throw new IllegalArgumentException(obj + " is not an interface");
        }
        return obj;
    }

    protected final Type checkedClass(Type obj) {
        return this.contains(obj) ? this.checkedContainedClass(obj) : AbstractClassHierarchy.checkedObject(obj);
    }

    protected final Type checkedInterface(Type obj) {
        return this.contains(obj) ? this.checkedContainedInterface(obj) : AbstractClassHierarchy.checkedObject(obj);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Type t : this) {
            boolean iface = this.isInterface(t);
            builder.append(iface ? "interface " : "class ").append(t.getClassName()).append('\n');
            Type sc = this.getSuperclass(t);
            if (sc != null && !iface) {
                builder.append("   extends ").append(sc.getClassName()).append('\n');
            }
            for (Type i : this.getInterfaces(t)) {
                builder.append("   ").append(iface ? "extends " : "implements ").append(i.getClassName()).append('\n');
            }
        }
        return builder.toString();
    }
}

