/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.constraints.solvers;

import java.util.HashSet;
import java.util.Set;
import org.clyze.jphantom.constraints.IsaClassConstraint;
import org.clyze.jphantom.constraints.IsanInterfaceConstraint;
import org.clyze.jphantom.constraints.SubtypeConstraint;
import org.clyze.jphantom.constraints.solvers.ForwardingSolver;
import org.clyze.jphantom.constraints.solvers.Solver;
import org.clyze.jphantom.constraints.solvers.TypeConstraintSolver;
import org.clyze.jphantom.hier.ClassHierarchy;
import org.clyze.jphantom.hier.Importer;
import org.clyze.jphantom.hier.IncrementalClassHierarchy;
import org.objectweb.asm.Type;

public class PruningSolver
extends ForwardingSolver {
    private Set<Type> interesting = new HashSet<Type>();

    public PruningSolver(TypeConstraintSolver solver) {
        super(solver);
    }

    @Override
    public TypeConstraintSolver solve() throws Solver.UnsatisfiableStateException {
        this.setHierarchy(this.prunedHierarchy());
        return super.solve();
    }

    private ClassHierarchy prunedHierarchy() {
        ClassHierarchy hierarchy = this.getHierarchy();
        IncrementalClassHierarchy pruned = new IncrementalClassHierarchy();
        Importer importer = new Importer((ClassHierarchy)pruned, hierarchy);
        for (Type t : this.interesting) {
            if (!hierarchy.contains(t)) continue;
            importer.execute(t);
        }
        return pruned;
    }

    @Override
    public void visit(IsanInterfaceConstraint constraint) {
        this.interesting.add(constraint.type);
        super.visit(constraint);
    }

    @Override
    public void visit(IsaClassConstraint constraint) {
        this.interesting.add(constraint.type);
        super.visit(constraint);
    }

    @Override
    public void visit(SubtypeConstraint constraint) {
        this.interesting.add(constraint.subtype);
        this.interesting.add(constraint.supertype);
        super.visit(constraint);
    }

    @Override
    public void markClass(Type vertex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void markInterface(Type vertex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addConstraintEdge(Type source, Type target) {
        throw new UnsupportedOperationException();
    }
}

