/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.constraints.solvers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.clyze.jphantom.Types;
import org.clyze.jphantom.constraints.Constraint;
import org.clyze.jphantom.constraints.IsaClassConstraint;
import org.clyze.jphantom.constraints.IsanInterfaceConstraint;
import org.clyze.jphantom.constraints.SubtypeConstraint;
import org.clyze.jphantom.constraints.solvers.InterfaceSolver;
import org.clyze.jphantom.constraints.solvers.LayeringSolver;
import org.clyze.jphantom.constraints.solvers.MultipleInheritanceSolver;
import org.clyze.jphantom.constraints.solvers.SingleInheritanceSolver;
import org.clyze.jphantom.constraints.solvers.Solver;
import org.clyze.jphantom.constraints.solvers.TypeConstraintSolver;
import org.clyze.jphantom.exc.ConflictingTypeException;
import org.clyze.jphantom.exc.InsolvableConstraintException;
import org.clyze.jphantom.hier.ClassHierarchies;
import org.clyze.jphantom.hier.ClassHierarchy;
import org.clyze.jphantom.hier.IncompleteSupertypesException;
import org.clyze.jphantom.hier.IncrementalClassHierarchy;
import org.clyze.jphantom.hier.UnmodifiableClassHierarchy;
import org.clyze.jphantom.hier.closure.CopyingSnapshot;
import org.clyze.jphantom.util.Factory;
import org.clyze.jphantom.util.Pair;
import org.jgrapht.DirectedGraph;
import org.objectweb.asm.Type;

public class BasicSolver
extends InterfaceSolver<Type, SubtypeConstraint, ClassHierarchy>
implements Types,
TypeConstraintSolver {
    private static final Random rand = new Random();
    private final Comparator<Type> typeComparator = Comparator.comparingInt(o -> -this._graph.incomingEdgesOf(o).size()).thenComparingInt(o -> rand.nextInt());
    private boolean initialized = false;
    protected ClassHierarchy hierarchy;
    private ClassHierarchy.Snapshot closure = null;

    protected BasicSolver(Builder builder) {
        super(builder);
        this.hierarchy = builder.hierarchy;
    }

    @Override
    public void visit(SubtypeConstraint constraint) {
        this.addConstraintEdge(constraint.subtype, constraint.supertype);
    }

    @Override
    public void visit(IsanInterfaceConstraint constraint) {
        try {
            this.markInterface(constraint.type);
        }
        catch (ConflictingTypeException exc) {
            throw new InsolvableConstraintException(constraint);
        }
    }

    @Override
    public void visit(IsaClassConstraint constraint) {
        try {
            this.markClass(constraint.type);
        }
        catch (ConflictingTypeException exc) {
            throw new InsolvableConstraintException(constraint);
        }
    }

    @Override
    public ClassHierarchy getHierarchy() {
        return this.hierarchy;
    }

    @Override
    public void setHierarchy(ClassHierarchy hierarchy) {
        this.hierarchy = hierarchy;
    }

    @Override
    public Collection<Constraint> getConstraints() {
        throw new UnsupportedOperationException();
    }

    private BasicSolver initialized() {
        this.closure = new CopyingSnapshot(this.hierarchy);
        for (Type clazz : this.hierarchy) {
            for (Type iface : this.hierarchy.getInterfaces(clazz)) {
                this.addConstraintEdge(clazz, iface);
                this.markInterface(iface);
            }
            if (this.hierarchy.isInterface(clazz)) {
                this.markInterface(clazz);
            } else {
                this.markClass(clazz);
            }
            Type sc = this.hierarchy.getSuperclass(clazz);
            if (!clazz.equals((Object)OBJECT)) {
                this.addConstraintEdge(clazz, sc);
                this.markClass(sc);
                continue;
            }
            assert (sc == null);
        }
        this.initialized = true;
        return this;
    }

    @Override
    public BasicSolver solve() throws Solver.UnsatisfiableStateException {
        this.initialized();
        return (BasicSolver)super.solve();
    }

    @Override
    protected void solveClassGraph(DirectedGraph<Type, SubtypeConstraint> graph) throws Solver.UnsatisfiableStateException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        for (Type v : graph.vertexSet()) {
            assert (this.inClasses(v)) : v;
            if (this.hierarchy.contains(v)) assert (!this.hierarchy.isInterface(v)) : v;
        }
        block3: for (SubtypeConstraint e : new HashSet(graph.edgeSet())) {
            Type source = (Type)graph.getEdgeSource((Object)e);
            Type target = (Type)graph.getEdgeTarget((Object)e);
            while (this.hierarchy.contains(source)) {
                assert (!this.hierarchy.isInterface(source));
                Type p = this.hierarchy.getSuperclass(source);
                if (p == null) {
                    assert (source.equals((Object)OBJECT));
                    throw new InsolvableConstraintException(e);
                }
                assert (graph.containsEdge((Object)source, (Object)p)) : p;
                if (p.equals((Object)target)) continue block3;
                source = p;
                this.addConstraintEdge(source, target);
            }
        }
        final boolean[] doShuffle = new boolean[1];
        this.classSolver = new SingleInheritanceSolver<Type, SubtypeConstraint>(graph, OBJECT){

            @Override
            protected Deque<Type> order(Set<Type> unconstrained, Type parent) {
                LinkedList<Type> ordered = new LinkedList<Type>();
                TreeSet<Type> rest = new TreeSet<Type>(BasicSolver.this.typeComparator);
                for (Type t : unconstrained) {
                    if (BasicSolver.this.hierarchy.contains(t)) {
                        Type sc = BasicSolver.this.hierarchy.getSuperclass(t);
                        if (!sc.equals((Object)parent)) {
                            SubtypeConstraint impliedEdge = (SubtypeConstraint)this._graph.getEdgeFactory().createEdge((Object)t, (Object)parent);
                            throw new CrossoverConstraintException(impliedEdge, sc);
                        }
                        ordered.addLast(t);
                        continue;
                    }
                    rest.add(t);
                }
                if (doShuffle[0]) {
                    ArrayList shuffled = new ArrayList(rest);
                    Collections.shuffle(shuffled);
                    ordered.addAll(shuffled);
                    doShuffle[0] = false;
                } else {
                    ordered.addAll(rest);
                }
                return ordered;
            }
        };
        while (true) {
            try {
                this.classSolver.solve();
            }
            catch (CrossoverConstraintException exc) {
                doShuffle[0] = true;
                continue;
            }
            break;
        }
    }

    @Override
    protected void solveInterfaceGraph(DirectedGraph<Type, SubtypeConstraint> graph) throws Solver.UnsatisfiableStateException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        HashSet<SubtypeConstraint> fixedSource = new HashSet<SubtypeConstraint>();
        HashMap domains = new HashMap();
        for (SubtypeConstraint e : new HashSet(graph.edgeSet())) {
            Type source = (Type)graph.getEdgeSource((Object)e);
            Type target = (Type)graph.getEdgeTarget((Object)e);
            if (!this.hierarchy.contains(source) || this.hierarchy.getInterfaces(source).contains(target)) continue;
            try {
                if (!this.closure.isSubtypeOf(source, target)) {
                    throw new Solver.UnsatisfiableStateException();
                }
                graph.removeEdge((Object)source, (Object)target);
            }
            catch (IncompleteSupertypesException ign) {
                fixedSource.add(e);
                try {
                    this.closure.getAllSupertypes(source);
                    throw new InsolvableConstraintException(e);
                }
                catch (IncompleteSupertypesException exc) {
                    ArrayList<Type> projections = new ArrayList<Type>();
                    assert (!exc.getSupertypes().isEmpty());
                    for (Type t : exc.getSupertypes()) {
                        if (this.hierarchy.contains(t)) continue;
                        projections.add(t);
                    }
                    for (Type t : projections) {
                        if (graph.containsVertex((Object)t)) continue;
                        graph.addVertex((Object)t);
                        break;
                    }
                    for (Type t : projections) {
                        assert (graph.containsVertex((Object)t)) : t;
                    }
                    domains.put(source, projections);
                }
            }
        }
        this.ifaceSolver = new LayeringSolver<Type, SubtypeConstraint>(graph, fixedSource, domains, this.minimize){

            @Override
            protected boolean removableEdge(Type source, Type target) {
                if (BasicSolver.this.hierarchy.contains(source) && BasicSolver.this.hierarchy.getInterfaces(source).contains(target)) {
                    return false;
                }
                return super.removableEdge(source, target);
            }
        }.solve();
    }

    @Override
    protected void synthesize() {
        Type v;
        Map classSolution = (Map)this.classSolver.getSolution();
        Map ifaceSolution = (Map)this.ifaceSolver.getSolution();
        for (Map.Entry entry : ifaceSolution.entrySet()) {
            v = (Type)entry.getKey();
            Type[] ifaces = ((List)entry.getValue()).toArray(new Type[0]);
            if (this.inClasses(v)) {
                assert (classSolution.containsKey(v));
                ((ClassHierarchy)this.solution).addClass(v, (Type)classSolution.get(v), ifaces);
                continue;
            }
            assert (!classSolution.containsKey(v));
            ((ClassHierarchy)this.solution).addInterface(v, ifaces);
        }
        for (Map.Entry entry : classSolution.entrySet()) {
            v = (Type)entry.getKey();
            Type sc = (Type)entry.getValue();
            if (((ClassHierarchy)this.solution).contains(v)) {
                assert (((ClassHierarchy)this.solution).getSuperclass(v).equals((Object)sc));
                continue;
            }
            ((ClassHierarchy)this.solution).addClass(v, sc, new Type[0]);
        }
        this.solution = new UnmodifiableClassHierarchy((ClassHierarchy)this.solution);
        this.validateSolution();
    }

    private void validateSolution() {
        for (Type c : this.hierarchy) {
            Type sc1 = ((ClassHierarchy)this.solution).getSuperclass(c);
            Type sc2 = this.hierarchy.getSuperclass(c);
            Set<Type> ifaces1 = ((ClassHierarchy)this.solution).getInterfaces(c);
            Set<Type> ifaces2 = this.hierarchy.getInterfaces(c);
            assert (sc1 == sc2 || sc1.equals((Object)sc2)) : c;
            assert (ifaces1.equals(ifaces2)) : c;
        }
        assert (ClassHierarchies.unknownTypes((ClassHierarchy)this.solution).isEmpty());
    }

    private class RecursiveSolver
    extends MultipleInheritanceSolver<Type, SubtypeConstraint> {
        private final Map<Type, List<Type>> domains;
        private Queue<Pair<Type, Type>> constraints;

        RecursiveSolver(DirectedGraph<Type, SubtypeConstraint> graph, boolean minimize) {
            super(graph, minimize);
            this.domains = new HashMap<Type, List<Type>>();
        }

        @Override
        public void addConstraintEdge(Type source, Type target) {
            throw new UnsupportedOperationException();
        }

        private List<Type> domainOf(Type source) {
            if (!this.domains.containsKey(source)) {
                try {
                    BasicSolver.this.closure.getAllSupertypes(source);
                    this.domains.put(source, Collections.emptyList());
                }
                catch (IncompleteSupertypesException exc) {
                    ArrayList<Type> domain = new ArrayList<Type>();
                    for (Type t : exc.getSupertypes()) {
                        if (BasicSolver.this.hierarchy.contains(t)) continue;
                        domain.add(t);
                    }
                    assert (!domain.isEmpty());
                    this.domains.put(source, domain);
                }
            }
            return this.domains.get(source);
        }

        @Override
        protected void solve(DirectedGraph<Type, SubtypeConstraint> graph) throws Solver.UnsatisfiableStateException {
            this.constraints = new LinkedList<Pair<Type, Type>>();
            for (SubtypeConstraint e : new HashSet(graph.edgeSet())) {
                Type source = (Type)graph.getEdgeSource((Object)e);
                Type target = (Type)graph.getEdgeTarget((Object)e);
                if (!BasicSolver.this.hierarchy.contains(source) || BasicSolver.this.hierarchy.getInterfaces(source).contains(target)) continue;
                graph.removeEdge((Object)source, (Object)target);
                try {
                    if (BasicSolver.this.closure.isSubtypeOf(source, target)) continue;
                    throw new Solver.UnsatisfiableStateException();
                }
                catch (IncompleteSupertypesException ign) {
                    this.constraints.add(new Pair<Type, Type>(source, target));
                }
            }
            if (!this.solveAux(graph)) {
                throw new Solver.UnsatisfiableStateException();
            }
        }

        private boolean solveAux(DirectedGraph<Type, SubtypeConstraint> graph) {
            if (this.constraints.isEmpty()) {
                try {
                    this.solution = new MultipleInheritanceSolver<Type, SubtypeConstraint>(graph, BasicSolver.this.minimize){

                        @Override
                        protected boolean removableEdge(Type source, Type target) {
                            if (BasicSolver.this.hierarchy.contains(source) && BasicSolver.this.hierarchy.getInterfaces(source).contains(target)) {
                                return false;
                            }
                            return super.removableEdge(source, target);
                        }
                    }.solve().getSolution();
                }
                catch (Solver.UnsatisfiableStateException exc) {
                    return false;
                }
                return true;
            }
            Pair<Type, Type> edge = this.constraints.poll();
            Type source = (Type)edge.fst;
            Type target = (Type)edge.snd;
            List<Type> domain = this.domainOf(source);
            for (Type t : domain) {
                if (!graph.containsVertex((Object)t)) {
                    graph.addVertex((Object)t);
                }
                graph.addEdge((Object)t, (Object)target);
                if (this.solveAux(graph)) {
                    return true;
                }
                graph.removeEdge((Object)t, (Object)target);
            }
            return false;
        }
    }

    public class CrossoverConstraintException
    extends InsolvableConstraintException {
        protected static final long serialVersionUID = 8467345638453745L;
        private final Type root;

        private CrossoverConstraintException(SubtypeConstraint constraint, Type root) {
            super(constraint);
            this.root = root;
        }

        public ClassHierarchy getHierarchy() {
            return BasicSolver.this.hierarchy;
        }

        public Type getRoot() {
            return this.root;
        }
    }

    public static class Builder
    extends InterfaceSolver.Builder<Type, SubtypeConstraint, ClassHierarchy> {
        private ClassHierarchy hierarchy = new IncrementalClassHierarchy();

        public Builder(DirectedGraph<Type, SubtypeConstraint> graph) {
            super(Types.OBJECT, Builder.defaultFactory(), graph);
        }

        public Builder() {
            super(Types.OBJECT, Builder.defaultFactory(), SubtypeConstraint.factory);
        }

        public Builder hierarchy(ClassHierarchy hierarchy) {
            this.hierarchy = hierarchy;
            return this;
        }

        public BasicSolver build() {
            return new BasicSolver(this);
        }

        private static Factory<ClassHierarchy> defaultFactory() {
            return new Factory<ClassHierarchy>(){

                @Override
                public ClassHierarchy create() {
                    return new IncrementalClassHierarchy();
                }
            };
        }
    }
}

