/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.adapters;

import java.util.Arrays;
import org.clyze.jphantom.adapters.InterfaceTransformer;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;

public class AnnotationAdapter
extends InterfaceTransformer {
    private static final String ANNO_TYPE = "java/lang/annotation/Annotation";
    private static final String RETENTION = "Ljava/lang/annotation/Retention;";
    private static final String RETENTION_POLICY = "Ljava/lang/annotation/RetentionPolicy;";
    private boolean addRetention = true;

    public AnnotationAdapter(ClassVisitor cv) {
        super(cv);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (!Arrays.asList(interfaces).contains(ANNO_TYPE)) {
            String[] temp = new String[interfaces.length + 1];
            System.arraycopy(interfaces, 0, temp, 0, interfaces.length);
            temp[interfaces.length] = ANNO_TYPE;
            interfaces = temp;
        }
        super.visit(version, access | 0x2000, name, signature, superName, interfaces);
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        if (RETENTION.equals(descriptor)) {
            this.addRetention = false;
        }
        return super.visitAnnotation(descriptor, visible);
    }

    public void visitEnd() {
        if (this.addRetention) {
            this.visitAnnotation(RETENTION, true).visitEnum("value", RETENTION_POLICY, "RUNTIME");
        }
        super.visitEnd();
    }
}

