/*
 * Decompiled with CFR 0.152.
 */
package org.clyze.jphantom.access;

import org.clyze.jphantom.access.Event;

public class MethodAccessEvent
extends Event {
    public final String name;
    public final String desc;

    private MethodAccessEvent(Builder builder) {
        super(builder.opcode);
        this.name = builder.mName;
        this.desc = builder.desc;
    }

    @Override
    public String toString() {
        return "Accessing method: " + this.name + this.desc + " " + super.toString();
    }

    public static class Builder {
        private String mName = null;
        private String desc = null;
        private int opcode = 0;

        public MethodAccessEvent build() {
            return new MethodAccessEvent(this);
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setDescriptor(String desc) {
            this.desc = desc;
            return this;
        }

        public Builder setOpcode(int opcode) {
            switch (opcode) {
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal Method Access Instruction Opcode: " + opcode);
                }
            }
            this.opcode = opcode;
            return this;
        }
    }
}

